/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public enum U3_EqkCatalogStatewideCompleteness {
    STRICT("U3_EqkCatalogStatewideCompleteness.csv"),
    RELAXED("U3_EqkCatalogStatewideCompletenessRelaxed.csv");

    private static final String DIR_NAME = "EarthquakeCatalog";
    private final String fileName;
    private List<Integer> startYears;
    private List<Long> startEpochs;
    private List<Double> mags;

    private U3_EqkCatalogStatewideCompleteness(String fileName) {
        this.fileName = fileName;
    }

    private synchronized void checkLoad() {
        if (this.startYears == null) {
            CSVFile<String> csv;
            InputStream is = UCERF3_DataUtils.locateResourceAsStream(DIR_NAME, this.fileName);
            if (!(is instanceof BufferedInputStream)) {
                is = new BufferedInputStream(is);
            }
            try {
                csv = CSVFile.readStream(is, true);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            this.startYears = new ArrayList<Integer>();
            this.startEpochs = new ArrayList<Long>();
            this.mags = new ArrayList<Double>();
            for (int row = 1; row < csv.getNumRows(); ++row) {
                String startYearStr = csv.get(row, 0);
                int startYear = startYearStr.isEmpty() ? 0 : Integer.parseInt(startYearStr);
                String magStr = csv.get(row, 2);
                if (magStr.isEmpty()) break;
                double mag = Double.parseDouble(magStr);
                this.add(startYear, mag);
            }
        }
    }

    private void add(int year, double mag) {
        if (!this.startYears.isEmpty()) {
            Preconditions.checkState((year > this.startYears.get(this.startYears.size() - 1) ? 1 : 0) != 0, (Object)"years must be monotonically increasing");
            Preconditions.checkState((mag < this.mags.get(this.mags.size() - 1) ? 1 : 0) != 0, (Object)"mag must be monotonically decreasing");
        }
        this.startYears.add(year);
        GregorianCalendar cal = new GregorianCalendar(year, 0, 0);
        this.startEpochs.add(cal.getTimeInMillis());
        this.mags.add(mag);
    }

    public double getMagCompleteForDate(Date date) {
        this.checkLoad();
        return this.getMagCompleteForDate(date.getTime());
    }

    public double getMagCompleteForDate(long epoch) {
        this.checkLoad();
        double mc = Double.NaN;
        for (int i = 0; i < this.startEpochs.size() && epoch >= this.startEpochs.get(i); ++i) {
            mc = this.mags.get(i);
        }
        return mc;
    }

    public double getMagCompleteForYear(int year) {
        this.checkLoad();
        double mc = Double.NaN;
        for (int i = 0; i < this.startYears.size() && year >= this.startYears.get(i); ++i) {
            mc = this.mags.get(i);
        }
        return mc;
    }

    public int getFirstYearForMagComplete(double mag) {
        this.checkLoad();
        int year = -1;
        for (int i = 0; i < this.startYears.size(); ++i) {
            if (!(mag >= this.mags.get(i))) continue;
            year = this.startYears.get(i);
            break;
        }
        return year;
    }

    public ObsEqkRupList getFilteredCatalog(List<? extends ObsEqkRupture> catalog) {
        this.checkLoad();
        ObsEqkRupList filtered = new ObsEqkRupList();
        for (ObsEqkRupture obsEqkRupture : catalog) {
            if (!(obsEqkRupture.getMag() >= this.getMagCompleteForDate(obsEqkRupture.getOriginTime()))) continue;
            filtered.add(obsEqkRupture);
        }
        return filtered;
    }

    public EvenlyDiscretizedFunc getEvenlyDiscretizedMagYearFunc() {
        this.checkLoad();
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(2.55, 8.45, 60);
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, (double)this.getFirstYearForMagComplete(func.getX(i)));
        }
        return func;
    }

    public static void main(String[] args) throws IOException {
        U3_EqkCatalogStatewideCompleteness data = STRICT;
        GraphWindow gw = new GraphWindow(data.getEvenlyDiscretizedMagYearFunc(), "Historical Mc");
        gw.setX_AxisLabel("Magnitude");
        gw.setY_AxisLabel("Year");
        gw.setDefaultCloseOperation(3);
    }
}

