/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils.paleoRateConstraints;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.dom4j.DocumentException;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.U3AverageFaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.inversion.UCERF2_ComparisonSolutionFetcher;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoProbabilityModel;

public class PaleoSiteCorrelationData
implements Serializable {
    private String site1Name;
    private Location site1Loc;
    private int site1SubSect;
    private String site2Name;
    private Location site2Loc;
    private int site2SubSect;
    private int site1Events;
    private int site2Events;
    private int numCorrelated;
    private boolean neighbors;
    private FaultModels fm;
    public static final String SUB_DIR_NAME = "paleoRateData";
    public static final String FILE_NAME = "PaleoCorrelationData_2012_09_28.xls";
    private static final String CONFIDENCE_BOUNDS_UPPER_FILE_NAME = "PaleoCorrelation95ConfidenceUpperBounds.csv";
    private static final String CONFIDENCE_BOUNDS_LOWER_FILE_NAME = "PaleoCorrelation95ConfidenceLowerBounds.csv";
    private static double[][] correlationConfidenceUpperBounds;
    private static double[][] correlationConfidenceLowerBounds;

    public PaleoSiteCorrelationData(String site1Name, Location site1Loc, int site1SubSect, String site2Name, Location site2Loc, int site2SubSect, int site1Events, int site2Events, int numCorrelated, boolean neighbors, FaultModels fm) {
        this.site1Name = site1Name;
        this.site1Loc = site1Loc;
        this.site1SubSect = site1SubSect;
        this.site2Name = site2Name;
        this.site2Loc = site2Loc;
        this.site2SubSect = site2SubSect;
        this.site1Events = site1Events;
        this.site2Events = site2Events;
        this.numCorrelated = numCorrelated;
        this.neighbors = neighbors;
        this.fm = fm;
    }

    public String getSite1Name() {
        return this.site1Name;
    }

    public Location getSite1Loc() {
        return this.site1Loc;
    }

    public int getSite1SubSect() {
        return this.site1SubSect;
    }

    public String getSite2Name() {
        return this.site2Name;
    }

    public Location getSite2Loc() {
        return this.site2Loc;
    }

    public int getSite2SubSect() {
        return this.site2SubSect;
    }

    public int getSite1Events() {
        return this.site1Events;
    }

    public int getSite2Events() {
        return this.site2Events;
    }

    public int getNumCorrelated() {
        return this.numCorrelated;
    }

    public int getTotNumEvents() {
        return this.numCorrelated + (this.site1Events - this.numCorrelated) + (this.site2Events - this.numCorrelated);
    }

    public boolean areNeighbors() {
        return this.neighbors;
    }

    public FaultModels getFaultModel() {
        return this.fm;
    }

    public PaleoSiteCorrelationData getReversed() {
        return new PaleoSiteCorrelationData(this.site2Name, this.site2Loc, this.site2SubSect, this.site1Name, this.site1Loc, this.site1SubSect, this.site2Events, this.site1Events, this.numCorrelated, this.neighbors, this.fm);
    }

    public String getHashString() {
        return this.getSite1Name() + "_" + this.getSite2Name();
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File solFile = new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "FM3_1_ZENG_EllB_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_VarPaleo10_VarMFDSmooth1000_VarSectNuclMFDWt0.01_sol.zip");
        InversionFaultSystemSolution sol = U3FaultSystemIO.loadInvSol(solFile);
        String fileName = solFile.getAbsolutePath().replaceAll(".zip", "") + "_paleo_correlation.xls";
        File outputFile = new File(fileName);
        double[] vals = PaleoSiteCorrelationData.get95PercentConfidenceBounds(5, 8);
        System.out.println(vals[0] + "\t" + vals[1]);
        vals = PaleoSiteCorrelationData.get95PercentConfidenceBounds(5, 10);
        System.out.println(vals[0] + "\t" + vals[1]);
        vals = PaleoSiteCorrelationData.get95PercentConfidenceBounds(3, 8);
        System.out.println(vals[0] + "\t" + vals[1]);
        Map<String, Table<String, String, PaleoSiteCorrelationData>> tables = PaleoSiteCorrelationData.loadPaleoCorrelationData(sol, outputFile);
        for (String faultName : tables.keySet()) {
            PlotSpec spec = PaleoSiteCorrelationData.getCorrelationPlotSpec(faultName, tables.get(faultName), sol);
            double maxX = 0.0;
            for (DiscretizedFunc func : spec.getPlotFunctionsOnly()) {
                double myMaxX = func.getMaxX();
                if (!(myMaxX > maxX)) continue;
                maxX = myMaxX;
            }
            GraphWindow gw = new GraphWindow(spec);
            gw.setAxisRange(0.0, maxX, 0.0, 1.0);
        }
    }

    public static Map<String, Table<String, String, PaleoSiteCorrelationData>> loadPaleoCorrelationData(InversionFaultSystemSolution sol) throws IOException {
        return PaleoSiteCorrelationData.loadPaleoCorrelationData(sol, null);
    }

    public static Map<String, Table<String, String, PaleoSiteCorrelationData>> loadPaleoCorrelationData(InversionFaultSystemSolution sol, File outputFile) throws IOException {
        return PaleoSiteCorrelationData.loadPaleoCorrelationData(UCERF3_DataUtils.locateResourceAsStream(SUB_DIR_NAME, FILE_NAME), sol, outputFile);
    }

    private static String getCellTextNullAsBlank(HSSFSheet sheet, int row, int col) {
        HSSFRow rowObj = sheet.getRow(row);
        if (rowObj == null) {
            return "";
        }
        HSSFCell cell = rowObj.getCell(col);
        if (cell == null) {
            return "";
        }
        return cell.getStringCellValue();
    }

    public static Map<String, Table<String, String, PaleoSiteCorrelationData>> loadPaleoCorrelationData(InputStream dataIS, InversionFaultSystemSolution sol, File outputFile) throws IOException {
        List<? extends FaultSection> faultSectionData = sol.getRupSet().getFaultSectionDataList();
        UCERF3_PaleoProbabilityModel paleoProb = UCERF3_PaleoProbabilityModel.load();
        POIFSFileSystem fs = new POIFSFileSystem(dataIS);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        int lastRowIndex = sheet.getLastRowNum();
        ArrayList ranges = Lists.newArrayList();
        int curStart = -1;
        for (int row = 0; row <= lastRowIndex; ++row) {
            if (curStart < 0 && PaleoSiteCorrelationData.getCellTextNullAsBlank(sheet, row, 1).equals("Latitude")) {
                curStart = row;
                continue;
            }
            if (!PaleoSiteCorrelationData.getCellTextNullAsBlank(sheet, row, 0).isEmpty()) continue;
            if (curStart >= 0) {
                Object range = new int[]{curStart + 1, row - 1};
                ranges.add(range);
            }
            curStart = -1;
        }
        HashMap resultsMap = Maps.newHashMap();
        for (int[] range : ranges) {
            System.out.println("Range: " + range[0] + " => " + range[1]);
            String faultName = sheet.getRow(range[0] - 2).getCell(0).getStringCellValue().trim();
            Preconditions.checkState((!faultName.isEmpty() ? 1 : 0) != 0, (Object)("No name found for range [" + range[0] + "," + range[1] + "]. Data file format change?"));
            Preconditions.checkState((!resultsMap.containsKey(faultName) ? 1 : 0) != 0, (Object)("Duplicate fault name '" + faultName + "' for range [" + range[0] + "," + range[1] + "]. Data file format change?"));
            HashMap subSectIndexMap = Maps.newHashMap();
            HashMap siteLocMap = Maps.newHashMap();
            for (int row = range[0]; row <= range[1]; ++row) {
                HSSFRow theRow = sheet.getRow(row);
                String name = theRow.getCell(0).getStringCellValue().trim();
                double lat = theRow.getCell(1).getNumericCellValue();
                double lon = theRow.getCell(2).getNumericCellValue();
                Location loc = new Location(lat, lon);
                HSSFCell parentOverrideCell = theRow.getCell(3);
                List<Integer> parentOverrides = null;
                if (parentOverrideCell != null && (parentOverrides = U3AveSlipConstraint.loadParentIDs(parentOverrideCell)).isEmpty()) {
                    parentOverrides = null;
                }
                double minDist = Double.MAX_VALUE;
                int closestFaultSectionIndex = -1;
                for (int sectionIndex = 0; sectionIndex < faultSectionData.size(); ++sectionIndex) {
                    double dist;
                    FaultSection data = faultSectionData.get(sectionIndex);
                    if (parentOverrides != null && !parentOverrides.contains(data.getParentSectionId()) || !((dist = data.getFaultTrace().minDistToLine(loc)) < minDist)) continue;
                    minDist = dist;
                    closestFaultSectionIndex = sectionIndex;
                }
                Preconditions.checkState((minDist < 10.0 ? 1 : 0) != 0, (Object)("Min dist to sub sect greater than 10 KM: " + minDist + "\nloc: " + String.valueOf(loc)));
                subSectIndexMap.put(name, closestFaultSectionIndex);
                siteLocMap.put(name, loc);
            }
            int numSites = subSectIndexMap.size();
            HashBasedTable table = HashBasedTable.create((int)numSites, (int)numSites);
            int startCol = 5;
            int endCol = startCol + numSites - 1;
            for (int row = range[0]; row <= range[1]; ++row) {
                int relativeRow = row - range[0];
                HSSFRow theRow = sheet.getRow(row);
                String name1 = theRow.getCell(0).getStringCellValue().trim();
                Integer sectIndex1 = (Integer)subSectIndexMap.get(name1);
                for (int col = startCol; col <= endCol; ++col) {
                    int relativeCol = col - startCol;
                    if (relativeCol == relativeRow || relativeRow > relativeCol) continue;
                    String name2 = sheet.getRow(range[0] - 1).getCell(col).getStringCellValue().trim();
                    Integer sectIndex2 = (Integer)subSectIndexMap.get(name2);
                    Preconditions.checkNotNull((Object)sectIndex2, (Object)("Name not found: " + name2 + " (" + row + "," + col + ")"));
                    HSSFCell correlatedCell = theRow.getCell(col);
                    HSSFCell countsCell = sheet.getRow(range[0] + relativeCol).getCell(startCol + relativeRow);
                    int numCorrelated = (int)correlatedCell.getNumericCellValue();
                    String rawCountsStr = countsCell.getStringCellValue().trim().replaceAll(" ", "");
                    String[] rawCountsSplit = rawCountsStr.split(",");
                    Preconditions.checkState((rawCountsSplit.length == 2 ? 1 : 0) != 0);
                    int site1Count = Integer.parseInt(rawCountsSplit[0]);
                    int site2Count = Integer.parseInt(rawCountsSplit[1]);
                    boolean neighbors = relativeCol == relativeRow + 1;
                    PaleoSiteCorrelationData corr = new PaleoSiteCorrelationData(name1, (Location)siteLocMap.get(name1), sectIndex1, name2, (Location)siteLocMap.get(name2), sectIndex2, site1Count, site2Count, numCorrelated, neighbors, sol.getRupSet().getFaultModel());
                    table.put((Object)name1, (Object)name2, (Object)corr);
                    table.put((Object)name2, (Object)name1, (Object)corr.getReversed());
                    if (outputFile == null) continue;
                    double prob = PaleoSiteCorrelationData.getRateCorrelated(paleoProb, sol, sectIndex1, sectIndex2);
                    int totEvents = corr.getTotNumEvents();
                    correlatedCell.setCellValue(prob);
                    double theirProb = (double)numCorrelated / (double)totEvents;
                    countsCell.setCellValue(theirProb);
                }
            }
            resultsMap.put(faultName, table);
        }
        if (outputFile != null) {
            FileOutputStream fos = new FileOutputStream(outputFile);
            wb.write((OutputStream)fos);
            fos.close();
        }
        return resultsMap;
    }

    public static double getRateCorrelated(PaleoProbabilityModel paleoProb, FaultSystemSolution sol, int sectIndex1, int sectIndex2) {
        double rateTogether = 0.0;
        double totRate = 0.0;
        FaultSystemRupSet rupSet = sol.getRupSet();
        HashSet<Integer> rups1 = new HashSet<Integer>(rupSet.getRupturesForSection(sectIndex1));
        HashSet<Integer> rups2 = new HashSet<Integer>(rupSet.getRupturesForSection(sectIndex2));
        HashSet<Integer> totRups = new HashSet<Integer>();
        totRups.addAll(rups1);
        for (Integer rup : rups2) {
            if (totRups.contains(rup)) continue;
            totRups.add(rup);
        }
        for (Integer rup : totRups) {
            double rate = sol.getRateForRup(rup);
            boolean sect1 = rups1.contains(rup);
            boolean sect2 = rups2.contains(rup);
            Preconditions.checkState((sect1 || sect2 ? 1 : 0) != 0);
            boolean together = sect1 && sect2;
            double prob1 = 0.0;
            double prob2 = 0.0;
            if (sect1) {
                prob1 = paleoProb.getProbPaleoVisible(rupSet, rup, sectIndex1);
            }
            if (sect2) {
                prob2 = paleoProb.getProbPaleoVisible(rupSet, rup, sectIndex2);
            }
            double myRateTogether = 0.0;
            if (together) {
                myRateTogether += rate * prob1 * prob2;
            }
            totRate += rate * (prob1 + prob2) - myRateTogether;
            rateTogether += myRateTogether;
        }
        return rateTogether / totRate;
    }

    public static synchronized double[] get95PercentConfidenceBounds(int numCorrelated, int totalNumEvents) {
        if (correlationConfidenceUpperBounds == null) {
            try {
                int col;
                int row;
                CSVFile<String> upperCSV = CSVFile.readStream(UCERF3_DataUtils.locateResourceAsStream(SUB_DIR_NAME, CONFIDENCE_BOUNDS_UPPER_FILE_NAME), true);
                CSVFile<String> lowerCSV = CSVFile.readStream(UCERF3_DataUtils.locateResourceAsStream(SUB_DIR_NAME, CONFIDENCE_BOUNDS_LOWER_FILE_NAME), true);
                Preconditions.checkState((upperCSV.getNumCols() == lowerCSV.getNumCols() ? 1 : 0) != 0);
                Preconditions.checkState((upperCSV.getNumRows() == lowerCSV.getNumRows() ? 1 : 0) != 0);
                int len = upperCSV.getNumCols() - 1;
                correlationConfidenceUpperBounds = new double[len][len];
                correlationConfidenceLowerBounds = new double[len][len];
                for (row = 0; row < len; ++row) {
                    for (col = 0; col < len; ++col) {
                        PaleoSiteCorrelationData.correlationConfidenceUpperBounds[row][col] = Double.NaN;
                        PaleoSiteCorrelationData.correlationConfidenceLowerBounds[row][col] = Double.NaN;
                    }
                }
                for (row = 1; row < upperCSV.getNumRows(); ++row) {
                    for (col = 1; col < upperCSV.getNumCols(); ++col) {
                        PaleoSiteCorrelationData.correlationConfidenceUpperBounds[row - 1][col - 1] = Double.parseDouble(upperCSV.get(row, col));
                        PaleoSiteCorrelationData.correlationConfidenceLowerBounds[row - 1][col - 1] = Double.parseDouble(lowerCSV.get(row, col));
                    }
                }
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }
        Preconditions.checkState((numCorrelated <= totalNumEvents ? 1 : 0) != 0, (Object)"can't have more correlated than total!");
        Preconditions.checkState((totalNumEvents < correlationConfidenceUpperBounds.length ? 1 : 0) != 0, (Object)("Table too small for given num events: " + totalNumEvents));
        double upper = correlationConfidenceUpperBounds[numCorrelated][totalNumEvents];
        double lower = correlationConfidenceLowerBounds[numCorrelated][totalNumEvents];
        double[] ret = new double[]{lower, upper};
        return ret;
    }

    public static PlotSpec getCorrelationPlotSpec(String faultName, Table<String, String, PaleoSiteCorrelationData> table, FaultSystemSolution sol) throws IOException {
        UCERF3_PaleoProbabilityModel paleoProb = UCERF3_PaleoProbabilityModel.load();
        return PaleoSiteCorrelationData.getCorrelationPlotSpec(faultName, table, sol, (PaleoProbabilityModel)paleoProb);
    }

    public static PlotSpec getCorrelationPlotSpec(String faultName, Table<String, String, PaleoSiteCorrelationData> table, FaultSystemSolution sol, PaleoProbabilityModel paleoProb) {
        List<PaleoSiteCorrelationData> corrs = PaleoSiteCorrelationData.getCorrelataionsToPlot(table);
        ArrayList solValues = Lists.newArrayList();
        for (PaleoSiteCorrelationData corr : corrs) {
            double myRate = PaleoSiteCorrelationData.getRateCorrelated(paleoProb, sol, corr.getSite1SubSect(), corr.getSite2SubSect());
            if (sol instanceof U3AverageFaultSystemSolution) {
                U3AverageFaultSystemSolution avgSol = (U3AverageFaultSystemSolution)sol;
                double minAvgRate = Double.MAX_VALUE;
                double maxAvgRate = 0.0;
                for (FaultSystemSolution subSol : avgSol) {
                    double avgRate = PaleoSiteCorrelationData.getRateCorrelated(paleoProb, subSol, corr.getSite1SubSect(), corr.getSite2SubSect());
                    if (avgRate < minAvgRate) {
                        minAvgRate = avgRate;
                    }
                    if (!(avgRate > maxAvgRate)) continue;
                    maxAvgRate = avgRate;
                }
                double[] vals = new double[]{minAvgRate, maxAvgRate, myRate};
                solValues.add(vals);
                continue;
            }
            double[] vals = new double[]{myRate};
            solValues.add(vals);
        }
        return PaleoSiteCorrelationData.getCorrelationPlotSpec(faultName, corrs, solValues, paleoProb);
    }

    public static List<PaleoSiteCorrelationData> getCorrelataionsToPlot(Table<String, String, PaleoSiteCorrelationData> table) {
        HashSet<CallSite> doneHash = new HashSet<CallSite>();
        ArrayList corrs = Lists.newArrayList();
        for (String name1 : table.rowKeySet()) {
            for (String name2 : table.columnKeySet()) {
                String backwardsHash;
                PaleoSiteCorrelationData corr = (PaleoSiteCorrelationData)table.get((Object)name1, (Object)name2);
                if (name1.equals(name2) || !corr.areNeighbors() || doneHash.contains(backwardsHash = name2 + "___" + name1)) continue;
                String myHash = name1 + "___" + name2;
                doneHash.add((CallSite)((Object)myHash));
                corrs.add(corr);
            }
        }
        Collections.sort(corrs, new Comparator<PaleoSiteCorrelationData>(){

            @Override
            public int compare(PaleoSiteCorrelationData o1, PaleoSiteCorrelationData o2) {
                double lat1 = this.getNorthernmostLat(o1);
                double lat2 = this.getNorthernmostLat(o2);
                return -Double.compare(lat1, lat2);
            }

            private double getNorthernmostLat(PaleoSiteCorrelationData p) {
                double lat2;
                double lat1 = p.getSite1Loc().getLatitude();
                if (lat1 > (lat2 = p.getSite2Loc().getLatitude())) {
                    return lat1;
                }
                return lat2;
            }
        });
        return corrs;
    }

    public static PlotSpec getCorrelationPlotSpec(String faultName, List<PaleoSiteCorrelationData> corrs, List<double[]> solValues, PaleoProbabilityModel paleoProb) {
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        PlotCurveCharacterstics sepChar = new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, Color.BLACK);
        PlotCurveCharacterstics dataChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED);
        PlotCurveCharacterstics dataBoundsChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.RED);
        PlotCurveCharacterstics solChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE);
        PlotCurveCharacterstics solAvgBoundsChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLUE);
        PlotCurveCharacterstics ucerf2Char = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(130, 86, 5));
        HashMap ucerf2Sols = Maps.newHashMap();
        double x = 0.0;
        for (int i = 0; i < corrs.size(); ++i) {
            FaultModels fm;
            PaleoSiteCorrelationData corr = corrs.get(i);
            if (x > 0.0) {
                funcs.add(PaleoSiteCorrelationData.getVerticalLine(x, 0.0, 1.0));
                chars.add(sepChar);
            }
            double dataVal = (double)corr.getNumCorrelated() / (double)corr.getTotNumEvents();
            double[] bounds = PaleoSiteCorrelationData.get95PercentConfidenceBounds(corr.getNumCorrelated(), corr.getTotNumEvents());
            double dist = LocationUtils.horzDistance(corr.getSite1Loc(), corr.getSite2Loc());
            double newX = x + dist;
            String funcNamePrefix = "X: " + x + "=>" + newX + ". Site " + corr.getSite1Name() + " to " + corr.getSite2Name();
            funcs.add(PaleoSiteCorrelationData.getHorizontalLine(dataVal, x, newX, funcNamePrefix + ". Data: " + dataVal));
            chars.add(dataChar);
            funcs.add(PaleoSiteCorrelationData.getHorizontalLine(bounds[0], x, newX, funcNamePrefix + ". Lower Bound: " + bounds[0]));
            chars.add(dataBoundsChar);
            funcs.add(PaleoSiteCorrelationData.getHorizontalLine(bounds[1], x, newX, funcNamePrefix + ". Upper Bound: " + bounds[1]));
            chars.add(dataBoundsChar);
            if (solValues != null) {
                double[] rates = solValues.get(i);
                double myRate = rates[rates.length - 1];
                funcs.add(PaleoSiteCorrelationData.getHorizontalLine(myRate, x, newX, funcNamePrefix + ". Inversion: " + myRate));
                chars.add(solChar);
                if (rates.length > 1) {
                    funcs.add(PaleoSiteCorrelationData.getHorizontalLine(rates[0], x, newX, funcNamePrefix + ". Inversion Min: " + rates[0]));
                    chars.add(solAvgBoundsChar);
                    funcs.add(PaleoSiteCorrelationData.getHorizontalLine(rates[1], x, newX, funcNamePrefix + ". Inversion Max: " + rates[1]));
                    chars.add(solAvgBoundsChar);
                }
            }
            if ((fm = corr.getFaultModel()) != null) {
                FaultSystemSolution ucerf2Sol = (FaultSystemSolution)ucerf2Sols.get(fm);
                if (ucerf2Sol == null) {
                    ucerf2Sol = UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(fm);
                    ucerf2Sols.put(fm, ucerf2Sol);
                }
                double ucerf2Rate = PaleoSiteCorrelationData.getRateCorrelated(paleoProb, ucerf2Sol, corr.getSite1SubSect(), corr.getSite2SubSect());
                funcs.add(PaleoSiteCorrelationData.getHorizontalLine(ucerf2Rate, x, newX, funcNamePrefix + ". UCERF2: " + ucerf2Rate));
                chars.add(ucerf2Char);
            }
            x += dist;
        }
        funcs.add(PaleoSiteCorrelationData.getVerticalLine(x, 0.0, 1.0));
        chars.add(sepChar);
        return new PlotSpec(funcs, chars, "Paleo Site Correlation (" + faultName + ")", "Site Distance (width)", "Fraction Correlated");
    }

    private static ArbitrarilyDiscretizedFunc getVerticalLine(double x, double min, double max) {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.set(x, min);
        func.set(x + 1.0E-6, max);
        func.setName("(separator)");
        return func;
    }

    private static ArbitrarilyDiscretizedFunc getHorizontalLine(double y, double min, double max) {
        return PaleoSiteCorrelationData.getHorizontalLine(y, min, max, null);
    }

    private static ArbitrarilyDiscretizedFunc getHorizontalLine(double y, double min, double max, String name) {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.set(min, y);
        func.set(max, y);
        if (name != null) {
            func.setName(name);
        }
        return func;
    }
}

