/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas;

import edu.usc.kmilner.mpj.taskDispatch.MPJTaskLogStatsGen;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;

public class NodeCalcDebug {
    public static void main(String[] args) throws IOException {
        File logFile = new File(args[0]);
        int node = Integer.parseInt(args[1]);
        BufferedReader read = new BufferedReader(new FileReader(logFile));
        Date prevDate = null;
        HashMap<Integer, Long> calcStartTimes = new HashMap<Integer, Long>();
        for (String line : new MPJTaskLogStatsGen.LogFileIterable(read)) {
            int index;
            String[] split;
            Date date;
            if (!line.contains("Process " + node + "]") || line.contains("batch") || line.contains("binary") || line.contains("output")) continue;
            if (line.contains("]: calculating ")) {
                date = MPJTaskLogStatsGen.parseDate((String)line, prevDate);
                split = line.trim().split(" ");
                index = Integer.parseInt(split[split.length - 1]);
                calcStartTimes.put(index, date.getTime());
                prevDate = date;
                continue;
            }
            if (!line.contains("]: completed ")) continue;
            date = MPJTaskLogStatsGen.parseDate((String)line, prevDate);
            split = (line = line.substring(line.indexOf("]: completed ") + "]: completed ".length()).trim()).split(" ");
            index = Integer.parseInt(split[0]);
            Long startTime = (Long)calcStartTimes.get(index);
            if (startTime == null) {
                System.out.println(index + " ended but no start time");
            } else {
                double time = (double)(date.getTime() - startTime) / 1000.0;
                calcStartTimes.remove(index);
                String rupStr = line.substring(line.indexOf("" + index) + ("" + index).length()).trim();
                System.out.println("index " + index + " took " + (float)time + " " + rupStr);
            }
            prevDate = date;
        }
        read.close();
    }
}

