/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.DocumentException;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.comcat.ComcatAccessor;
import org.opensha.commons.data.comcat.ComcatRegion;
import org.opensha.commons.data.comcat.ComcatRegionAdapter;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.uncertainty.UncertainArbDiscFunc;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.analysis.FaultSysSolutionERF_Calc;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class RidgecrestGarlockPlotGen {
    public static void main(String[] args) throws IOException, DocumentException {
        File baseDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations");
        String[] dirNames = new String[]{"2019_09_04-ComCatM7p1_ci38457511_ShakeMapSurfaces", "2019_09_12-ComCatM7p1_ci38457511_7DaysAfter_ShakeMapSurfaces", "2019_08_19-ComCatM7p1_ci38457511_14DaysAfter_ShakeMapSurfaces-noSpont-full_td-scale1.14", "2019_07_27-ComCatM7p1_ci38457511_21DaysAfter_ShakeMapSurfaces-noSpont-full_td-scale1.14", "2019_08_03-ComCatM7p1_ci38457511_28DaysAfter_ShakeMapSurfaces-noSpont-full_td-scale1.14", "2019_08_19-ComCatM7p1_ci38457511_35DaysAfter_ShakeMapSurfaces-noSpont-full_td-scale1.14", "2019_08_19-ComCatM7p1_ci38457511_42DaysAfter_ShakeMapSurfaces-noSpont-full_td-scale1.14", "2019_08_24-ComCatM7p1_ci38457511_49DaysAfter_ShakeMapSurfaces-noSpont-full_td-scale1.14", "2019_08_31-ComCatM7p1_ci38457511_56DaysAfter_ShakeMapSurfaces", "2019_09_09-ComCatM7p1_ci38457511_63DaysAfter_ShakeMapSurfaces", "2019_09_16-ComCatM7p1_ci38457511_70DaysAfter_ShakeMapSurfaces", "2019_11_04-ComCatM7p1_ci38457511_122DaysAfter_ShakeMapSurfaces", "2020_04_27-ComCatM7p1_ci38457511_296p8DaysAfter_ShakeMapSurfaces", "2020_05_28-ComCatM7p1_ci38457511_327p6DaysAfter_ShakeMapSurfaces", "2020_06_03-ComCatM7p1_ci38457511_334DaysAfter_ShakeMapSurfaces", "2020_06_22-ComCatM7p1_ci38457511_352p9DaysAfter_ShakeMapSurfaces"};
        HashSet<String> highlightProbNames = new HashSet<String>();
        highlightProbNames.add("2020_06_03-ComCatM7p1_ci38457511_334DaysAfter_ShakeMapSurfaces");
        int targetSectID = 341;
        File outputDir = new File("/tmp");
        String prefix = "ridgecrest_garlock_probs";
        double[] dataMinMags = new double[]{5.0};
        PlotCurveCharacterstics[] dataChars = new PlotCurveCharacterstics[]{new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 10.0f, Color.RED.darker())};
        double millsPerDay = 8.64E7;
        double probDays = 30.0;
        long probMillis = (long)(probDays * millsPerDay);
        ArrayList<ETAS_Config> configs = new ArrayList<ETAS_Config>();
        for (String dirName : dirNames) {
            File dir = new File(baseDir, dirName);
            Preconditions.checkState((boolean)dir.exists());
            File configFile = new File(dir, "config.json");
            Preconditions.checkState((boolean)configFile.exists());
            configs.add(ETAS_Config.readJSON(configFile));
        }
        Collections.sort(configs, new Comparator<ETAS_Config>(){

            @Override
            public int compare(ETAS_Config o1, ETAS_Config o2) {
                return Long.compare(o1.getSimulationStartTimeMillis(), o1.getSimulationStartTimeMillis());
            }
        });
        long overallStartMillis = ((ETAS_Config)configs.get(0)).getSimulationStartTimeMillis();
        double totalMaxDays = 365.0;
        double deltaDays = 0.5;
        double minMag = 7.0;
        U3FaultSystemSolution fss = null;
        FaultSystemRupSet rupSet = null;
        FaultSystemSolutionERF erf = null;
        ArrayList<Integer> garlockSources = null;
        ArrayList<ArbitrarilyDiscretizedFunc> etasProbFuncs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        ArbitrarilyDiscretizedFunc tdProbFunc = new ArbitrarilyDiscretizedFunc();
        ArrayList<Double> simStartDaysList = new ArrayList<Double>();
        for (int i = 0; i < configs.size(); ++i) {
            double nextRelStartDays;
            ETAS_Config config = (ETAS_Config)configs.get(i);
            long myStartMillis = config.getSimulationStartTimeMillis();
            long relStartMillis = myStartMillis - overallStartMillis;
            double relStartDays = (double)relStartMillis / millsPerDay;
            if (i == configs.size() - 1) {
                nextRelStartDays = totalMaxDays;
            } else {
                long nextRelMillis = ((ETAS_Config)configs.get(i + 1)).getSimulationStartTimeMillis() - overallStartMillis;
                nextRelStartDays = (double)nextRelMillis / millsPerDay;
            }
            simStartDaysList.add(relStartDays);
            System.out.println("Processing " + config.getSimulationName());
            System.out.println("\tStarts at " + (float)relStartDays + " days");
            System.out.println("\tKeeps until " + (float)nextRelStartDays + " days");
            System.out.println("\tDuration: " + (float)(nextRelStartDays - relStartDays) + " days");
            File resultsFile = new File(config.getOutputDir(), "results_m5_preserve_chain.bin");
            Preconditions.checkState((boolean)resultsFile.exists(), (String)"%s doesn't exist", (Object)resultsFile.getAbsoluteFile());
            if (fss == null) {
                fss = U3FaultSystemIO.loadSol(config.getFSS_File());
                rupSet = ((FaultSystemSolution)fss).getRupSet();
                erf = new FaultSystemSolutionERF_ETAS(fss);
                erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_PREF_BLEND);
                erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
            }
            if (tdProbFunc.size() == 0 || relStartDays - tdProbFunc.getMaxX() > 30.0) {
                System.out.println("\tUpdating TD probs...");
                double startYear = 1970.0 + (double)myStartMillis / 3.15576E10;
                erf.setParameter("Historic Open Interval", startYear - 1875.0);
                erf.getTimeSpan().setStartTimeInMillis(myStartMillis);
                erf.getTimeSpan().setDuration(probDays / 365.25);
                erf.updateForecast();
                if (garlockSources == null) {
                    garlockSources = new ArrayList<Integer>();
                    HashSet<Integer> garlockFSSs = new HashSet<Integer>(rupSet.getRupturesForParentSection(targetSectID));
                    for (int sourceID = 0; sourceID < erf.getNumFaultSystemSources(); ++sourceID) {
                        int fssIndex = erf.getFltSysRupIndexForSource(sourceID);
                        if (!garlockFSSs.contains(fssIndex) || !(rupSet.getMagForRup(fssIndex) >= minMag)) continue;
                        garlockSources.add(sourceID);
                    }
                    System.out.println("Have " + garlockSources.size() + " garlock sources");
                }
                ArrayList<Double> erfProbs = new ArrayList<Double>();
                Iterator sourceID = garlockSources.iterator();
                while (sourceID.hasNext()) {
                    int sourceIndex = (Integer)sourceID.next();
                    for (ProbEqkRupture rup : erf.getSource(sourceIndex)) {
                        erfProbs.add(rup.getProbability());
                    }
                }
                double tdProb = FaultSysSolutionERF_Calc.calcSummedProbs(erfProbs);
                tdProbFunc.set(relStartDays, tdProb);
                System.out.println("\t\tTD prob: " + tdProb);
            }
            List<ETAS_CatalogIO.ETAS_Catalog> catalogs = ETAS_CatalogIO.loadCatalogsBinary(resultsFile, minMag);
            ArrayList<Double> startDaysList = new ArrayList<Double>();
            double startDays = relStartDays;
            while ((float)startDays < (float)nextRelStartDays) {
                startDaysList.add(startDays);
                startDays += deltaDays;
            }
            startDaysList.add(nextRelStartDays);
            ArbitrarilyDiscretizedFunc etasProbFunc = new ArbitrarilyDiscretizedFunc();
            etasProbFuncs.add(etasProbFunc);
            Iterator iterator = startDaysList.iterator();
            while (iterator.hasNext()) {
                double startDays2 = (Double)iterator.next();
                long startMillis = overallStartMillis + (long)(startDays2 * millsPerDay);
                long endMillis = startMillis + probMillis;
                int numWith = 0;
                for (ETAS_CatalogIO.ETAS_Catalog catalog : catalogs) {
                    boolean hasMatch = false;
                    block8: for (ETAS_EqkRupture rup : catalog) {
                        if (hasMatch) break;
                        long timeMillis = rup.getOriginTime();
                        if (timeMillis < startMillis) continue;
                        if (timeMillis >= endMillis) break;
                        int fssIndex = rup.getFSSIndex();
                        if (fssIndex < 0) continue;
                        Preconditions.checkState((rup.getMag() >= minMag ? 1 : 0) != 0);
                        for (FaultSection sect : rupSet.getFaultSectionDataForRupture(fssIndex)) {
                            if (sect.getParentSectionId() != targetSectID) continue;
                            hasMatch = true;
                            continue block8;
                        }
                    }
                    if (!hasMatch) continue;
                    ++numWith;
                }
                double prob = (double)numWith / (double)catalogs.size();
                System.out.println("\t\t" + (float)startDays2 + ": " + 100.0 * prob + " %");
                etasProbFunc.set(startDays2, prob);
            }
        }
        erf.updateForecast();
        double endMillis = (double)overallStartMillis + totalMaxDays * 8.64E7;
        double startYear = 1970.0 + endMillis / 3.15576E10;
        erf.setParameter("Historic Open Interval", startYear - 1875.0);
        erf.getTimeSpan().setStartTimeInMillis((long)endMillis);
        erf.getTimeSpan().setDuration(probDays / 365.25);
        erf.updateForecast();
        ArrayList<Double> erfProbs = new ArrayList<Double>();
        Iterator iterator = garlockSources.iterator();
        while (iterator.hasNext()) {
            int sourceIndex = (Integer)iterator.next();
            for (ProbEqkRupture rup : erf.getSource(sourceIndex)) {
                erfProbs.add(rup.getProbability());
            }
        }
        double tdProb = FaultSysSolutionERF_Calc.calcSummedProbs(erfProbs);
        tdProbFunc.set(totalMaxDays, tdProb);
        ComcatAccessor accessor = new ComcatAccessor();
        Region region = ((ETAS_Config)configs.get((int)0)).getComcatMetadata().region;
        ComcatRegion cReg = region instanceof ComcatRegion ? (ComcatRegion)((Object)region) : new ComcatRegionAdapter(region);
        ObsEqkRupList comcatEvents = accessor.fetchEventList(null, overallStartMillis, (long)endMillis, -10.0, 24.0, cReg, false, false, StatUtils.min((double[])dataMinMags));
        Font annFont = new Font("SansSerif", 1, 16);
        String title = (int)probDays + " Day Garlock M\u2265" + (int)minMag + " Probabilities";
        Range xRange = new Range(0.0, totalMaxDays);
        for (Object logY : (Iterator)new boolean[]{false, true}) {
            int i;
            ArbitrarilyDiscretizedFunc myTDProbFunc;
            String yAxisLabel;
            Range yRange;
            if (logY != false) {
                yRange = new Range(1.0E-4, 0.1);
                yAxisLabel = "Probability";
                myTDProbFunc = tdProbFunc;
            } else {
                yRange = new Range(0.0, 5.0);
                yAxisLabel = "Probability (%)";
                myTDProbFunc = new ArbitrarilyDiscretizedFunc();
                for (Point2D pt : tdProbFunc) {
                    myTDProbFunc.set(pt.getX(), 100.0 * pt.getY());
                }
            }
            ArrayList<AbstractXY_DataSet> funcs = new ArrayList<AbstractXY_DataSet>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            myTDProbFunc.setName("Long-Term Model");
            funcs.add(myTDProbFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
            double maxProb = 0.0;
            double minProb = 1.0;
            ArrayList<XYTextAnnotation> anns = new ArrayList<XYTextAnnotation>();
            for (i = 0; i < etasProbFuncs.size(); ++i) {
                double yLoc;
                ArbitrarilyDiscretizedFunc etasProbFunc = (ArbitrarilyDiscretizedFunc)etasProbFuncs.get(i);
                ArbitrarilyDiscretizedFunc combFunc = new ArbitrarilyDiscretizedFunc();
                ArbitrarilyDiscretizedFunc upperFunc = new ArbitrarilyDiscretizedFunc();
                ArbitrarilyDiscretizedFunc lowerFunc = new ArbitrarilyDiscretizedFunc();
                for (Point2D pt : etasProbFunc) {
                    tdProb = tdProbFunc.getInterpolatedY(pt.getX());
                    double combProb = FaultSysSolutionERF_Calc.calcSummedProbs(tdProb, pt.getY());
                    maxProb = Math.max(combProb, maxProb);
                    minProb = Math.min(combProb, minProb);
                    double[] conf = ETAS_Utils.getBinomialProportion95confidenceInterval(pt.getY(), ((ETAS_Config)configs.get(0)).getNumSimulations());
                    conf[0] = FaultSysSolutionERF_Calc.calcSummedProbs(tdProb, conf[0]);
                    conf[1] = FaultSysSolutionERF_Calc.calcSummedProbs(tdProb, conf[1]);
                    if (logY == false) {
                        combProb *= 100.0;
                        conf[0] = conf[0] * 100.0;
                        conf[1] = conf[1] * 100.0;
                    }
                    combFunc.set(pt.getX(), combProb);
                    lowerFunc.set(pt.getX(), conf[0]);
                    upperFunc.set(pt.getX(), conf[1]);
                }
                UncertainArbDiscFunc confFunc = new UncertainArbDiscFunc(combFunc, lowerFunc, upperFunc);
                funcs.add(0, confFunc);
                chars.add(0, new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, new Color(0, 0, 0, 35)));
                if (i == 0) {
                    combFunc.setName("Short-Term Model");
                }
                funcs.add(combFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
                if (!highlightProbNames.contains(((ETAS_Config)configs.get(i)).getOutputDir().getName())) continue;
                double prob = combFunc.getY(0);
                if (logY != false) {
                    yLoc = prob;
                } else {
                    yLoc = prob;
                    prob /= 100.0;
                }
                XYTextAnnotation upperAnn = new XYTextAnnotation(RidgecrestGarlockPlotGen.towSigFigPercent(prob), combFunc.getMinX() + 2.0, yLoc);
                upperAnn.setTextAnchor(TextAnchor.BOTTOM_LEFT);
                upperAnn.setFont(annFont);
                anns.add(upperAnn);
                DefaultXY_DataSet xy = new DefaultXY_DataSet();
                xy.set(combFunc.getMinX(), yLoc);
                funcs.add(xy);
                chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 3.0f, Color.BLACK));
            }
            for (i = 0; i < simStartDaysList.size(); ++i) {
                double days = (Double)simStartDaysList.get(i);
                DefaultXY_DataSet line = new DefaultXY_DataSet();
                line.set(days, yRange.getLowerBound());
                line.set(days, yRange.getUpperBound());
                if (i == 0) {
                    line.setName("Model Updates");
                }
                funcs.add(line);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, Color.LIGHT_GRAY));
            }
            if (logY != false) {
                DefaultXY_DataSet upper = new DefaultXY_DataSet();
                upper.set(0.0, maxProb);
                upper.set(totalMaxDays, maxProb);
                funcs.add(upper);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, Color.BLACK));
                DefaultXY_DataSet lower = new DefaultXY_DataSet();
                lower.set(0.0, minProb);
                lower.set(totalMaxDays, minProb);
                funcs.add(lower);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, Color.BLACK));
                XYTextAnnotation upperAnn = new XYTextAnnotation(RidgecrestGarlockPlotGen.towSigFigPercent(maxProb), 2.0, maxProb);
                upperAnn.setTextAnchor(TextAnchor.BOTTOM_LEFT);
                upperAnn.setFont(annFont);
                anns.add(upperAnn);
                XYTextAnnotation lowerAnn = new XYTextAnnotation(RidgecrestGarlockPlotGen.towSigFigPercent(minProb), 2.0, minProb);
                lowerAnn.setTextAnchor(TextAnchor.BOTTOM_LEFT);
                lowerAnn.setFont(annFont);
                anns.add(lowerAnn);
                tdProb = tdProbFunc.getMaxY();
                XYTextAnnotation tdAnn = new XYTextAnnotation(RidgecrestGarlockPlotGen.towSigFigPercent(tdProb), 2.0, tdProb);
                tdAnn.setTextAnchor(TextAnchor.BOTTOM_LEFT);
                tdAnn.setFont(annFont);
                tdAnn.setPaint((Paint)Color.BLUE);
                anns.add(tdAnn);
            }
            for (int i2 = 0; i2 < dataMinMags.length; ++i2) {
                double dataY;
                double dataMinMag = dataMinMags[i2];
                DefaultXY_DataSet dataFunc = new DefaultXY_DataSet();
                if (logY != false) {
                    double logLower = Math.log10(yRange.getLowerBound());
                    double logUpper = Math.log10(yRange.getUpperBound());
                    double logLen = logUpper - logLower;
                    dataY = Math.pow(10.0, logLower + 0.975 * logLen);
                } else {
                    dataY = yRange.getLowerBound() + 0.975 * yRange.getLength();
                }
                for (ObsEqkRupture rup : comcatEvents) {
                    if (rup.getMag() < dataMinMag) continue;
                    long time = rup.getOriginTime();
                    long deltaTime = time - overallStartMillis;
                    if (deltaTime < 0L) {
                        deltaTime = 0L;
                    }
                    double rupDeltaDays = (double)deltaTime / millsPerDay;
                    dataFunc.set(rupDeltaDays, dataY);
                }
                if (i2 == dataMinMags.length - 1) {
                    dataFunc.setName("M\u2265" + (int)dataMinMag + " Aftershocks");
                } else {
                    dataFunc.setName("M\u2265" + (int)dataMinMag);
                }
                funcs.add(dataFunc);
                chars.add(dataChars[i2]);
            }
            PlotSpec spec = new PlotSpec(funcs, chars, title, "Days Since M7.1", yAxisLabel);
            spec.setLegendVisible(true);
            spec.setPlotAnnotations(anns);
            TickUnits tus = new TickUnits();
            NumberTickUnit tu = new NumberTickUnit(probDays);
            tus.add((TickUnit)tu);
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            gp.setTickLabelFontSize(18);
            gp.setAxisLabelFontSize(24);
            gp.setPlotLabelFontSize(24);
            gp.setLegendFontSize(22);
            gp.setBackgroundColor(Color.WHITE);
            gp.drawGraphPanel(spec, false, (boolean)logY, xRange, yRange);
            gp.getXAxis().setStandardTickUnits((TickUnitSource)tus);
            File file = new File(outputDir, prefix + (logY != false ? "_log" : ""));
            gp.getChartPanel().setSize(900, 500);
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
            gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        }
    }

    private static String towSigFigPercent(double prob) {
        if ((prob *= 100.0) > 1.0) {
            return new DecimalFormat("0.0").format(prob) + "%";
        }
        if (prob > 0.1) {
            return new DecimalFormat("0.00").format(prob) + "%";
        }
        if (prob > 0.01) {
            return new DecimalFormat("0.000").format(prob) + "%";
        }
        return new DecimalFormat("0.0000").format(prob) + "%";
    }
}

