/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentException;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.AbstractNthRupERF;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.NoFaultsModel.ETAS_Simulator_NoFaults;
import scratch.UCERF3.erf.ETAS.NoFaultsModel.UCERF3_GriddedSeisOnlyERF_ETAS;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.utils.LastEventData;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class StandaloneCalc {
    public static void main(String[] args) throws IOException, DocumentException {
        AbstractNthRupERF erf;
        int[] isCubeInsideFaultPolygon;
        List<int[]> srcAtPointList;
        List<float[]> fractionSrcAtPointList;
        Object simulationName;
        ETAS_EqkRupture mainshockRup;
        double duration = 100.0;
        boolean includeSpontEvents = true;
        int startYear = 2017;
        long ot = Math.round(((double)startYear - 1970.0) * 3.15576E10);
        U3ETAS_ProbabilityModelOptions probModel = U3ETAS_ProbabilityModelOptions.FULL_TD;
        boolean applySubSeisForSupraNucl = true;
        double totRateScaleFactor = 1.14;
        boolean gridSeisCorr = false;
        boolean griddedOnly = false;
        boolean imposeGR = false;
        long randSeed = 1034492315904040044L;
        boolean includeIndirectTriggering = true;
        double gridSeisDiscr = 0.1;
        Location triggerHypo = null;
        double triggerMag = 0.0;
        int fssScenarioRupID = -1;
        File catFile = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/ofr2013-1165_EarthquakeCat.txt");
        File surfsFile = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/finite_fault_mappings.xml");
        File cacheDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/cache_fm3p1_ba");
        boolean generateCaches = false;
        boolean debug = false;
        File outputDir = new File("/tmp/etas_test");
        File solFile = new File("/home/kevin/workspace/opensha-ucerf3/src/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip");
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        ETAS_Simulator.D = debug;
        if (griddedOnly) {
            ETAS_Simulator_NoFaults.D = debug;
        }
        Map<Integer, List<LastEventData>> lastEventData = LastEventData.load();
        U3FaultSystemSolution sol = U3FaultSystemIO.loadSol(solFile);
        FaultSystemRupSet rupSet = ((FaultSystemSolution)sol).getRupSet();
        double[] gridSeisCorrections = null;
        if (gridSeisCorr) {
            File cacheFile = new File(cacheDir, "griddedSeisCorrectionCache");
            System.out.println("Loading gridded seismicity correction cache file from " + cacheFile.getAbsolutePath());
            gridSeisCorrections = MatrixIO.doubleArrayFromFile(cacheFile);
            ETAS_Simulator.correctGriddedSeismicityRatesInERF(sol, false, gridSeisCorrections);
        }
        ETAS_ParameterList params = new ETAS_ParameterList();
        params.setImposeGR(imposeGR);
        params.setU3ETAS_ProbModel(probModel);
        params.setApplyGridSeisCorr(gridSeisCorrections != null);
        params.setApplySubSeisForSupraNucl(applySubSeisForSupraNucl);
        params.setTotalRateScaleFactor(totRateScaleFactor);
        ArrayList histQkList = Lists.newArrayList();
        if (catFile != null) {
            histQkList.addAll(ETAS_Launcher.loadHistoricalCatalog(catFile, surfsFile, sol, ot, null, params.getStatewideCompletenessModel()));
        }
        LastEventData.filterDataAfterTime(lastEventData, ot);
        ETAS_EqkRupture triggerRup = null;
        if (fssScenarioRupID >= 0) {
            mainshockRup = new ETAS_EqkRupture();
            mainshockRup.setOriginTime(ot);
            mainshockRup.setAveRake(rupSet.getAveRakeForRup(fssScenarioRupID));
            mainshockRup.setMag(rupSet.getMagForRup(fssScenarioRupID));
            mainshockRup.setRuptureSurface(rupSet.getSurfaceForRupture(fssScenarioRupID, 1.0));
            mainshockRup.setID(0);
            mainshockRup.setFSSIndex(fssScenarioRupID);
            if (triggerMag > 0.0) {
                mainshockRup.setMag(triggerMag);
            }
            if (triggerHypo != null) {
                mainshockRup.setHypocenterLocation(triggerHypo);
            }
            simulationName = "FSS simulation. M=" + mainshockRup.getMag() + ", fss ID=" + fssScenarioRupID;
            triggerRup = mainshockRup;
        } else if (triggerHypo != null) {
            mainshockRup = new ETAS_EqkRupture();
            mainshockRup.setOriginTime(ot);
            mainshockRup.setAveRake(0.0);
            mainshockRup.setMag(triggerMag);
            mainshockRup.setPointSurface(triggerHypo);
            mainshockRup.setID(0);
            mainshockRup.setHypocenterLocation(triggerHypo);
            simulationName = "Pt Source. M=" + triggerMag + ", " + String.valueOf(triggerHypo);
            triggerRup = mainshockRup;
        } else {
            simulationName = "Spontaneous events";
        }
        CaliforniaRegions.RELM_TESTING_GRIDDED griddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
        System.out.println("Loading caches");
        if (generateCaches) {
            fractionSrcAtPointList = null;
            srcAtPointList = null;
            isCubeInsideFaultPolygon = null;
        } else {
            File fractionSrcAtPointListFile = new File(cacheDir, "sectDistForCubeCache");
            File srcAtPointListFile = new File(cacheDir, "sectInCubeCache");
            File isCubeInsideFaultPolygonFile = new File(cacheDir, "cubeInsidePolyCache");
            Preconditions.checkState((boolean)fractionSrcAtPointListFile.exists(), (Object)("cache file not found: " + fractionSrcAtPointListFile.getAbsolutePath()));
            Preconditions.checkState((boolean)srcAtPointListFile.exists(), (Object)("cache file not found: " + srcAtPointListFile.getAbsolutePath()));
            Preconditions.checkState((boolean)isCubeInsideFaultPolygonFile.exists(), (Object)("cache file not found: " + isCubeInsideFaultPolygonFile.getAbsolutePath()));
            fractionSrcAtPointList = MatrixIO.floatArraysListFromFile(fractionSrcAtPointListFile);
            srcAtPointList = MatrixIO.intArraysListFromFile(srcAtPointListFile);
            isCubeInsideFaultPolygon = MatrixIO.intArrayFromFile(isCubeInsideFaultPolygonFile);
        }
        LastEventData.populateSubSects(((FaultSystemSolution)sol).getRupSet().getFaultSectionDataList(), lastEventData);
        if (griddedOnly) {
            erf = new UCERF3_GriddedSeisOnlyERF_ETAS();
            erf.setParameter("Treat Background Seismicity As", (Object)BackgroundRupType.POINT);
            erf.setParameter("Apply Aftershock Filter", false);
            erf.setParameter("Maximum Magnitude", 8.3);
            erf.setParameter("Total Regional Rate", TotalMag5Rate.RATE_7p9);
            erf.setParameter("Spatial Seis PDF", SpatialSeisPDF.UCERF3);
            erf.getTimeSpan().setStartTimeInMillis(ot);
            erf.getTimeSpan().setDuration(duration);
            erf.updateForecast();
        } else {
            erf = ETAS_Launcher.buildERF_millis(sol, false, duration, ot);
            if (fssScenarioRupID >= 0) {
                ((FaultSystemSolutionERF_ETAS)erf).setFltSystemSourceOccurranceTimeForFSSIndex(fssScenarioRupID, ot);
            }
            erf.updateForecast();
        }
        System.out.println("Running simulation...");
        if (griddedOnly) {
            gridSeisDiscr = 0.1;
            ETAS_Simulator_NoFaults.runETAS_Simulation(outputDir, (AbstractNthRupERF)((UCERF3_GriddedSeisOnlyERF_ETAS)erf), (GriddedRegion)griddedRegion, triggerRup, (List<? extends ObsEqkRupture>)histQkList, includeSpontEvents, includeIndirectTriggering, gridSeisDiscr, (String)simulationName, (Long)randSeed, params, null);
        } else {
            ETAS_Simulator.runETAS_Simulation(outputDir, (AbstractNthRupERF)((FaultSystemSolutionERF_ETAS)erf), (GriddedRegion)griddedRegion, triggerRup, (List<? extends ObsEqkRupture>)histQkList, includeSpontEvents, includeIndirectTriggering, gridSeisDiscr, (String)simulationName, (Long)randSeed, fractionSrcAtPointList, srcAtPointList, isCubeInsideFaultPolygon, params, null, null);
        }
        System.out.println("DONE");
    }
}

