/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas.csepDailyRuns;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.opensha.commons.data.comcat.ComcatAccessor;
import org.opensha.commons.data.comcat.ComcatRegionAdapter;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.parsers.UCERF3_CatalogParser;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_AbstractComcatConfigBuilder;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_ComcatConfigBuilder;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_ComcatEventFetcher;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_ConfigBuilder;

public class DailyScriptWriter {
    public static void main(String[] args) throws IOException {
        GregorianCalendar startDate = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        startDate.clear();
        startDate.set(2007, 7, 1);
        GregorianCalendar endDate = new GregorianCalendar(startDate.getTimeZone());
        endDate.set(2018, 7, 1);
        int deltaDays = 1;
        int batchSize = 30;
        int batchNodes = 40;
        int batchHours = 24;
        int nodeThreads = 48;
        int batchThreads = 20;
        ETAS_ConfigBuilder.HPC_Sites site = ETAS_ConfigBuilder.HPC_Sites.TACC_STAMPEDE3;
        String queue = "skx";
        int indvNodes = 10;
        int indvHours = 5;
        int indvThreads = 15;
        double duration = 0.0027378507871321013;
        int numCatalogs = 100000;
        DecimalFormat batchDF = new DecimalFormat("000");
        String kCOV = "1.5";
        U3ETAS_ProbabilityModelOptions probModel = U3ETAS_ProbabilityModelOptions.FULL_TD;
        String parentDir = "${ETAS_SIM_DIR}/2024_07_23-csep1-daily-full_td-kCOV1.5";
        boolean griddedOnly = false;
        File resolvedParentDir = ETAS_Config.resolvePath(parentDir);
        System.out.println("Output Directory: " + resolvedParentDir.getAbsolutePath());
        Preconditions.checkState((resolvedParentDir.exists() || resolvedParentDir.mkdir() ? 1 : 0) != 0);
        GregorianCalendar curStart = new GregorianCalendar(startDate.getTimeZone());
        curStart.setTimeInMillis(startDate.getTimeInMillis());
        File u3CatalogFile = ETAS_Config.resolvePath("${ETAS_LAUNCHER}/inputs/u3_historical_catalog.txt");
        ObsEqkRupList u3Catalog = UCERF3_CatalogParser.loadCatalog(u3CatalogFile);
        long comcatStartMillis = ((ObsEqkRupture)u3Catalog.get(u3Catalog.size() - 1)).getOriginTime();
        SimpleDateFormat nameDF = new SimpleDateFormat("yyyy/MM/dd");
        nameDF.setTimeZone(startDate.getTimeZone());
        File comcatFile = null;
        if (endDate.getTimeInMillis() > comcatStartMillis) {
            comcatFile = new File(resolvedParentDir, "comcat-events.txt");
            if (!comcatFile.exists()) {
                System.out.println("Pre-fetching ComCat events");
                ComcatAccessor accessor = new ComcatAccessor();
                ComcatRegionAdapter cReg = new ComcatRegionAdapter(new CaliforniaRegions.RELM_TESTING());
                ObsEqkRupList comcatEvents = accessor.fetchEventList(null, comcatStartMillis, endDate.getTimeInMillis(), -10.0, 24.0, cReg, false, false, 2.5);
                ETAS_ComcatEventFetcher.writeCatalogFile(comcatFile, comcatEvents);
                ETAS_AbstractComcatConfigBuilder.CACHE_TRIGGER_RUPS = true;
            } else {
                System.out.println("Using already pre-fetched ComCat events");
                long maxTime = Long.MIN_VALUE;
                try {
                    for (ObsEqkRupture rup : ETAS_ComcatEventFetcher.loadCatalogFile(comcatFile)) {
                        maxTime = Long.max(maxTime, rup.getOriginTime());
                    }
                    endDate.setTimeInMillis(maxTime);
                }
                catch (ParseException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }
        File surfCacheDir = new File(resolvedParentDir, "surf-json-cache");
        int batchNum = 0;
        ArrayList<String> curBatch = new ArrayList<String>();
        String curBatchName = "batch_" + batchDF.format(batchNum);
        File batchDir = new File(resolvedParentDir, curBatchName);
        while (curStart.getTimeInMillis() < endDate.getTimeInMillis()) {
            ArrayList<Object> argz = new ArrayList<Object>();
            argz.add("--num-simulations");
            argz.add("" + numCatalogs);
            argz.add("--include-spontaneous");
            argz.add("--historical-catalog");
            argz.add("--binary-output");
            argz.add("--duration");
            argz.add("" + (float)duration);
            if (kCOV != null && !kCOV.isEmpty()) {
                argz.add("--etas-k-cov");
                argz.add(kCOV);
            }
            boolean comcat = curStart.getTimeInMillis() > comcatStartMillis;
            String name = "Start " + nameDF.format(curStart.getTime());
            if (kCOV != null && !kCOV.isEmpty()) {
                name = name + ", kCOV=" + kCOV;
            }
            if (comcat) {
                name = name + ", ComCat Stitch";
            }
            if (griddedOnly) {
                name = name + ", Gridded Only";
                argz.add("--gridded-only");
            } else if (probModel != U3ETAS_ProbabilityModelOptions.FULL_TD) {
                name = name + ", " + probModel.toString();
                argz.add("--prob-model");
                argz.add(probModel.name());
            }
            Preconditions.checkState((batchDir.exists() || batchDir.mkdir() ? 1 : 0) != 0);
            String outputDir = parentDir + "/" + curBatchName + "/" + ETAS_ConfigBuilder.getNamePrefix(name.replaceAll("/", "_"));
            if (comcat) {
                argz.add("--start-after-historical");
                argz.add("--end-time");
                argz.add("" + curStart.getTimeInMillis());
                argz.add("--finite-surf-cache");
                argz.add(surfCacheDir.getAbsolutePath());
                argz.add("--finite-surf-shakemap");
                argz.add("--finite-surf-shakemap-min-mag");
                argz.add("6");
                argz.add("--comcat-file");
                argz.add(comcatFile.getAbsolutePath());
                argz.add("--skip-input-plots");
            } else {
                argz.add("--start-time");
                argz.add("" + curStart.getTimeInMillis());
            }
            argz.add("--name");
            argz.add(name);
            argz.add("--max-point-src-mag");
            argz.add("6");
            argz.add("--hpc-site");
            argz.add(site.name());
            argz.add("--nodes");
            argz.add("" + indvNodes);
            argz.add("--hours");
            argz.add("" + indvHours);
            argz.add("--threads");
            argz.add("" + indvThreads);
            argz.add("--queue");
            argz.add(queue);
            argz.add("--output-dir");
            argz.add(outputDir);
            System.out.println(name);
            System.out.println("\tARGS: " + String.valueOf(argz));
            args = argz.toArray(new String[0]);
            if (comcat) {
                ETAS_ComcatConfigBuilder.main(args);
            } else {
                ETAS_ConfigBuilder.main(args);
            }
            curBatch.add(outputDir + "/config.json");
            if (curBatch.size() == batchSize) {
                File outputFile = new File(batchDir, curBatchName + ".slurm");
                DailyScriptWriter.writeBatch(site, curBatch, outputFile, batchNodes, batchHours, nodeThreads, batchThreads, queue);
                curBatch.clear();
                curBatchName = "batch_" + batchDF.format(++batchNum);
                batchDir = new File(resolvedParentDir, curBatchName);
            }
            curStart.add(5, deltaDays);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!curBatch.isEmpty()) {
            File outputFile = new File(batchDir, curBatchName + ".slurm");
            DailyScriptWriter.writeBatch(site, curBatch, outputFile, batchNodes, batchHours, nodeThreads, batchThreads, queue);
        }
    }

    private static void writeBatch(ETAS_ConfigBuilder.HPC_Sites site, List<String> configs, File outputFile, int nodes, int hours, int nodeThreads, int calcThreads, String queue) throws IOException {
        String configFile = Joiner.on((String)" ").join(configs);
        File inputFile = site.getSlurmFile();
        ETAS_ConfigBuilder.updateSlurmScript(inputFile, outputFile, (Integer)nodes, (Integer)nodeThreads, (Integer)calcThreads, (Integer)hours, queue, configFile);
    }
}

