/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas.weeklyRuns;

import com.google.common.primitives.Doubles;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskLogStatsGen;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.util.DataUtils;

public class WeeklyLogReader {
    public static void main(String[] args) throws IOException {
        String batchName;
        File batchDir;
        File baseDir = new File(args[0]);
        int curBatch = args.length > 1 ? Integer.parseInt(args[1]) : 0;
        int delta = args.length > 2 ? Integer.parseInt(args[2]) : 1;
        DecimalFormat df = new DecimalFormat("000");
        while ((batchDir = new File(baseDir, batchName = "batch_" + df.format(curBatch))).exists()) {
            System.out.println(batchDir.getName());
            ArrayList<Double> times = new ArrayList<Double>();
            for (File file : batchDir.listFiles()) {
                if (!file.getName().startsWith("batch_") || !file.getName().contains(".slurm.o")) continue;
                System.out.println("parsing " + file.getName());
                times.addAll(WeeklyLogReader.loadDurations(file));
            }
            if (times.isEmpty()) {
                System.out.println("\tno times parsed");
            } else {
                double[] timeArray = Doubles.toArray(times);
                double min = StatUtils.min((double[])timeArray);
                double max = StatUtils.max((double[])timeArray);
                double mean = StatUtils.mean((double[])timeArray);
                double median = DataUtils.median(timeArray);
                System.out.println("\tparsed " + times.size());
                System.out.println("\t\tmean: " + (float)mean);
                System.out.println("\t\tmedian: " + (float)median);
                System.out.println("\t\trange: [" + (float)min + " " + (float)max + "]");
            }
            curBatch += delta;
        }
    }

    private static List<Double> loadDurations(File logFile) throws IOException {
        Date prevDate = null;
        HashMap<Integer, Long> calcStartTimes = new HashMap<Integer, Long>();
        BufferedReader read = new BufferedReader(new FileReader(logFile));
        int numDuplicates = 0;
        int numNoStarts = 0;
        ArrayList<Double> ret = new ArrayList<Double>();
        HashMap<Integer, ArrayList<Double>> nodeTimes = new HashMap<Integer, ArrayList<Double>>();
        for (String line : new MPJTaskLogStatsGen.LogFileIterable(read)) {
            if (line.contains("batch") || line.contains("binary") || line.contains("output") || !line.contains("]: completed ") && !line.contains("]: calculating ")) continue;
            Date date = MPJTaskLogStatsGen.parseDate((String)line, prevDate);
            String indexStr = line.contains("completed") ? line.substring(line.indexOf("completed") + "completed".length()).trim() : line.substring(line.indexOf("calculating") + "calculating".length()).trim();
            int batchIndex = Integer.parseInt(indexStr.split(" ")[0]);
            int process = -1;
            if (line.contains("Process ")) {
                String pStr = line.substring(line.indexOf("Process ") + "Process ".length());
                pStr = pStr.substring(0, pStr.indexOf("]"));
                process = Integer.parseInt(pStr.trim());
            }
            if (line.contains("calculating")) {
                if (calcStartTimes.containsKey(batchIndex)) {
                    ++numDuplicates;
                }
                calcStartTimes.put(batchIndex, date.getTime());
            } else {
                Long startTime = (Long)calcStartTimes.get(batchIndex);
                if (startTime == null) {
                    ++numNoStarts;
                } else {
                    double time = (double)(date.getTime() - startTime) / 1000.0;
                    ret.add(time);
                    calcStartTimes.remove(batchIndex);
                    if (process > 0) {
                        ArrayList<Double> processTimes = (ArrayList<Double>)nodeTimes.get(process);
                        if (processTimes == null) {
                            processTimes = new ArrayList<Double>();
                            nodeTimes.put(process, processTimes);
                        }
                        processTimes.add(time);
                    }
                }
            }
            prevDate = date;
        }
        read.close();
        System.out.println("\tParsed " + ret.size() + " calculations (" + numDuplicates + " dups, " + calcStartTimes.size() + " orphans, " + numNoStarts + " outta-nowheres)");
        if (!nodeTimes.isEmpty()) {
            ArrayList ids = new ArrayList(nodeTimes.keySet());
            Collections.sort(ids);
            System.out.println("\tNode times:");
            DecimalFormat df = new DecimalFormat("0.0");
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int process = (Integer)iterator.next();
                List times = (List)nodeTimes.get(process);
                double mean = StatUtils.mean((double[])Doubles.toArray((Collection)times));
                System.out.println("\t\t" + process + ":\t" + df.format(mean) + "\t(" + times.size() + " sims)");
            }
        }
        return ret;
    }
}

