/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas.weeklyRuns;

import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.opensha.commons.util.FileNameComparator;
import org.opensha.commons.util.FileUtils;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class WeeklySpeedTests {
    public static void main(String[] args) throws IOException {
        String batchName;
        File batchDir;
        File baseDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2020_05_14-weekly-1986-present-full_td-kCOV1.5");
        int curBatch = 0;
        int delta = 5;
        DecimalFormat df = new DecimalFormat("000");
        ArrayList<CallSite> batchNames = new ArrayList<CallSite>();
        ArrayList<String> dirNames = new ArrayList<String>();
        ArrayList<Double> configSecs = new ArrayList<Double>();
        ArrayList<Double> launcherSecs = new ArrayList<Double>();
        ArrayList<Double> calcFirstSecs = new ArrayList<Double>();
        ArrayList<Double> calcSecondSecs = new ArrayList<Double>();
        while ((batchDir = new File(baseDir, batchName = "batch_" + df.format(curBatch))).exists()) {
            System.gc();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println(batchName);
            File[] subDirs = batchDir.listFiles();
            Arrays.sort(subDirs, new FileNameComparator());
            batchNames.add((CallSite)((Object)batchName));
            for (File dir : subDirs) {
                if (!dir.getName().startsWith("Start")) continue;
                System.out.println("\t" + dir.getName());
                dirNames.add(dir.getName());
                File configFile = new File(dir, "config.json");
                Stopwatch watch = Stopwatch.createStarted();
                ETAS_Config config = ETAS_Config.readJSON(configFile);
                watch.stop();
                File tempDir = Files.createTempDir();
                config.setOutputDir(tempDir);
                double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                System.out.println("\t\tload config: " + (float)secs + " s");
                configSecs.add(secs);
                watch = Stopwatch.createStarted();
                ETAS_Launcher launcher = new ETAS_Launcher(config, true);
                launcher.getCombinedTriggers();
                watch.stop();
                secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                System.out.println("\t\tbuild launcher: " + (float)secs + " s");
                launcherSecs.add(secs);
                launcher.setDebugLevel(ETAS_Launcher.DebugLevel.ERROR);
                watch = Stopwatch.createStarted();
                long[] seeds = new long[config.getNumSimulations()];
                for (int i = 0; i < seeds.length; ++i) {
                    seeds[i] = 123456789L;
                }
                launcher.setRandomSeeds(seeds);
                launcher.calculateBatch(1, new int[]{0});
                watch.stop();
                secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                System.out.println("\t\tcalc 0: " + (float)secs + " s");
                calcFirstSecs.add(secs);
                watch = Stopwatch.createStarted();
                launcher.calculateBatch(1, new int[]{1});
                watch.stop();
                secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                System.out.println("\t\tcalc 1: " + (float)secs + " s");
                calcSecondSecs.add(secs);
                FileUtils.deleteRecursive(tempDir);
                break;
            }
            curBatch += delta;
        }
        for (int i = 0; i < batchNames.size(); ++i) {
            System.out.println((String)batchNames.get(i) + ": " + (String)dirNames.get(i));
            System.out.println("\tconfig: " + ((Double)configSecs.get(i)).floatValue());
            System.out.println("\tlauncher: " + ((Double)launcherSecs.get(i)).floatValue());
            System.out.println("\tcalc 0: " + ((Double)calcFirstSecs.get(i)).floatValue());
            System.out.println("\tcalc 1: " + ((Double)calcSecondSecs.get(i)).floatValue());
        }
    }
}

