/*
 * Decompiled with CFR 0.152.
 */
package scratch.peter.curves;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class TornadoData {
    private static final Joiner J = Joiner.on((String)",");
    private static final String LF = IOUtils.LINE_SEPARATOR;
    private double median;
    private Map<Class<?>, TornadoEntry<? extends Enum<?>>> entryMap;

    public TornadoData(double median) {
        this.median = median;
        this.entryMap = Maps.newHashMap();
    }

    public String toString() {
        return TornadoData.buildString(this.median, this.entryMap.values());
    }

    public String toSortedString() {
        ArrayList entries = Lists.newArrayList(this.entryMap.values());
        Collections.sort(entries);
        return TornadoData.buildString(this.median, entries);
    }

    private static String buildString(double median, Collection<? extends TornadoEntry<? extends Enum<?>>> entries) {
        StringBuilder sb = new StringBuilder();
        sb.append(J.join((Object)"median", (Object)median, new Object[]{"median", median})).append(LF);
        for (TornadoEntry<Enum<?>> tornadoEntry : entries) {
            sb.append(tornadoEntry).append(LF);
        }
        return sb.toString();
    }

    public <T extends Enum<T>> void add(Class<?> c, Enum<T> e, double v) {
        TornadoEntry<? extends Enum<?>> entry = this.entryMap.get(c);
        if (entry == null) {
            TornadoEntry te = new TornadoEntry();
            te.eMin = e;
            te.eMax = e;
            te.vMin = v;
            te.vMax = v;
            this.entryMap.put(c, te);
            return;
        }
        TornadoEntry<? extends Enum<?>> te = entry;
        if (v < entry.vMin) {
            te.vMin = v;
            te.eMin = e;
        } else if (v > entry.vMax) {
            te.vMax = v;
            te.eMax = e;
        } else {
            te.eMax = e;
        }
    }

    public static void main(String[] args) {
    }

    private static class TornadoEntry<E extends Enum<E>>
    implements Comparable<TornadoEntry<E>> {
        Enum<E> eMin;
        double vMin;
        Enum<E> eMax;
        double vMax;

        private TornadoEntry() {
        }

        public String toString() {
            return J.join((Object)this.eMin.name(), (Object)this.vMin, new Object[]{this.eMax.name(), this.vMax});
        }

        @Override
        public int compareTo(TornadoEntry<E> te) {
            double r1 = te.vMax - te.vMin;
            double r2 = this.vMax - this.vMin;
            return r1 < r2 ? -1 : (r1 > r2 ? 1 : 0);
        }
    }
}

