/*
 * Decompiled with CFR 0.152.
 */
package scratch.peter.nshmp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.griddedSeismicity.AbstractGridSourceProvider;

public class NSHMP_UCERF3_ERF
extends FaultSystemSolutionERF {
    private static final Region CA_REGION;
    private GridSourceProvider gridSources;
    private List<Integer> indices;

    public NSHMP_UCERF3_ERF(FaultSystemSolution fss) {
        super(fss);
        double[] rates = fss.getRateForAllRups();
        FaultSystemRupSet fsrs = fss.getRupSet();
        ArrayList rupIDs = Lists.newArrayList();
        rupIDs.addAll(fsrs.getRupturesForParentSection(721));
        rupIDs.addAll(fsrs.getRupturesForParentSection(719));
        Iterator iterator = rupIDs.iterator();
        while (iterator.hasNext()) {
            int rupID = (Integer)iterator.next();
            rates[rupID] = 0.0;
        }
    }

    @Override
    protected boolean initOtherSources() {
        this.gridSources = this.getSolution().getGridSourceProvider();
        GriddedRegion gr = this.gridSources.getGriddedRegion();
        this.indices = Lists.newArrayList();
        for (Location loc : gr) {
            if (!CA_REGION.contains(loc)) continue;
            this.indices.add(gr.indexForLocation(loc));
        }
        this.numOtherSources = this.indices.size();
        return true;
    }

    @Override
    protected ProbEqkSource getOtherSource(int iSource) {
        return this.gridSources.getSource(this.indices.get(iSource), this.timeSpan.getDuration(), this.applyAftershockFilter ? AbstractGridSourceProvider.GK_AFTERSHOCK_FILTER : null, this.bgSettings);
    }

    public static void main(String[] args) {
        boolean contains = CA_REGION.contains(new Location(42.0, -121.0));
        System.out.println(contains);
    }

    static {
        LocationList locs = new LocationList();
        locs.add(new Location(39.0, -119.999));
        locs.add(new Location(35.0, -114.635));
        locs.add(new Location(34.848, -114.616));
        locs.add(new Location(34.719, -114.482));
        locs.add(new Location(34.464, -114.371));
        locs.add(new Location(34.285, -114.122));
        locs.add(new Location(34.097, -114.413));
        locs.add(new Location(33.934, -114.519));
        locs.add(new Location(33.616, -114.511));
        locs.add(new Location(33.426, -114.636));
        locs.add(new Location(33.401, -114.71));
        locs.add(new Location(33.055, -114.676));
        locs.add(new Location(33.02, -114.501));
        locs.add(new Location(32.861, -114.455));
        locs.add(new Location(32.741, -114.575));
        locs.add(new Location(32.718, -114.719));
        locs.add(new Location(32.151, -120.861));
        locs.add(new Location(39.0, -126.0));
        locs.add(new Location(42.001, -126.0));
        locs.add(new Location(42.001, -119.999));
        locs.add(new Location(39.0, -119.999));
        CA_REGION = new Region(locs, null);
    }
}

