/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;

public class WeightedSampler<T> {
    private List<T> objects;
    private Random r;
    private IntegerPDF_FunctionSampler sampler;

    public WeightedSampler(List<T> objects, List<Double> rates) throws NullPointerException, IllegalArgumentException {
        this(objects, rates, new Random());
    }

    public WeightedSampler(List<T> objects, List<Double> rates, Random r) throws NullPointerException, IllegalArgumentException {
        Preconditions.checkNotNull(objects, (Object)"objects cannot be null!");
        Preconditions.checkArgument((!objects.isEmpty() ? 1 : 0) != 0, (Object)"objects cannot be empty!");
        Preconditions.checkNotNull(rates, (Object)"rates cannot be null!");
        Preconditions.checkArgument((!rates.isEmpty() ? 1 : 0) != 0, (Object)"rates cannot be empty!");
        Preconditions.checkArgument((objects.size() == rates.size() ? 1 : 0) != 0, (Object)"items and rates must be of the same size");
        boolean hasNonZero = false;
        for (double rate : rates) {
            Preconditions.checkArgument((rate >= 0.0 ? 1 : 0) != 0, (Object)"rates must be >= 0");
            if (!(rate > 0.0)) continue;
            hasNonZero = true;
        }
        Preconditions.checkArgument((boolean)hasNonZero, (Object)"must be at least one non zero rate");
        Preconditions.checkNotNull((Object)r, (Object)"random cannot be null!");
        this.r = r;
        this.objects = Collections.unmodifiableList(objects);
        this.sampler = new IntegerPDF_FunctionSampler(objects.size());
        for (int i = 0; i < objects.size(); ++i) {
            this.sampler.set(i, (double)rates.get(i));
        }
    }

    public T getItemForNormCumRate(double rate) {
        Preconditions.checkState((rate >= 0.0 && rate <= 1.0 ? 1 : 0) != 0, (Object)"rate must be within zero and one");
        int ind = this.sampler.getInt(rate);
        return this.objects.get(ind);
    }

    public T nextItem() {
        return this.getItemForNormCumRate(this.r.nextDouble());
    }

    public List<T> generateSeries(int size) throws IllegalArgumentException {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"size must be > 0!");
        ArrayList<T> series = new ArrayList<T>();
        while (series.size() < size) {
            series.add(this.nextItem());
        }
        return series;
    }
}

