/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc.magScalingRelations.magScalingRelImpl;

import org.opensha.commons.calc.magScalingRelations.MagAreaRelDepthDep;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;

public class Shaw_2009_ModifiedMagAreaRel
extends MagAreaRelationship
implements MagAreaRelDepthDep {
    static final String C = "Shaw_2009_ModifiedMagAreaRel";
    public static final String NAME = "Shaw (2009) Modified";
    ArbitrarilyDiscretizedFunc magAreaFunc = null;
    public static final double beta = 7.4;
    public static final double h = 15.0;
    public static final double cZero = 3.98;

    @Override
    public double getWidthDepMedianMag(double area, double origWidth) {
        double numer = Math.max(1.0, Math.sqrt(area / (origWidth * origWidth)));
        double denom = (1.0 + Math.max(1.0, area / (7.4 * origWidth * origWidth))) / 2.0;
        return 3.98 + Math.log10(area) + 0.6667 * Math.log10(numer / denom);
    }

    @Override
    public double getMedianMag(double area) {
        double numer = Math.max(1.0, Math.sqrt(area / 225.0));
        double denom = (1.0 + Math.max(1.0, area / 1665.0)) / 2.0;
        return 3.98 + Math.log10(area) + 0.6667 * Math.log10(numer / denom);
    }

    @Override
    public double getMagStdDev() {
        return Double.NaN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMedianArea(double mag) {
        if (this.magAreaFunc == null) {
            Shaw_2009_ModifiedMagAreaRel shaw_2009_ModifiedMagAreaRel = this;
            synchronized (shaw_2009_ModifiedMagAreaRel) {
                if (this.magAreaFunc == null) {
                    ArbitrarilyDiscretizedFunc magAreaFunc = new ArbitrarilyDiscretizedFunc();
                    for (int i = 0; i <= 1000; ++i) {
                        double logArea = (double)i * 5.5 / 1000.0;
                        double area = Math.pow(10.0, logArea);
                        double tempMag = this.getMedianMag(area);
                        magAreaFunc.set(area, tempMag);
                    }
                    this.magAreaFunc = magAreaFunc;
                }
            }
        }
        return this.magAreaFunc.getFirstInterpolatedX(mag);
    }

    @Override
    public double getAreaStdDev() {
        return Double.NaN;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static void main(String[] args) {
        Shaw_2009_ModifiedMagAreaRel test = new Shaw_2009_ModifiedMagAreaRel();
        if (test.getName().equals(NAME)) {
            System.out.println("test OK");
        }
        test.getMedianArea(7.0);
    }
}

