/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc.magScalingRelations.magScalingRelImpl;

public enum Stirling_2021_SimplifiedNZ_FaultRegime {
    STRIKE_SLIP,
    REVERSE_FAULTING,
    NORMAL_FAULTING,
    SUBDUCTION_INTERFACE,
    CRUSTAL,
    LOWER,
    UPPER,
    NONE;


    public static Stirling_2021_SimplifiedNZ_FaultRegime fromRake(double rake) {
        if (Double.isNaN(rake)) {
            return NONE;
        }
        if (rake <= 45.0 && rake >= -45.0 || rake >= 135.0 || rake <= -135.0) {
            return STRIKE_SLIP;
        }
        if (rake > 0.0) {
            return REVERSE_FAULTING;
        }
        return NORMAL_FAULTING;
    }

    public static Stirling_2021_SimplifiedNZ_FaultRegime fromRegime(String regime) {
        if (regime.compareToIgnoreCase("interface") == 0) {
            return SUBDUCTION_INTERFACE;
        }
        return CRUSTAL;
    }

    public static Stirling_2021_SimplifiedNZ_FaultRegime fromEpistemicBound(String epistemicBound) {
        if (epistemicBound.compareToIgnoreCase("lower") == 0) {
            return LOWER;
        }
        if (epistemicBound.compareToIgnoreCase("upper") == 0) {
            return UPPER;
        }
        return NONE;
    }
}

