/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc.magScalingRelations.magScalingRelImpl;

import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.TMG2017FaultingType;

public class TMG2017CruMagAreaRel
extends MagAreaRelationship {
    static final String C = "TMG2017CruMagAreaRel";
    public static final String NAME = "Thingbaijam et al.(2017)";
    protected TMG2017FaultingType faultingType = TMG2017FaultingType.NONE;

    public TMG2017CruMagAreaRel() {
    }

    public TMG2017CruMagAreaRel(double initalRake) {
        this.setRake(initalRake);
    }

    @Override
    public double getMedianMag(double area) {
        if (TMG2017FaultingType.NONE == this.faultingType) {
            return Double.NaN;
        }
        if (TMG2017FaultingType.STRIKE_SLIP == this.faultingType) {
            return 3.701 + 1.062 * Math.log(area) * 0.434294;
        }
        if (TMG2017FaultingType.REVERSE_FAULTING == this.faultingType) {
            return 4.158 + 0.953 * Math.log(area) * 0.434294;
        }
        return 3.157 + 1.238 * Math.log(area) * 0.434294;
    }

    @Override
    public double getMagStdDev() {
        if (TMG2017FaultingType.NONE == this.faultingType) {
            return Double.NaN;
        }
        if (TMG2017FaultingType.STRIKE_SLIP == this.faultingType) {
            return 0.184;
        }
        if (TMG2017FaultingType.REVERSE_FAULTING == this.faultingType) {
            return 0.121;
        }
        return 0.181;
    }

    @Override
    public double getMedianArea(double mag) {
        if (TMG2017FaultingType.NONE == this.faultingType) {
            return Double.NaN;
        }
        if (TMG2017FaultingType.STRIKE_SLIP == this.faultingType) {
            return Math.pow(10.0, -3.486 + 0.942 * mag);
        }
        if (TMG2017FaultingType.REVERSE_FAULTING == this.faultingType) {
            return Math.pow(10.0, -4.362 + 1.049 * mag);
        }
        return Math.pow(10.0, -2.551 + 0.808 * mag);
    }

    @Override
    public double getAreaStdDev() {
        return this.getMagStdDev();
    }

    @Override
    public void setRake(double rake) {
        super.setRake(rake);
        this.faultingType = TMG2017FaultingType.fromRake(rake);
    }

    @Override
    public String getName() {
        String type = TMG2017FaultingType.NONE == this.faultingType ? "InvalidRake" : (TMG2017FaultingType.STRIKE_SLIP == this.faultingType ? "Strike-Slip" : (TMG2017FaultingType.REVERSE_FAULTING == this.faultingType ? "Reverse-Faulting" : "Normal-Faulting"));
        return "Thingbaijam et al.(2017) for crustal " + type + " events";
    }
}

