/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.opensha.commons.data.CSVFile;

public class CSVWriter
implements Flushable,
AutoCloseable {
    protected boolean strictRowSizes;
    protected int cols = 0;
    protected Writer writer;

    public CSVWriter(OutputStream out, boolean strictRowSizes) throws IOException {
        this.strictRowSizes = strictRowSizes;
        this.writer = new OutputStreamWriter(new BufferedOutputStream(out));
    }

    protected void validateLine(List<String> line) {
        if (!this.strictRowSizes) {
            return;
        }
        if (this.cols == 0) {
            this.cols = line.size();
        }
        Preconditions.checkArgument((line.size() == this.cols ? 1 : 0) != 0, (Object)("New line must contain same number of values as columns (expected " + this.cols + ", got " + line.size() + ")"));
    }

    public void write(List<String> line) throws IOException {
        this.validateLine(line);
        CSVFile.writeLine(this.writer, line);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.writer.close();
        }
    }
}

