/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.awt.geom.Point2D;
import java.io.Serializable;
import org.opensha.commons.data.Point2DComparator;
import org.opensha.commons.exceptions.InvalidRangeException;

public class Point2DToleranceComparator
implements Point2DComparator,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double tolerance = 0.0;

    public Point2DToleranceComparator() throws InvalidRangeException {
    }

    public Point2DToleranceComparator(double tolerance) throws InvalidRangeException {
        this.setTolerance(tolerance);
    }

    @Override
    public void setTolerance(double newTolerance) throws InvalidRangeException {
        if (this.tolerance < 0.0) {
            throw new InvalidRangeException("Tolerance must be larger or equal to 0");
        }
        if (this.tolerance > 0.0) {
            throw new IllegalStateException("Tolerance is now fixed at 0.0 until we decide what to do with it. See trac ticket #341");
        }
        this.tolerance = newTolerance;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public int compare(Point2D o1, Point2D o2) throws ClassCastException {
        double x2;
        double x1 = o1.getX();
        if (Math.abs(x1 - (x2 = o2.getX())) <= this.tolerance) {
            return 0;
        }
        if (x1 > x2) {
            return 1;
        }
        return -1;
    }
}

