/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opensha.commons.data.Point2DComparator;
import org.opensha.commons.data.Point2DToleranceSortedList;

public class Point2DToleranceSortedArrayList
implements Point2DToleranceSortedList {
    private Point2DComparator comparator;
    private List<Point2D> list;

    public Point2DToleranceSortedArrayList(Point2DComparator comparator) {
        this.comparator = comparator;
        this.list = new ArrayList<Point2D>();
    }

    @Override
    public Iterator<Point2D> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public double getTolerance() {
        return this.comparator.getTolerance();
    }

    @Override
    public void setTolerance(double newTolerance) {
        this.comparator.setTolerance(newTolerance);
    }

    @Override
    public int binarySearch(Point2D p) {
        return Collections.binarySearch(this.list, p, this.comparator);
    }

    @Override
    public boolean add(Point2D e) {
        int ind = this.binarySearch(e);
        if (ind >= 0) {
            this.list.set(ind, e);
        } else {
            this.list.add(-ind - 1, e);
        }
        return true;
    }

    protected void add(int index, Point2D pt) {
        this.list.add(index, pt);
    }

    protected void set(int index, Point2D pt) {
        this.list.set(index, pt);
    }

    @Override
    public boolean addAll(Collection<? extends Point2D> c) {
        for (Point2D point2D : c) {
            this.add(point2D);
        }
        return !c.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Point2D) {
            int ind = this.binarySearch((Point2D)o);
            if (ind >= 0) {
                this.list.remove(ind);
                return true;
            }
            return false;
        }
        throw new ClassCastException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public double getMinY() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("list is empty!");
        }
        double minY = Double.POSITIVE_INFINITY;
        for (Point2D p : this) {
            if (!(p.getY() < minY)) continue;
            minY = p.getY();
        }
        return minY;
    }

    @Override
    public double getMaxY() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("list is empty!");
        }
        double maxY = Double.NEGATIVE_INFINITY;
        for (Point2D p : this) {
            if (!(p.getY() > maxY)) continue;
            maxY = p.getY();
        }
        return maxY;
    }

    @Override
    public double getMinX() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("list is empty!");
        }
        return this.get(0).getX();
    }

    @Override
    public double getMaxX() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("list is empty!");
        }
        return this.get(this.size() - 1).getX();
    }

    @Override
    public Point2D get(int index) {
        if (index >= 0 && index < this.size()) {
            return this.list.get(index);
        }
        return null;
    }

    @Override
    public boolean remove(int index) {
        this.list.remove(index);
        return true;
    }

    @Override
    public Point2D get(double x) {
        int ind = this.indexOf(new Point2D.Double(x, 0.0));
        return this.get(ind);
    }

    @Override
    public int indexOf(Point2D findPoint) {
        int ind = this.binarySearch(findPoint);
        if (ind < -1) {
            ind = -1;
        }
        return ind;
    }

    @Override
    public Point2DComparator getComparator() {
        return this.comparator;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

