/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.data.Named;
import org.opensha.commons.geo.Location;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;

public class Site
extends ParameterList
implements Named,
Serializable,
XMLSaveable {
    protected static final String C = "Site";
    public static String XML_METADATA_NAME = "Site";
    public static String XML_PARAMS_NAME = "SiteParams";
    public static String XML_METADATA_LIST_NAME = "Sites";
    protected static final boolean D = false;
    public String name;
    protected Location location;

    public Site() {
    }

    public Site(Location location) {
        this.location = location;
    }

    public Site(Location location, String name) {
        this.location = location;
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(C);
        b.append(" : ");
        b.append("Name = ");
        b.append(this.name);
        b.append(" : ");
        b.append("Location = ");
        b.append(this.location.toString());
        b.append(" : ");
        b.append("Parameters = ");
        b.append(super.toString());
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Site)) {
            return false;
        }
        Site s = (Site)obj;
        if (this.name == null && s.name != null) {
            return false;
        }
        if (this.name != null && !this.name.equalsIgnoreCase(s.name)) {
            return false;
        }
        if (this.location == null && s.location != null) {
            return false;
        }
        if (this.location != null && !this.location.equals(s.location)) {
            return false;
        }
        if (this.size() != s.size()) {
            return false;
        }
        for (Parameter<?> p1 : this) {
            if (!s.containsParameter(p1.getName())) {
                return false;
            }
            Parameter p2 = s.getParameter(p1.getName());
            if (p1.equals(p2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object clone() {
        String S = "Site: clone(): ";
        Site site = new Site();
        site.setName(this.getName());
        site.setLocation(this.location.clone());
        if (this.size() < 1) {
            return site;
        }
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            Parameter param = (Parameter)this.params.get(i);
            site.addParameter((Parameter)param.clone());
        }
        return site;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element siteEl = root.addElement(XML_METADATA_NAME);
        siteEl = this.getLocation().toXMLMetadata(siteEl);
        Element paramsEl = siteEl.addElement(XML_PARAMS_NAME);
        ListIterator<Parameter<?>> paramIt = this.getParametersIterator();
        if (this.name != null && !this.name.isEmpty()) {
            siteEl.addAttribute("name", this.name);
        }
        while (paramIt.hasNext()) {
            Parameter<?> param = paramIt.next();
            paramsEl = param.toXMLMetadata(paramsEl);
        }
        return root;
    }

    public static Site fromXMLMetadata(Element siteEl, Iterable<Parameter<?>> paramsToAdd) {
        Element locEl = siteEl.element("Location");
        Location loc = Location.fromXMLMetadata(locEl);
        Site site = new Site(loc);
        Attribute nameAtt = siteEl.attribute("name");
        if (nameAtt != null) {
            site.setName(nameAtt.getStringValue());
        }
        for (Parameter<?> param : paramsToAdd) {
            site.addParameter((Parameter)param.clone());
        }
        Element paramsEl = siteEl.element(XML_PARAMS_NAME);
        ParameterList.setParamsInListFromXML(site, paramsEl);
        return site;
    }

    public static Element writeSitesToXML(List<Site> sites, Element root) {
        Element sitesEl = root.addElement(XML_METADATA_LIST_NAME);
        for (Site site : sites) {
            sitesEl = site.toXMLMetadata(sitesEl);
        }
        return root;
    }

    public static ArrayList<Site> loadSitesFromXML(Element sitesEl, ArrayList<Parameter<?>> paramsToAdd) {
        Iterator it = sitesEl.elementIterator(XML_METADATA_NAME);
        System.out.println("Params to add:");
        for (Parameter<?> param : paramsToAdd) {
            System.out.println(param.getName());
        }
        ArrayList<Site> sites = new ArrayList<Site>();
        while (it.hasNext()) {
            Element siteEl = (Element)it.next();
            sites.add(Site.fromXMLMetadata(siteEl, paramsToAdd));
        }
        return sites;
    }
}

