/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.estimate;

import org.opensha.commons.data.estimate.DiscretizedFuncEstimate;
import org.opensha.commons.data.estimate.InvalidParamValException;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;

public class PDF_Estimate
extends DiscretizedFuncEstimate {
    public static final String NAME = "PDF";
    public static final String MSG_EVENLY_DISCRETIZED_ALLOWED = "Only evenly discretized function is allowed for PDF estimate";

    public PDF_Estimate(EvenlyDiscretizedFunc func, boolean isNormalized) {
        super(func, isNormalized);
    }

    @Override
    public void setValues(AbstractDiscretizedFunc newFunc, boolean isNormalized) {
        if (!(newFunc instanceof EvenlyDiscretizedFunc)) {
            throw new InvalidParamValException(MSG_EVENLY_DISCRETIZED_ALLOWED);
        }
        super.setValues(newFunc, isNormalized);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AbstractDiscretizedFunc getCDF_Test() {
        AbstractDiscretizedFunc cdfFunc = (AbstractDiscretizedFunc)this.cumDistFunc.deepClone();
        cdfFunc.setInfo("CDF from PDF Distribution");
        return cdfFunc;
    }

    @Override
    public double getProbLessThanEqual(double x) {
        if (x < this.cumDistFunc.getX(0)) {
            return 0.0;
        }
        if (x > this.cumDistFunc.getX(this.cumDistFunc.size() - 1)) {
            return 1.0;
        }
        return this.cumDistFunc.getInterpolatedY(x);
    }

    @Override
    public AbstractDiscretizedFunc getPDF_Test() {
        EvenlyDiscretizedFunc pdfFunc = (EvenlyDiscretizedFunc)((Object)this.func.deepClone());
        double deltaX = pdfFunc.getDelta();
        int numPoints = pdfFunc.size();
        for (int i = 0; i < numPoints; ++i) {
            double x = pdfFunc.getX(i);
            pdfFunc.set(i, this.getProbLessThanEqual(x + deltaX / 2.0) - this.getProbLessThanEqual(x - deltaX / 2.0));
        }
        pdfFunc.setInfo("PDF from PDF Distribution");
        return pdfFunc;
    }
}

