/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.Interpolate;

public abstract class AbstractDiscretizedFunc
extends AbstractXY_DataSet
implements DiscretizedFunc,
Named,
Serializable {
    private static final long serialVersionUID = 2798699443929196424L;
    protected static final String C = "DiscretizedFunc";
    protected static final boolean D = false;
    public static final String XML_METADATA_NAME = "discretizedFunction";
    public static final String XML_METADATA_POINTS_NAME = "Points";
    public static final String XML_METADATA_POINT_NAME = "Point";
    protected double tolerance = 0.0;
    private static String TAB = "\t";

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public void setTolerance(double newTolerance) throws InvalidRangeException {
        if (newTolerance < 0.0) {
            throw new InvalidRangeException("Tolerance must be larger or equal to 0");
        }
        this.tolerance = newTolerance;
    }

    @Override
    public boolean hasX(double x) {
        return this.getXIndex(x) >= 0;
    }

    abstract int getXIndexBefore(double var1);

    @Override
    public double getInterpolatedY(double x) {
        return this.getInterpolatedY(x, false, false);
    }

    @Override
    public double getInterpolatedY_inLogXLogYDomain(double x) {
        return this.getInterpolatedY(x, true, true);
    }

    @Override
    public double getInterpolatedY_inLogXDomain(double x) {
        return this.getInterpolatedY(x, true, false);
    }

    @Override
    public double getInterpolatedY_inLogYDomain(double x) {
        return this.getInterpolatedY(x, false, true);
    }

    private double getInterpolatedY(double x, boolean logX, boolean logY) {
        double minX = this.getMinX();
        double maxX = this.getMaxX();
        if (x > maxX + this.tolerance || x < minX - this.tolerance) {
            throw new InvalidRangeException("x Value (" + x + ") must be within the range: " + this.getX(0) + " and " + this.getX(this.size() - 1));
        }
        if (x >= maxX) {
            return this.getY(this.size() - 1);
        }
        if (x <= minX) {
            return this.getY(0);
        }
        int x1Ind = this.getXIndexBefore(x);
        if (x1Ind == -1) {
            return this.getY(0);
        }
        double x1 = this.getX(x1Ind);
        double x2 = this.getX(x1Ind + 1);
        double y1 = this.getY(x1Ind);
        double y2 = this.getY(x1Ind + 1);
        if (y1 == 0.0 && y2 == 0.0) {
            return 0.0;
        }
        if (logX) {
            x1 = Math.log(x1);
            x2 = Math.log(x2);
            x = Math.log(x);
        }
        if (logY) {
            y1 = Math.log(y1);
            y2 = Math.log(y2);
        }
        double y = Interpolate.findY(x1, y1, x2, y2, x);
        if (logY) {
            y = Math.exp(y);
        }
        return y;
    }

    @Override
    public double getFirstInterpolatedX(double y) {
        return this.getFirstInterpolatedX(y, false, false);
    }

    @Override
    public double getFirstInterpolatedX_inLogXLogYDomain(double y) {
        return this.getFirstInterpolatedX(y, true, true);
    }

    public double getFirstInterpolatedX_inLogYDomain(double y) {
        return this.getFirstInterpolatedX(y, false, true);
    }

    private double getFirstInterpolatedX(double y, boolean logX, boolean logY) {
        int i;
        double y1 = Double.NaN;
        double y2 = Double.NaN;
        int num = this.size();
        if (num == 1 && y == this.getY(0)) {
            return this.getX(0);
        }
        boolean found = false;
        for (i = 0; i < num - 1; ++i) {
            y1 = this.getY(i);
            y2 = this.getY(i + 1);
            if (!(y <= y1 && y >= y2 && y2 <= y1) && (!(y >= y1) || !(y <= y2) || !(y2 >= y1))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidRangeException("Y Value (" + y + ") must be within the range: " + this.getY(0) + " and " + this.getY(num - 1));
        }
        double x1 = this.getX(i);
        double x2 = this.getX(i + 1);
        if (x1 == 0.0 && x2 == 0.0) {
            return 0.0;
        }
        if (logX) {
            x1 = Math.log(x1);
            x2 = Math.log(x2);
        }
        if (logY) {
            y1 = Math.log(y1);
            y2 = Math.log(y2);
            y = Math.log(y);
        }
        double x = Interpolate.findX(x1, y1, x2, y2, y);
        if (logX) {
            x = Math.exp(x);
        }
        return x;
    }

    private boolean areBothNull(String first, String second) {
        return first == null && second == null;
    }

    private boolean isOneNull(String first, String second) {
        return first == null || second == null;
    }

    private boolean isSameWithNull(String first, String second) {
        if (this.areBothNull(first, second)) {
            return true;
        }
        if (this.isOneNull(first, second)) {
            return false;
        }
        return first.equals(second);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DiscretizedFunc)) {
            return false;
        }
        DiscretizedFunc function = (DiscretizedFunc)obj;
        if (!this.isSameWithNull(this.getName(), function.getName())) {
            return false;
        }
        if (this.getName() == null && function.getName() != null || this.getName() != null && !this.getName().equals(function.getName())) {
            return false;
        }
        if (!this.isSameWithNull(this.getInfo(), function.getInfo())) {
            return false;
        }
        if (this.size() != function.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Point2D pt2;
            Point2D pt1 = this.get(i);
            if (pt1.equals(pt2 = function.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        return this.toXMLMetadata(root, XML_METADATA_NAME);
    }

    @Override
    public Element toXMLMetadata(Element root, String elementName) {
        return this.toXMLMetadata(root, elementName, null);
    }

    @Override
    public Element toXMLMetadata(Element root, String elementName, NumberFormat format) {
        Element xml = root.addElement(elementName);
        xml.addAttribute("info", this.getInfo());
        xml.addAttribute("name", this.getName());
        xml.addAttribute("tolerance", "" + this.getTolerance());
        xml.addAttribute("xAxisName", this.getXAxisName());
        xml.addAttribute("yAxisName", this.getYAxisName());
        xml.addAttribute("num", "" + this.size());
        xml.addAttribute("minX", "" + this.getMinX());
        xml.addAttribute("maxX", "" + this.getMaxX());
        if (this instanceof EvenlyDiscretizedFunc) {
            xml.addAttribute("delta", AbstractDiscretizedFunc.valToStr(((EvenlyDiscretizedFunc)this).getDelta(), format));
        }
        Element points = xml.addElement(XML_METADATA_POINTS_NAME);
        for (int i = 0; i < this.size(); ++i) {
            Element point = points.addElement(XML_METADATA_POINT_NAME);
            point.addAttribute("x", AbstractDiscretizedFunc.valToStr(this.getX(i), format));
            point.addAttribute("y", AbstractDiscretizedFunc.valToStr(this.getY(i), format));
        }
        return root;
    }

    private static String valToStr(double val, NumberFormat format) {
        if (format == null) {
            return "" + val;
        }
        return format.format(val);
    }

    public static AbstractDiscretizedFunc fromXMLMetadata(Element funcElem) {
        AbstractDiscretizedFunc func;
        String info = funcElem.attributeValue("info");
        String name = funcElem.attributeValue("name");
        String xAxisName = funcElem.attributeValue("xAxisName");
        String yAxisName = funcElem.attributeValue("yAxisName");
        Attribute deltaAtt = funcElem.attribute("delta");
        if (deltaAtt == null) {
            func = new ArbitrarilyDiscretizedFunc();
        } else {
            int num = Integer.parseInt(funcElem.attributeValue("num"));
            double minX = Double.parseDouble(funcElem.attributeValue("minX"));
            double delta = Double.parseDouble(deltaAtt.getStringValue());
            func = new EvenlyDiscretizedFunc(minX, num, delta);
        }
        double tolerance = Double.parseDouble(funcElem.attributeValue("tolerance"));
        func.setInfo(info);
        func.setName(name);
        func.setXAxisName(xAxisName);
        func.setYAxisName(yAxisName);
        func.setTolerance(tolerance);
        Element points = funcElem.element(XML_METADATA_POINTS_NAME);
        Iterator it = points.elementIterator();
        while (it.hasNext()) {
            Element point = (Element)it.next();
            double x = Double.parseDouble(point.attributeValue("x"));
            double y = Double.parseDouble(point.attributeValue("y"));
            func.set(x, y);
        }
        return func;
    }

    public static void writeSimpleFuncFile(DiscretizedFunc func, String fileName) throws IOException {
        AbstractDiscretizedFunc.writeSimpleFuncFile(func, new File(fileName));
    }

    public static void writeSimpleFuncFile(DiscretizedFunc func, File outFile) throws IOException {
        FileWriter fr = new FileWriter(outFile);
        for (int i = 0; i < func.size(); ++i) {
            fr.write(func.getX(i) + " " + func.getY(i) + "\n");
        }
        fr.close();
    }

    public static ArbitrarilyDiscretizedFunc loadFuncFromSimpleFile(String fileName) throws FileNotFoundException, IOException {
        ArrayList<String> fileLines = FileUtils.loadFile(fileName);
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < fileLines.size(); ++i) {
            String dataLine = fileLines.get(i);
            StringTokenizer st = new StringTokenizer(dataLine);
            double x = Double.parseDouble(st.nextToken());
            double y = Double.parseDouble(st.nextToken());
            func.set(x, y);
        }
        return func;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArbitrarilyDiscretizedFunc loadFuncFromSimpleFile(InputStream is) throws FileNotFoundException, IOException {
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        try (Scanner scanner = new Scanner(is);){
            while (scanner.hasNextLine()) {
                StringTokenizer st = new StringTokenizer(scanner.nextLine());
                double x = Double.parseDouble(st.nextToken());
                double y = Double.parseDouble(st.nextToken());
                func.set(x, y);
            }
        }
        return func;
    }

    @Override
    public double calcSumOfY_Vals() {
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            sum += this.getY(i);
        }
        return sum;
    }

    @Override
    public void scale(double val) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, val * this.getY(i));
        }
    }

    @Override
    public String toString() {
        return DiscretizedFunc.toString(this);
    }

    @Override
    public String getMetadataString() {
        StringBuffer b = new StringBuffer();
        for (Point2D point : this) {
            double x = point.getX();
            double y = point.getY();
            b.append((float)x + TAB + (float)y + "\n");
        }
        return b.toString();
    }
}

