/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import com.google.gson.annotations.JsonAdapter;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.opensha.commons.data.Point2DComparator;
import org.opensha.commons.data.Point2DToleranceComparator;
import org.opensha.commons.data.Point2DToleranceSortedArrayList;
import org.opensha.commons.data.Point2DToleranceSortedList;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.InvalidRangeException;

@JsonAdapter(value=DiscretizedFunc.Adapter.class)
public class ArbitrarilyDiscretizedFunc
extends AbstractDiscretizedFunc
implements Serializable {
    private static final long serialVersionUID = 253638618L;
    protected static final String C = "ArbitrarilyDiscretizedFunc";
    protected static final boolean D = true;
    protected Point2DToleranceSortedList points = null;

    public ArbitrarilyDiscretizedFunc(AbstractDiscretizedFunc func) {
        this(func.getTolerance());
        Iterator<Point2D> it = func.iterator();
        while (it.hasNext()) {
            this.set(it.next());
        }
        this.setInfo(func.getInfo());
        this.setName(func.getName());
        this.setXAxisName(func.getXAxisName());
        this.setYAxisName(func.getYAxisName());
    }

    public ArbitrarilyDiscretizedFunc(Point2DComparator comparator) {
        this(new Point2DToleranceSortedArrayList(comparator));
    }

    private ArbitrarilyDiscretizedFunc(double tolerance) {
        this(new Point2DToleranceComparator(tolerance));
    }

    public ArbitrarilyDiscretizedFunc() {
        this(new Point2DToleranceComparator());
    }

    public ArbitrarilyDiscretizedFunc(String name) {
        this();
        this.setName(name);
    }

    public ArbitrarilyDiscretizedFunc(Point2DToleranceSortedList points) {
        this.points = points;
    }

    @Override
    public void setTolerance(double newTolerance) throws InvalidRangeException {
        if (newTolerance < 0.0) {
            throw new InvalidRangeException("Tolerance must be larger or equal to 0");
        }
        this.points.setTolerance(newTolerance);
        this.tolerance = newTolerance;
    }

    @Override
    public int size() {
        return this.points.size();
    }

    @Override
    public double getMinX() {
        return this.points.getMinX();
    }

    @Override
    public double getMaxX() {
        return this.points.getMaxX();
    }

    @Override
    public double getMinY() {
        return this.points.getMinY();
    }

    @Override
    public double getMaxY() {
        return this.points.getMaxY();
    }

    @Override
    public Point2D get(int index) {
        return this.points.get(index);
    }

    @Override
    public double getX(int index) {
        Point2D pt = this.get(index);
        if (pt == null) {
            throw new IndexOutOfBoundsException("no point at index " + index);
        }
        return pt.getX();
    }

    @Override
    public double getY(int index) {
        Point2D pt = this.get(index);
        if (pt == null) {
            throw new IndexOutOfBoundsException("no point at index " + index);
        }
        return pt.getY();
    }

    @Override
    public double getY(double x) {
        return this.points.get(x).getY();
    }

    @Override
    public int getIndex(Point2D point) {
        return this.points.indexOf(point);
    }

    @Override
    public int getXIndex(double x) {
        return this.points.indexOf(new Point2D.Double(x, 0.0));
    }

    @Override
    public void set(Point2D point) {
        if (!this.points.add(point)) {
            throw new IllegalStateException("set called but nothing changed!");
        }
    }

    @Override
    public void set(double x, double y) {
        this.set(new Point2D.Double(x, y));
    }

    @Override
    public void set(int index, double y) {
        Point2D point = this.get(index);
        if (point == null) {
            throw new IndexOutOfBoundsException();
        }
        point.setLocation(point.getX(), y);
        this.set(point);
    }

    public Iterator<Point2D> getPointsIterator() {
        return this.points.iterator();
    }

    @Override
    public Iterator<Point2D> iterator() {
        return this.points.iterator();
    }

    @Override
    int getXIndexBefore(double x) {
        int ind = this.points.binarySearch(new Point2D.Double(x, 0.0));
        if (ind < 0) {
            return -ind - 2;
        }
        return ind - 1;
    }

    private double extrapolate(double x1, double x2, double y1, double y2, double x) {
        double slope = (y2 - y1) / (x2 - x1);
        double intercept = y1 - slope * x1;
        return slope * x + intercept;
    }

    public double getInterpExterpY_inLogYDomain(double x) {
        try {
            double v = this.getInterpolatedY_inLogYDomain(x);
            return v;
        }
        catch (InvalidRangeException irx) {
            if (x < this.getX(0)) {
                return Math.exp(this.extrapolate(this.getX(0), this.getX(1), Math.log(this.getY(0)), Math.log(this.getY(1)), x));
            }
            int max = this.points.size();
            return Math.exp(this.extrapolate(this.getX(max - 2), this.getX(max - 1), Math.log(this.getY(max - 2)), Math.log(this.getY(max - 1)), x));
        }
    }

    @Override
    public ArbitrarilyDiscretizedFunc deepClone() {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        function.setName(this.getName());
        function.setTolerance(this.getTolerance());
        function.setInfo(this.getInfo());
        function.setXAxisName(this.getXAxisName());
        function.setYAxisName(this.getYAxisName());
        Iterator<Point2D> it = this.iterator();
        if (it != null) {
            while (it.hasNext()) {
                function.set((Point2D)it.next().clone());
            }
        }
        return function;
    }

    public String toDebugString() {
        StringBuffer b = new StringBuffer();
        b.append("ArbitrarilyDiscretizedFunc: Log values:\n");
        for (Point2D point : this) {
            b.append(point.toString() + "\n");
        }
        return b.toString();
    }

    private void writeObject(ObjectOutputStream s) {
        Iterator<Point2D> it = this.iterator();
        try {
            s.writeObject(this.points.getComparator());
            s.writeObject(this.size());
            while (it.hasNext()) {
                Point2D data = it.next();
                s.writeObject(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s) {
        try {
            Point2DComparator comp = (Point2DComparator)s.readObject();
            this.points = new Point2DToleranceSortedArrayList(comp);
            int num = (Integer)s.readObject();
            for (int i = 0; i < num; ++i) {
                Point2D data = (Point2D)s.readObject();
                this.set(data);
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IO Exception ");
            e.printStackTrace();
        }
    }

    public ArbitrarilyDiscretizedFunc getYY_Function(DiscretizedFunc function) {
        if (this.size() != function.size()) {
            throw new InvalidRangeException("This operation cannot be performed on functions with different size");
        }
        ArbitrarilyDiscretizedFunc newFunction = new ArbitrarilyDiscretizedFunc();
        int numPoints = function.size();
        for (int j = 0; j < numPoints; ++j) {
            newFunction.set(this.getY(j), function.getY(j));
        }
        return newFunction;
    }

    public void clear() {
        this.points.clear();
    }

    public double[] getXVals() {
        double[] d = new double[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            d[i] = this.getX(i);
        }
        return d;
    }

    public double[] getYVals() {
        double[] d = new double[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            d[i] = this.getY(i);
        }
        return d;
    }

    public static void main(String[] args) {
        double[] lookups;
        ArbitrarilyDiscretizedFunc f = new ArbitrarilyDiscretizedFunc();
        f.set(100.0, 0.013609);
        f.set(250.0, 0.033695);
        f.set(500.0, 0.059583);
        f.set(1000.0, 0.093446);
        f.set(1500.0, 0.119977);
        f.set(2500.0, 0.163888);
        f.set(3000.0, 0.177374);
        f.set(5000.0, 0.228356);
        f.set(7000.0, 0.265878);
        f.set(10000.0, 0.314945);
        for (double v : lookups = new double[]{100.0, 150.0, 200.0, 250.0, 333.0, 475.0, 700.0, 800.0, 1000.0, 1200.0, 1300.0, 1500.0, 1800.0, 2000.0, 2475.0, 10000.0}) {
            int iBefore = f.getXIndexBefore(v);
            System.out.println("Trying v=" + v + ". iBefore=" + iBefore);
            System.out.flush();
            double yInterp = f.getInterpolatedY_inLogXLogYDomain(v);
            System.out.println("lookup: " + v);
            System.out.println("  iBefore: " + iBefore);
            System.out.println("  yInterp: " + yInterp);
        }
    }
}

