/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.opensha.commons.data.Point2DComparator;
import org.opensha.commons.data.Point2DToleranceSortedArrayList;

public class EmpiricalPoint2DToleranceSortedList
extends Point2DToleranceSortedArrayList {
    private static final long serialVersionUID = 1L;

    public EmpiricalPoint2DToleranceSortedList(Point2DComparator comparator) {
        this(comparator, null);
    }

    public EmpiricalPoint2DToleranceSortedList(Point2DComparator comparator, Collection<Point2D> initialValues) {
        super(comparator);
        if (initialValues != null && !initialValues.isEmpty()) {
            ArrayList<Point2D> sorted = new ArrayList<Point2D>(initialValues);
            Collections.sort(sorted, comparator);
            int index = -1;
            Point2D prev = null;
            for (Point2D val : sorted) {
                if (prev == null || comparator.compare(prev, val) != 0) {
                    super.add(++index, val);
                    prev = val;
                    continue;
                }
                prev = new Point2D.Double(prev.getX(), prev.getY() + val.getY());
                super.set(index, prev);
            }
        }
    }

    @Override
    public boolean add(Point2D e) {
        double x = e.getX();
        double y = e.getY();
        int ind = this.binarySearch(new Point2D.Double(x, 0.0));
        if (ind < 0) {
            super.add(-ind - 1, new Point2D.Double(x, y));
        } else {
            super.set(ind, new Point2D.Double(x, this.get(ind).getY() + y));
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Point2D> c) {
        boolean isNew = false;
        for (Point2D point2D : c) {
            if (!this.add(point2D)) continue;
            isNew = true;
        }
        return isNew;
    }
}

