/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;

public class HistogramFunction
extends EvenlyDiscretizedFunc {
    public HistogramFunction(double min, int num, double delta) {
        super(min, num, delta);
        this.setTolerance(this.getDelta());
    }

    public HistogramFunction(double min, double max, int num) {
        super(min, max, num);
        this.setTolerance(this.getDelta());
    }

    public void normalizeBySumOfY_Vals() {
        this.scale(1.0 / this.calcSumOfY_Vals());
    }

    public HistogramFunction getCumulativeDistFunction() {
        HistogramFunction cumHist = new HistogramFunction(this.getMinX(), this.size(), this.getDelta());
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            cumHist.set(i, sum += this.getY(i));
        }
        return cumHist;
    }

    public HistogramFunction getCumulativeDistFunctionWithHalfBinOffset() {
        HistogramFunction cumHist = new HistogramFunction(this.getMinX() - this.getDelta() / 2.0, this.size() + 1, this.getDelta());
        double sum = 0.0;
        cumHist.set(0, 0.0);
        for (int i = 1; i < cumHist.size(); ++i) {
            cumHist.set(i, sum += this.getY(i - 1));
        }
        return cumHist;
    }

    public double getMode() {
        double mode = Double.NaN;
        double max = -1.0;
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getY(i) > max)) continue;
            max = this.getY(i);
            mode = this.getX(i);
        }
        return mode;
    }

    public double computeMean() {
        double sum = this.calcSumOfY_Vals();
        double mean = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            mean += this.getX(i) * this.getY(i) / sum;
        }
        return mean;
    }

    public double computeStdDev() {
        double sum = this.calcSumOfY_Vals();
        double mean = this.computeMean();
        double var = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            var += (this.getX(i) - mean) * (this.getX(i) - mean) * this.getY(i) / sum;
        }
        return Math.sqrt(var);
    }

    public double computeCOV() {
        return this.computeStdDev() / this.computeMean();
    }

    public static HistogramFunction fromData(double[] data, double minBin, int num, double delta) {
        HistogramFunction hist = new HistogramFunction(minBin, num, delta);
        for (double val : data) {
            hist.add(val, 1.0);
        }
        return hist;
    }

    public static List<HistogramFunction> getStackedHists(List<HistogramFunction> hists, boolean normalize) {
        int i;
        Preconditions.checkArgument((hists.size() > 1 ? 1 : 0) != 0, (Object)"Must supply at least 2 histograms");
        hists = Lists.newArrayList(hists);
        Collections.reverse(hists);
        double overallTot = 0.0;
        for (HistogramFunction hist : hists) {
            overallTot += hist.calcSumOfY_Vals();
        }
        ArrayList stacked = Lists.newArrayList();
        for (int i2 = 1; i2 < hists.size(); ++i2) {
            HistogramFunction h1 = (HistogramFunction)hists.get(i2 - 1);
            HistogramFunction h2 = (HistogramFunction)hists.get(i2);
            Preconditions.checkArgument((h1.size() == h2.size() ? 1 : 0) != 0, (Object)"Histogram x values inconsistent!");
            Preconditions.checkArgument(((float)h1.getMinX() == (float)h2.getMinX() ? 1 : 0) != 0, (Object)"Histogram x values inconsistent!");
            Preconditions.checkArgument(((float)h1.getDelta() == (float)h2.getDelta() ? 1 : 0) != 0, (Object)"Histogram x values inconsistent!");
        }
        int numX = ((HistogramFunction)hists.get(0)).size();
        double[] binTots = new double[numX];
        for (HistogramFunction hist : hists) {
            HistogramFunction stackHist = new HistogramFunction(hist.getMinX(), hist.size(), hist.getDelta());
            stackHist.setName(hist.getName());
            Object info = hist.getInfo();
            info = info == null || ((String)info).isEmpty() ? "" : (String)info + "\n";
            info = (String)info + "(stacked histogram, y value data relative to histogram below, not zero)";
            info = normalize ? (String)info + "\nSum of unstacked y values: " + (float)(hist.calcSumOfY_Vals() / overallTot) : (String)info + "\nSum of unstacked y values: " + (float)hist.calcSumOfY_Vals();
            stackHist.setInfo((String)info);
            i = 0;
            while (i < hist.size()) {
                double y = hist.getY(i);
                stackHist.set(i, y + binTots[i]);
                int n = i++;
                binTots[n] = binTots[n] + y;
            }
            stacked.add(stackHist);
        }
        if (normalize) {
            double ratio = 1.0 / overallTot;
            for (HistogramFunction hist : stacked) {
                for (i = 0; i < hist.size(); ++i) {
                    hist.set(i, hist.getY(i) * ratio);
                }
            }
        }
        Collections.reverse(stacked);
        return stacked;
    }

    public static HistogramFunction getEncompassingHistogram(double minValue, double maxValue, double delta) {
        Preconditions.checkState((minValue < maxValue ? 1 : 0) != 0, (String)"Min val (%s) must be below max val (%s)", (Object)minValue, (Object)maxValue);
        double halfDelta = 0.5 * delta;
        double numBinsAwayFromZero = Math.floor(minValue / delta);
        double minX = numBinsAwayFromZero * delta + halfDelta;
        if (minValue < minX - halfDelta) {
            minX -= delta;
        } else if (minValue > minX + halfDelta) {
            minX += delta;
        }
        Preconditions.checkState((minValue <= minX + halfDelta && minValue >= minX - halfDelta ? 1 : 0) != 0);
        double maxDelta = maxValue - minX;
        int numBins = (int)(maxDelta / delta + 0.5) + 1;
        Preconditions.checkState((numBins >= 1 ? 1 : 0) != 0, (String)"bad numBins=%s for min=%s, max=%s, delta=%s", (Object)numBins, (Object)minValue, (Object)maxValue, (Object)delta);
        double maxX = minX + (double)(numBins - 1) * delta;
        double upperLeft = maxX - halfDelta;
        double upperRight = maxX + halfDelta;
        Preconditions.checkState(((float)maxValue <= (float)upperRight ? 1 : 0) != 0, (String)"upper bin with center=%s, bounds=[%s,%s] doesn't contain max=%s. Orig min=%s, max=%s, delta=%s", (Object[])new Object[]{Float.valueOf((float)maxX), Float.valueOf((float)upperLeft), Float.valueOf((float)upperRight), Float.valueOf((float)maxValue), minValue, maxValue, delta});
        Preconditions.checkState(((float)maxValue >= (float)upperLeft || upperLeft - maxValue < 1.0E-16 ? 1 : 0) != 0, (String)"upper bin with center=%s, bounds=[%s,%s] doesn't contain max=%s. Orig min=%s, max=%s, delta=%s", (Object[])new Object[]{Float.valueOf((float)maxX), Float.valueOf((float)upperLeft), Float.valueOf((float)upperRight), Float.valueOf((float)maxValue), minValue, maxValue, delta});
        return new HistogramFunction(minX, numBins, delta);
    }

    public static void main(String[] args) {
        HistogramFunction.getEncompassingHistogram(-4.2350366975140596E-4, 0.0, 5.0E-6);
    }
}

