/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.google.gson.annotations.JsonAdapter;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensha.commons.data.IntegerSampler;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.util.ComparablePairing;

@JsonAdapter(value=Adapter.class)
public class IntegerPDF_FunctionSampler
extends EvenlyDiscretizedFunc
implements IntegerSampler {
    private static final long serialVersionUID = 1L;
    boolean dataChange = true;
    double[] cumDistVals;
    double sumOfYvals;

    public IntegerPDF_FunctionSampler(int numInts) {
        super(0.0, numInts, 1.0);
        this.cumDistVals = new double[numInts];
    }

    public IntegerPDF_FunctionSampler(float[] values) {
        super(0.0, values.length, 1.0);
        this.cumDistVals = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.set(i, (double)values[i]);
        }
    }

    public IntegerPDF_FunctionSampler(double[] values) {
        super(0.0, values.length, 1.0);
        this.cumDistVals = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    public IntegerPDF_FunctionSampler(XY_DataSet xyDataSet) {
        super(0.0, xyDataSet.size(), 1.0);
        this.cumDistVals = new double[xyDataSet.size()];
        for (int i = 0; i < xyDataSet.size(); ++i) {
            this.set(i, xyDataSet.getY(i));
        }
    }

    private void updateCumDistVals() {
        int i;
        double sumOfYvals = 0.0;
        double[] cumDistVals = new double[this.cumDistVals.length];
        for (i = 0; i < this.size(); ++i) {
            cumDistVals[i] = sumOfYvals += this.getY(i);
        }
        i = 0;
        while (i < this.size()) {
            int n = i++;
            cumDistVals[n] = cumDistVals[n] / sumOfYvals;
        }
        this.sumOfYvals = sumOfYvals;
        this.cumDistVals = cumDistVals;
    }

    public double getSumOfY_vals() {
        if (this.dataChange) {
            this.updateCumDistVals();
            this.dataChange = false;
        }
        return this.sumOfYvals;
    }

    @Override
    public int getRandomInt(double randDouble) {
        return this.getInt(randDouble);
    }

    public int getInt(double prob) {
        int ind;
        if (this.dataChange) {
            this.updateCumDistVals();
            this.dataChange = false;
        }
        if ((ind = Arrays.binarySearch(this.cumDistVals, prob)) < 0) {
            ind = -(ind + 1);
        }
        if (ind >= this.size()) {
            boolean containsNaNs = false;
            for (int i = 0; i < this.size(); ++i) {
                if (!Double.isNaN(this.getY(i))) continue;
                containsNaNs = true;
                break;
            }
            throw new RuntimeException("Problem: chosen int above x-axis bounds; Y-axis contain NaNs? = " + containsNaNs + "\tsumOfAllYVals=" + this.getSumOfY_vals());
        }
        return ind;
    }

    @Override
    public void set(Point2D point) {
        super.set(point);
        this.dataChange = true;
    }

    @Override
    public void set(double x, double y) {
        super.set(x, y);
        this.dataChange = true;
    }

    @Override
    public void add(double x, double y) {
        super.add(x, y);
        this.dataChange = true;
    }

    @Override
    public void set(int index, double y) {
        super.set(index, y);
        this.dataChange = true;
    }

    @Override
    public void add(int index, double y) {
        super.add(index, y);
        this.dataChange = true;
    }

    @Override
    public void set(double min, int num, double delta) {
        super.set(min, num, delta);
        this.dataChange = true;
    }

    @Override
    public void set(double min, double max, int num) {
        super.set(min, max, num);
        this.dataChange = true;
    }

    public double[] getY_valuesArray() {
        return this.points;
    }

    public List<Integer> getOrderedIndicesOfHighestXFract(double fract) {
        Preconditions.checkArgument((fract > 0.0 && fract <= 1.0 ? 1 : 0) != 0, (String)"Fract must be between 0 and 1: %s", (Object)fract);
        ArrayList indexes = Lists.newArrayList();
        for (int i = 0; i < this.size(); ++i) {
            indexes.add(i);
        }
        List values = Doubles.asList((double[])this.points);
        List pairings = ComparablePairing.build(values, indexes);
        Collections.sort(pairings);
        Collections.reverse(pairings);
        ArrayList ret = Lists.newArrayList();
        double sum = this.getSumOfY_vals();
        double sumTarget = sum * fract;
        double runningTotal = 0.0;
        for (ComparablePairing pairing : pairings) {
            runningTotal += ((Double)pairing.getComparable()).doubleValue();
            ret.add((Integer)pairing.getData());
            if (!(runningTotal >= sumTarget)) continue;
            break;
        }
        return ret;
    }

    public static void main(String[] args) {
        double[] testVals = new double[250000];
        for (int i = 0; i < testVals.length; ++i) {
            testVals[i] = Math.random();
        }
        IntegerPDF_FunctionSampler benchSampler = new IntegerPDF_FunctionSampler(testVals);
        System.out.println("Benchmarking...");
        long st = System.currentTimeMillis();
        double sum = 0.0;
        for (int i = 0; i < 1000000000; ++i) {
            sum += (double)benchSampler.getInt(Math.random());
        }
        long elapsed = System.currentTimeMillis() - st;
        System.out.println("benchmark test sum of " + sum + " after " + elapsed + " ms");
        double[] values = new double[]{1.0, 10.0, 0.01, 5.0, 100.0, 6.0, 0.1};
        IntegerPDF_FunctionSampler sampler = new IntegerPDF_FunctionSampler(values);
        System.out.println("Data: " + Joiner.on((String)",").join((Iterable)Doubles.asList((double[])values)));
        sampler.updateCumDistVals();
        System.out.println("Sorted data: " + Joiner.on((String)",").join((Iterable)Doubles.asList((double[])sampler.cumDistVals)));
        System.out.println(sampler.getInt(0.0));
        System.out.println(sampler.getInt(0.00818933748259765));
        System.out.println(sampler.getInt(0.00818933748259766));
        System.out.println(sampler.getInt(0.089));
        System.out.println(sampler.getInt(0.0901));
        System.out.println(sampler.getInt(0.092));
        System.out.println(sampler.getInt(0.1));
        try {
            System.out.println(sampler.getInt(1.0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sum = 0.0;
        st = System.currentTimeMillis();
        for (int i = 0; i < 1000000000; ++i) {
            sum += (double)sampler.getInt(Math.random());
        }
        elapsed = System.currentTimeMillis() - st;
        System.out.println("sum of " + sum + " after " + elapsed + " ms");
    }

    public static class Adapter
    extends DiscretizedFunc.AbstractAdapter<IntegerPDF_FunctionSampler> {
        @Override
        protected IntegerPDF_FunctionSampler instance(Double minX, Double maxX, Integer size) {
            Preconditions.checkNotNull((Object)size, (Object)"size must be supplied before values to deserialize IntegerPDF_FunctionSampler");
            return new IntegerPDF_FunctionSampler(size);
        }

        @Override
        protected Class<IntegerPDF_FunctionSampler> getType() {
            return IntegerPDF_FunctionSampler.class;
        }
    }
}

