/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.binFile.BinaryMesh2DCalculator;
import org.opensha.commons.util.binFile.GeolocatedRectangularBinaryMesh2DCalculator;

public abstract class AbstractBinarySiteDataLoader
extends AbstractSiteData<Double> {
    protected static final String s = File.separator;
    private int nx;
    private int ny;
    private double minLat;
    private double minLon;
    private double gridSpacing;
    private boolean startBottom;
    private boolean startLeft;
    private String type;
    protected boolean useServlet;
    protected File dataFile;
    protected GeolocatedRectangularBinaryMesh2DCalculator calc;
    private SiteDataServletAccessor<Double> servlet = null;
    private RandomAccessFile file;
    private byte[] recordBuffer;
    private FloatBuffer floatBuff;
    protected long maxFilePos;

    public AbstractBinarySiteDataLoader(int nx, int ny, double minLat, double minLon, double gridSpacing, boolean startBottom, boolean startLeft, String type, File dataFile, boolean useServlet) throws IOException {
        this.nx = nx;
        this.ny = ny;
        this.minLat = minLat;
        this.minLon = minLon;
        this.gridSpacing = gridSpacing;
        this.startBottom = startBottom;
        this.startLeft = startLeft;
        this.type = type;
        this.useServlet = useServlet;
        this.maxFilePos = (nx * ny - 1) * 4;
        this.calc = new GeolocatedRectangularBinaryMesh2DCalculator(BinaryMesh2DCalculator.DataType.FLOAT, nx, ny, minLat, minLon, gridSpacing);
        if (useServlet) {
            this.servlet = new SiteDataServletAccessor<Double>(this, this.getServletURL(type));
        } else {
            if (dataFile == null) {
                dataFile = this.getDefaultFile(type);
            }
            this.file = new RandomAccessFile(dataFile, "r");
            this.calc.setStartBottom(startBottom);
            this.calc.setStartLeft(startLeft);
            this.recordBuffer = new byte[4];
            ByteBuffer record = ByteBuffer.wrap(this.recordBuffer);
            record.order(ByteOrder.LITTLE_ENDIAN);
            this.floatBuff = record.asFloatBuffer();
        }
        if (this.isBasinDepth()) {
            this.initDefaultBasinParams();
            this.paramList.addParameter(this.minBasinDoubleParam);
            this.paramList.addParameter(this.maxBasinDoubleParam);
        }
        this.dataFile = dataFile;
    }

    private boolean isBasinDepth() {
        return this.getDataType().equals("Depth to Vs = 1.0 km/sec") || this.getDataType().equals("Depth to Vs = 2.5 km/sec");
    }

    protected abstract File getDefaultFile(String var1);

    protected abstract String getServletURL(String var1);

    protected void setDataFile(File dataFile) throws FileNotFoundException {
        Preconditions.checkNotNull((Object)dataFile, (Object)"data file cannot be null.");
        Preconditions.checkArgument((boolean)dataFile.exists(), (Object)(dataFile.getAbsolutePath() + " doesn't exist!"));
        this.dataFile = dataFile;
        this.file = new RandomAccessFile(dataFile, "r");
    }

    @Override
    public final Region getApplicableRegion() {
        return this.calc.getApplicableRegion();
    }

    @Override
    public final Location getClosestDataLocation(Location loc) {
        return this.calc.calcClosestLocation(loc);
    }

    @Override
    public final double getResolution() {
        return this.gridSpacing;
    }

    @Override
    public final String getDataType() {
        return this.type;
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        if (this.useServlet) {
            double val = this.servlet.getValue(loc);
            if (Double.isNaN(val)) {
                return val;
            }
            if (this.isBasinDepth()) {
                return this.certifyMinMaxBasinDepth(val);
            }
            return val;
        }
        long pos = this.calc.calcClosestLocationFileIndex(loc);
        return this.getValue(pos);
    }

    protected Double getValue(long pos) throws IOException {
        if (pos > this.maxFilePos || pos < 0L) {
            return Double.NaN;
        }
        this.file.seek(pos);
        this.file.read(this.recordBuffer);
        double val = this.floatBuff.get(0);
        if (this.isBasinDepth()) {
            if (val < 0.0) {
                return Double.NaN;
            }
            Double dobVal = val / 1000.0;
            return this.certifyMinMaxBasinDepth(dobVal);
        }
        return val;
    }

    @Override
    public final ArrayList<Double> getValues(LocationList locs) throws IOException {
        if (this.useServlet) {
            ArrayList<Double> vals = this.servlet.getValues(locs);
            if (this.isBasinDepth()) {
                for (int i = 0; i < vals.size(); ++i) {
                    vals.set(i, this.certifyMinMaxBasinDepth(vals.get(i)));
                }
            }
            return vals;
        }
        return super.getValues(locs);
    }

    @Override
    public final boolean isValueValid(Double val) {
        if (this.isBasinDepth() && val < 0.0) {
            return false;
        }
        return val != null && !Double.isNaN(val);
    }
}

