/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.CachedSiteDataWrapper;
import org.opensha.commons.data.siteData.SiteData;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.data.siteData.SiteDataValueList;
import org.opensha.commons.data.siteData.impl.CS_Study18_8_BasinDepth;
import org.opensha.commons.data.siteData.impl.CVM2BasinDepth;
import org.opensha.commons.data.siteData.impl.CVM4BasinDepth;
import org.opensha.commons.data.siteData.impl.CVM4i26BasinDepth;
import org.opensha.commons.data.siteData.impl.CVM4i26_M01_TaperBasinDepth;
import org.opensha.commons.data.siteData.impl.CVMHBasinDepth;
import org.opensha.commons.data.siteData.impl.CVM_CCAi6BasinDepth;
import org.opensha.commons.data.siteData.impl.CVM_Vs30;
import org.opensha.commons.data.siteData.impl.MeanTopoSlope;
import org.opensha.commons.data.siteData.impl.SRTM30PlusTopoSlope;
import org.opensha.commons.data.siteData.impl.SRTM30PlusTopography;
import org.opensha.commons.data.siteData.impl.SRTM30TopoSlope;
import org.opensha.commons.data.siteData.impl.SRTM30Topography;
import org.opensha.commons.data.siteData.impl.ThompsonVs30_2018;
import org.opensha.commons.data.siteData.impl.ThompsonVs30_2022;
import org.opensha.commons.data.siteData.impl.USGSBayAreaBasinDepth;
import org.opensha.commons.data.siteData.impl.USGS_SFBay_BasinDepth_v21p1;
import org.opensha.commons.data.siteData.impl.US_3secTopography;
import org.opensha.commons.data.siteData.impl.WaldAllenGlobalVs30;
import org.opensha.commons.data.siteData.impl.WillsMap2000;
import org.opensha.commons.data.siteData.impl.WillsMap2000TranslatedVs30;
import org.opensha.commons.data.siteData.impl.WillsMap2006;
import org.opensha.commons.data.siteData.impl.WillsMap2015;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.XMLUtils;

public class OrderedSiteDataProviderList
implements Iterable<SiteData<?>>,
XMLSaveable,
Cloneable {
    public static final String XML_METADATA_NAME = "OrderedSiteDataProviderList";
    private ArrayList<SiteData<?>> providers;
    private ArrayList<Boolean> enabled = new ArrayList();
    private boolean checkValues = true;
    private ArrayList<ChangeListener> changeListeners = null;

    public OrderedSiteDataProviderList(ArrayList<SiteData<?>> providers) {
        this.providers = providers;
        for (int i = 0; i < providers.size(); ++i) {
            this.enabled.add(true);
        }
    }

    public SiteData<?> getProviderForLocation(Location loc) {
        for (int i = 0; i < this.providers.size(); ++i) {
            if (!this.isEnabled(i)) continue;
            SiteData<?> data = this.providers.get(i);
            Region region = data.getApplicableRegion();
            if (!data.hasDataForLocation(loc, this.checkValues)) continue;
            return data;
        }
        return null;
    }

    public SiteDataValue<?> getPreferredValue(Location loc) throws IOException {
        for (int i = 0; i < this.providers.size(); ++i) {
            SiteData<?> provider;
            SiteDataValue<?> val;
            if (!this.isEnabled(i) || (val = this.getCheckedDataFromProvider(provider = this.providers.get(i), loc)) == null) continue;
            return val;
        }
        return null;
    }

    private SiteDataValue<?> getCheckedDataFromProvider(SiteData provider, Location loc) throws IOException {
        return this.getCheckedDataFromProvider(provider, loc, this.checkValues);
    }

    private SiteDataValue<?> getCheckedDataFromProvider(SiteData provider, Location loc, boolean checkValid) throws IOException {
        if (provider.hasDataForLocation(loc, false)) {
            SiteDataValue val = provider.getAnnotatedValue(loc);
            if (!checkValid || provider.isValueValid(val.getValue())) {
                return val;
            }
        }
        return null;
    }

    public ArrayList<SiteDataValueList<?>> getAllAvailableData(List<Site> sites) throws IOException {
        LocationList locs = new LocationList();
        for (Site site : sites) {
            locs.add(site.getLocation());
        }
        return this.getAllAvailableData(locs);
    }

    public ArrayList<SiteData<?>> getEnabledProviders() {
        ArrayList en = new ArrayList();
        for (int i = 0; i < this.providers.size(); ++i) {
            if (!this.isEnabled(i)) continue;
            en.add(this.providers.get(i));
        }
        return en;
    }

    public ArrayList<SiteDataValueList<?>> getAllAvailableData(LocationList locs) throws IOException {
        ArrayList datas = new ArrayList();
        for (SiteData<?> prov : this.getEnabledProviders()) {
            datas.add(prov.getAnnotatedValues(locs));
        }
        return datas;
    }

    public ArrayList<SiteDataValue<?>> getAllAvailableData(Location loc) {
        ArrayList vals = new ArrayList();
        for (int i = 0; i < this.providers.size(); ++i) {
            if (!this.isEnabled(i)) continue;
            SiteData<?> provider = this.providers.get(i);
            try {
                SiteDataValue<?> val = provider.getAnnotatedValue(loc);
                if (val == null) continue;
                vals.add(val);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("IOException with " + provider.getShortName(), e);
            }
        }
        return vals;
    }

    public ArrayList<SiteDataValue<?>> getBestAvailableData(Location loc) {
        return this.doGetBestAvailableData(loc, null);
    }

    public SiteDataValue<?> getBestAvailableData(Location loc, String dataType) {
        Preconditions.checkNotNull((Object)dataType, (Object)"Must specify data type");
        ArrayList<SiteDataValue<?>> vals = this.doGetBestAvailableData(loc, dataType);
        if (vals.isEmpty()) {
            return null;
        }
        Preconditions.checkState((vals.size() == 1 ? 1 : 0) != 0);
        return (SiteDataValue)vals.get(0);
    }

    private ArrayList<SiteDataValue<?>> doGetBestAvailableData(Location loc, String dataType) {
        ArrayList vals = new ArrayList();
        ArrayList<String> completedTypes = new ArrayList<String>();
        for (int i = 0; i < this.providers.size(); ++i) {
            if (!this.isEnabled(i)) continue;
            SiteData<?> provider = this.providers.get(i);
            String type = provider.getDataType();
            if (dataType != null && !dataType.equals(type) || completedTypes.contains(type)) continue;
            try {
                SiteDataValue<?> val = this.getCheckedDataFromProvider(provider, loc);
                if (val == null) continue;
                vals.add(val);
                completedTypes.add(type);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("IOException with " + provider.getShortName(), e);
            }
        }
        return vals;
    }

    public void enableOnlyFirstForEachType() {
        ArrayList<String> doneTypes = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            String type = this.getProvider(i).getDataType();
            boolean enabled = true;
            for (String oldType : doneTypes) {
                if (!oldType.equals(type)) continue;
                enabled = false;
                break;
            }
            this.setEnabled(i, enabled);
            if (!enabled) continue;
            doneTypes.add(type);
        }
        this.fireChangeEvent();
    }

    public int size() {
        return this.providers.size();
    }

    public ArrayList<SiteData<?>> getList() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.providers.size(); ++i) {
            if (!this.isEnabled(i)) continue;
            SiteData<?> data = this.providers.get(i);
            list.add(data);
        }
        return list;
    }

    public int getIndexOf(SiteData<?> data) {
        return this.providers.indexOf(data);
    }

    public SiteData<?> remove(int index) {
        this.enabled.remove(index);
        return this.providers.remove(index);
    }

    public void add(SiteData<?> data) {
        this.providers.add(data);
        this.enabled.add(true);
    }

    public void add(int index, SiteData<?> data) {
        this.providers.add(index, data);
        this.enabled.add(index, true);
    }

    public void set(int index, SiteData<?> data) {
        this.providers.set(index, data);
        this.fireChangeEvent();
    }

    public void promote(int index) {
        this.swap(index, index - 1);
        this.fireChangeEvent();
    }

    public void demote(int index) {
        this.swap(index, index + 1);
        this.fireChangeEvent();
    }

    public void swap(int index1, int index2) {
        SiteData<?> one = this.providers.get(index1);
        boolean enabledOne = this.enabled.get(index1);
        SiteData<?> two = this.providers.get(index2);
        boolean enabledTwo = this.enabled.get(index2);
        this.providers.set(index1, two);
        this.providers.set(index2, one);
        this.enabled.set(index1, enabledTwo);
        this.enabled.set(index2, enabledOne);
    }

    public SiteData<?> getProvider(int index) {
        return this.providers.get(index);
    }

    public boolean isEnabled(int index) {
        return this.enabled.get(index);
    }

    public void setEnabled(int index, boolean enabled) {
        this.enabled.set(index, enabled);
        this.fireChangeEvent();
    }

    public boolean isAtLeastOneEnabled() {
        for (Boolean en : this.enabled) {
            if (!en.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<SiteData<?>> iterator() {
        return this.providers.iterator();
    }

    public static OrderedSiteDataProviderList createSiteDataProviderDefaults() {
        ArrayList providers = new ArrayList();
        try {
            providers.add(new ThompsonVs30_2022());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new WillsMap2015());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new ThompsonVs30_2018());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new WillsMap2006());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new WaldAllenGlobalVs30());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVM4i26BasinDepth("Depth to Vs = 2.5 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVM4i26BasinDepth("Depth to Vs = 1.0 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVM_CCAi6BasinDepth("Depth to Vs = 2.5 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVM_CCAi6BasinDepth("Depth to Vs = 1.0 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVM4BasinDepth("Depth to Vs = 2.5 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVM4BasinDepth("Depth to Vs = 1.0 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVMHBasinDepth("Depth to Vs = 2.5 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVMHBasinDepth("Depth to Vs = 1.0 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVM_CCAi6BasinDepth("Depth to Vs = 2.5 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVM_CCAi6BasinDepth("Depth to Vs = 1.0 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new USGS_SFBay_BasinDepth_v21p1("Depth to Vs = 2.5 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new USGS_SFBay_BasinDepth_v21p1("Depth to Vs = 1.0 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new USGSBayAreaBasinDepth("Depth to Vs = 2.5 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new USGSBayAreaBasinDepth("Depth to Vs = 1.0 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int numEnabled = providers.size();
        try {
            providers.add(new CVM_Vs30(CVM_Vs30.CVM_DEFAULT));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVM2BasinDepth());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        providers.add(new WillsMap2000());
        OrderedSiteDataProviderList list = new OrderedSiteDataProviderList(providers);
        for (int i = numEnabled; i < list.size(); ++i) {
            list.setEnabled(i, false);
        }
        return list;
    }

    public static OrderedSiteDataProviderList createSiteDataMapProviders() {
        ArrayList<SiteData<?>> providers = OrderedSiteDataProviderList.createDebugSiteDataProviders().getList();
        for (int i = 0; i < providers.size(); ++i) {
            if (providers.get(i).getName() != "CGS/Wills Preliminary Site Classification Map (2000)") continue;
            WillsMap2000TranslatedVs30 wills = new WillsMap2000TranslatedVs30();
            providers.set(i, wills);
            break;
        }
        try {
            providers.add(new US_3secTopography());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new SRTM30PlusTopography());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new SRTM30PlusTopoSlope());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new SRTM30Topography());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new SRTM30TopoSlope());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new MeanTopoSlope());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CS_Study18_8_BasinDepth("Depth to Vs = 2.5 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CS_Study18_8_BasinDepth("Depth to Vs = 1.0 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVM4i26_M01_TaperBasinDepth("Depth to Vs = 2.5 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            providers.add(new CVM4i26_M01_TaperBasinDepth("Depth to Vs = 1.0 km/sec"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new OrderedSiteDataProviderList(providers);
    }

    public static OrderedSiteDataProviderList createCachedSiteDataProviderDefaults() {
        OrderedSiteDataProviderList list = OrderedSiteDataProviderList.createSiteDataProviderDefaults();
        for (int i = 0; i < list.size(); ++i) {
            CachedSiteDataWrapper cached = new CachedSiteDataWrapper(list.getProvider(i));
            list.set(i, cached);
        }
        return list;
    }

    public static OrderedSiteDataProviderList createCompatibilityProviders(boolean useOldData) {
        ArrayList providers = new ArrayList();
        if (useOldData) {
            providers.add(new WillsMap2000());
            try {
                providers.add(new CVM2BasinDepth());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            providers.add(new WillsMap2006());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            providers.add(new CVM4BasinDepth("Depth to Vs = 2.5 km/sec"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new OrderedSiteDataProviderList(providers);
    }

    public static OrderedSiteDataProviderList createDebugSiteDataProviders() {
        return OrderedSiteDataProviderList.createSiteDataProviderDefaults();
    }

    public void printList() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            SiteData<?> provider = this.getProvider(i);
            boolean enabled = this.isEnabled(i);
            if (enabled) {
                System.out.println(i + ". " + String.valueOf(provider));
                continue;
            }
            System.out.println(i + ". <disabled> " + String.valueOf(provider));
        }
    }

    public void removeDisabledProviders() {
        ArrayList newProvs = new ArrayList();
        ArrayList<Boolean> newEnabled = new ArrayList<Boolean>();
        for (int i = 0; i < this.providers.size(); ++i) {
            if (!this.isEnabled(i)) continue;
            newProvs.add(this.providers.get(i));
            newEnabled.add(true);
        }
        this.providers = newProvs;
        this.enabled = newEnabled;
        this.fireChangeEvent();
    }

    public String toString() {
        String str = "OrderedSiteDataProviderList - " + this.size() + " providers.\n";
        for (int i = 0; i < this.size(); ++i) {
            SiteData<?> prov = this.getProvider(i);
            String enabledStr = this.isEnabled(i) ? " (enabled)" : " (disabled)";
            str = str + "\n" + i + ". " + prov.getName() + ": " + prov.getDataType() + enabledStr;
        }
        return str;
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    private void fireChangeEvent() {
        if (this.changeListeners == null || this.changeListeners.size() == 0) {
            return;
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(e);
        }
    }

    public OrderedSiteDataProviderList clone() {
        ArrayList list = (ArrayList)this.providers.clone();
        OrderedSiteDataProviderList newList = new OrderedSiteDataProviderList(list);
        for (int i = 0; i < this.size(); ++i) {
            newList.setEnabled(i, this.isEnabled(i));
        }
        return newList;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        Element listEl = el.addElement("ProviderList");
        for (int i = 0; i < this.size(); ++i) {
            SiteData<?> provider = this.getProvider(i);
            Element provEl = listEl.addElement("Provider");
            provEl.addAttribute("Priority", "" + i);
            provEl.addAttribute("Enabled", "" + this.isEnabled(i));
            provider.toXMLMetadata(provEl);
        }
        return root;
    }

    public static OrderedSiteDataProviderList fromXMLMetadata(Element orderedListEl) throws IOException {
        Element listEl = orderedListEl.element("ProviderList");
        Iterator it = listEl.elementIterator();
        ArrayList providers = new ArrayList();
        ArrayList<Boolean> enableds = new ArrayList<Boolean>();
        ArrayList<Integer> priorities = new ArrayList<Integer>();
        while (it.hasNext()) {
            Element provEl = (Element)it.next();
            int priority = Integer.parseInt(provEl.attributeValue("Priority"));
            boolean enabled = Boolean.parseBoolean(provEl.attributeValue("Enabled"));
            Element subEl = provEl.element("SiteDataAPI");
            SiteData<?> provider = AbstractSiteData.fromXMLMetadata(subEl);
            providers.add(provider);
            priorities.add(priority);
            enableds.add(enabled);
        }
        ArrayList ordered = new ArrayList();
        ArrayList<Boolean> orderedEnableds = new ArrayList<Boolean>();
        for (int i = 0; i < providers.size(); ++i) {
            SiteData provider = null;
            boolean enabled = false;
            for (int j = 0; j < priorities.size(); ++j) {
                int priority = (Integer)priorities.get(j);
                if (priority != i) continue;
                provider = (SiteData)providers.get(j);
                enabled = (Boolean)enableds.get(j);
                break;
            }
            if (provider == null) {
                throw new RuntimeException("Malformed list!");
            }
            ordered.add(provider);
            orderedEnableds.add(enabled);
        }
        OrderedSiteDataProviderList list = new OrderedSiteDataProviderList(ordered);
        for (int i = 0; i < orderedEnableds.size(); ++i) {
            list.setEnabled(i, (Boolean)orderedEnableds.get(i));
        }
        return list;
    }

    public void mergeWith(OrderedSiteDataProviderList newList) {
        ArrayList toAdd = new ArrayList();
        for (int j = 0; j < newList.size(); ++j) {
            SiteData<?> newProv = newList.getProvider(j);
            boolean shouldAdd = true;
            for (int i = 0; i < this.size(); ++i) {
                SiteData<?> curProv = this.getProvider(i);
                if (!curProv.getName().equals(newProv.getName())) continue;
                this.set(i, newProv);
                shouldAdd = false;
                this.setEnabled(i, newList.isEnabled(j));
                break;
            }
            if (!shouldAdd) continue;
            this.add(newProv);
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Orig:");
        OrderedSiteDataProviderList list = OrderedSiteDataProviderList.createSiteDataProviderDefaults();
        list.setEnabled(0, false);
        list.setEnabled(3, false);
        list.printList();
        Document doc = XMLUtils.createDocumentWithRoot();
        Element root = doc.getRootElement();
        list.toXMLMetadata(root);
        Element el = root.element(XML_METADATA_NAME);
        XMLUtils.writeDocumentToFile(new File("/tmp/list.xml"), doc);
        list = OrderedSiteDataProviderList.fromXMLMetadata(el);
        System.out.println("After:");
        list.printList();
    }
}

