/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData;

import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.data.siteData.SiteDataValueList;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListEditor;

public interface SiteData<Element>
extends Named,
XMLSaveable {
    public static final String XML_METADATA_NAME = "SiteDataAPI";
    public static final String TYPE_VS30 = "Vs30";
    public static final String TYPE_WILLS_CLASS = "Wills Class";
    public static final String TYPE_DEPTH_TO_2_5 = "Depth to Vs = 2.5 km/sec";
    public static final String TYPE_DEPTH_TO_1_0 = "Depth to Vs = 1.0 km/sec";
    public static final String TYPE_ELEVATION = "Elevation (m)";
    public static final String TYPE_TOPOGRAPHIC_SLOPE = "Topographic Slope (m/m)";
    public static final String TYPE_TECTONIC_REGIME = "Tectonic Regime";
    public static final String TYPE_FLAG_MEASURED = "Measured";
    public static final String TYPE_FLAG_INFERRED = "Inferred";

    public Region getApplicableRegion();

    public double getResolution();

    @Override
    public String getName();

    public String getShortName();

    public String getDataType();

    public String getDataMeasurementType();

    public Location getClosestDataLocation(Location var1) throws IOException;

    public Element getValue(Location var1) throws IOException;

    public SiteDataValue<Element> getAnnotatedValue(Location var1) throws IOException;

    public SiteDataValueList<Element> getAnnotatedValues(LocationList var1) throws IOException;

    public ArrayList<Element> getValues(LocationList var1) throws IOException;

    public boolean isValueValid(Element var1);

    public boolean hasDataForLocation(Location var1, boolean var2);

    public ParameterList getAdjustableParameterList();

    public ParameterListEditor getParameterListEditor();

    public String getMetadata();
}

