/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.data.siteData.SiteDataValueList;
import org.opensha.commons.geo.Location;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.XMLUtils;

public class SiteDataValueListList
implements XMLSaveable {
    public static final String XML_METADATA_NAME = "SiteDataValuesList";
    private ArrayList<SiteDataValueList<?>> lists;
    private int size = -1;
    private boolean hasLocations = true;

    public SiteDataValueListList(ArrayList<SiteDataValueList<?>> lists) {
        this.lists = lists;
        for (SiteDataValueList<?> list : lists) {
            if (this.size < 0) {
                this.size = list.size();
            }
            if (this.size != list.size()) {
                throw new RuntimeException("The size of each list must be same!");
            }
            if (list.hasLocations()) continue;
            this.hasLocations = false;
        }
    }

    public int size() {
        return this.size;
    }

    public int getNumProviders() {
        return this.lists.size();
    }

    public ArrayList<SiteDataValue<?>> getDataList(int index) {
        ArrayList datas = new ArrayList();
        for (SiteDataValueList<?> list : this.lists) {
            datas.add(list.getValue(index));
        }
        return datas;
    }

    public Location getDataLocation(int index) {
        return this.lists.get(0).getLocationAt(index);
    }

    public boolean hasLocations() {
        return this.hasLocations;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element listEl = root.addElement(XML_METADATA_NAME);
        for (int i = 0; i < this.getNumProviders(); ++i) {
            SiteDataValueList<?> vals = this.lists.get(i);
            Element provEl = listEl.addElement("Values");
            provEl.addAttribute("Priority", "" + i);
            vals.toXMLMetadata(provEl);
        }
        return root;
    }

    public static SiteDataValueListList fromXMLMetadata(Element listsEl) {
        Iterator it = listsEl.elementIterator();
        ArrayList lists = new ArrayList();
        ArrayList<Integer> priorities = new ArrayList<Integer>();
        while (it.hasNext()) {
            Element listEl = (Element)it.next();
            int priority = Integer.parseInt(listEl.attributeValue("Priority"));
            Element valsEl = listEl.element("SiteDataValueList");
            SiteDataValueList<?> vals = SiteDataValueList.fromXMLMetadata(valsEl);
            lists.add(vals);
            priorities.add(priority);
        }
        ArrayList ordered = new ArrayList();
        for (int i = 0; i < lists.size(); ++i) {
            SiteDataValueList list = null;
            for (int j = 0; j < priorities.size(); ++j) {
                if ((Integer)priorities.get(j) != i) continue;
                list = (SiteDataValueList)lists.get(j);
                break;
            }
            if (list == null) {
                throw new RuntimeException("Malformed priorities list!");
            }
            ordered.add(list);
        }
        return new SiteDataValueListList(ordered);
    }

    public static void main(String[] args) throws IOException {
        ArrayList<Double> vals = new ArrayList<Double>();
        vals.add(0.5);
        vals.add(1.5);
        vals.add(2.5);
        vals.add(3.5);
        vals.add(4.5);
        vals.add(5.5);
        vals.add(6.5);
        SiteDataValueList list = new SiteDataValueList("Vs30", "Asdfs", vals, null);
        SiteDataValueList list2 = new SiteDataValueList("Vs30", "Asdfs", vals, null);
        SiteDataValueList list3 = new SiteDataValueList("Vs30", "Asdfs", vals, null);
        ArrayList lists = new ArrayList();
        lists.add(list);
        lists.add(list2);
        lists.add(list3);
        SiteDataValueListList valsLists = new SiteDataValueListList(lists);
        Document doc = XMLUtils.createDocumentWithRoot();
        Element root = doc.getRootElement();
        root = valsLists.toXMLMetadata(root);
        XMLUtils.writeDocumentToFile(new File("/tmp/vals.xml"), doc);
        Element listsEl = root.element(XML_METADATA_NAME);
        valsLists = SiteDataValueListList.fromXMLMetadata(listsEl);
    }
}

