/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.gui;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.SiteData;
import org.opensha.commons.data.siteData.SiteDataValueList;
import org.opensha.commons.data.siteData.gui.SiteDataCombinedApp;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.gui.CSVTable;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.IntegerDiscreteConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.util.CustomFileFilter;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.bugReports.BugReport;
import org.opensha.commons.util.bugReports.SimpleBugMessagePanel;

public class BatchDownloadGUI
extends JFrame
implements ActionListener,
ParameterChangeListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private OrderedSiteDataProviderList list;
    private JButton loadButton = new JButton("Load Sites");
    private String loadButtonInfo = "<html>Loads a list of locations where site data is to be retreived.<br><br>Data can be in CSV or TXT (space/tab delimeted) formats. You will be<br>prompted to specify which columns contain the laitude/longitude values.</html>";
    private JButton saveButton = new JButton("Save Data");
    private String saveButtonInfo = "<html>Saves the current data to a CSV or TXT file.</html>";
    private JButton fetchPreferredButton = new JButton("Fetch Preferred Data");
    private String fetchPreferredButtonInfo = "<html>This retrieves and stores the first valid value of each data type<br>from the currently enabled data sources, in order of priority.</html>";
    private JButton fetchAllButton = new JButton("Fetch All Data");
    private String fetchAllButtonInfo = "<html>This retrieves and stores all data values from the<br>currently enabled data sources, in order of priority.</html>";
    private JFileChooser loadChooser;
    private JFileChooser saveChooser;
    private CustomFileFilter csvFilter = new CustomFileFilter(".csv", "CSV file");
    private CustomFileFilter txtFilter = new CustomFileFilter(".txt", "TXT file (tab/space delimeted)");
    private LocationList locations;
    private CSVFile<String> inputCSV;
    private CSVFile<String> dataCSV;
    private ArrayList<SiteDataValueList<?>> valLists;
    private CSVTable table = new CSVTable();
    private IntegerParameter numColumnsParam;
    private IntegerParameter latColumnParam;
    private IntegerParameter lonColumnParam;
    private ParameterList inputFormatParamList;
    private ParameterListEditor inputFormatEditor;
    private IntegerParameter txtHeaderLinesParam;
    private BooleanParameter csvHasHeaderParam;

    public BatchDownloadGUI(OrderedSiteDataProviderList list) {
        this.setTitle("Batch Data Download");
        this.list = list;
        this.table.setEditingEnabled(false);
        list.addChangeListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.saveButton.setEnabled(false);
        this.fetchPreferredButton.setEnabled(false);
        this.fetchAllButton.setEnabled(false);
        this.loadButton.setToolTipText(this.loadButtonInfo);
        this.saveButton.setToolTipText(this.saveButtonInfo);
        this.fetchPreferredButton.setToolTipText(this.fetchPreferredButtonInfo);
        this.fetchAllButton.setToolTipText(this.fetchAllButtonInfo);
        this.loadButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.fetchPreferredButton.addActionListener(this);
        this.fetchAllButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.loadButton);
        buttonPanel.add(this.saveButton);
        buttonPanel.add(this.fetchPreferredButton);
        buttonPanel.add(this.fetchAllButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        JScrollPane tableScroll = new JScrollPane(this.table);
        this.getContentPane().add((Component)tableScroll, "Center");
        this.setSize(800, 600);
    }

    private static ArrayList<Integer> getDiscrete(int max) {
        ArrayList<Integer> vals = new ArrayList<Integer>();
        for (int i = 1; i <= max; ++i) {
            vals.add(i);
        }
        return vals;
    }

    private ParameterListEditor getInputFormatParamEditor(File file) {
        if (this.inputFormatParamList == null) {
            this.numColumnsParam = new IntegerParameter("Num. Columns", 2, 20);
            this.numColumnsParam.setValue(2);
            this.numColumnsParam.addParameterChangeListener(this);
            IntegerDiscreteConstraint colConst = new IntegerDiscreteConstraint(BatchDownloadGUI.getDiscrete((Integer)this.numColumnsParam.getValue()));
            this.latColumnParam = new IntegerParameter("Latitude Column");
            this.latColumnParam.setConstraint(colConst);
            this.latColumnParam.setValue(1);
            this.lonColumnParam = new IntegerParameter("Longitude Column");
            this.lonColumnParam.setConstraint(colConst);
            this.lonColumnParam.setValue(2);
            this.txtHeaderLinesParam = new IntegerParameter("Num. Header Lines", 0, 100);
            this.txtHeaderLinesParam.setValue(0);
            this.csvHasHeaderParam = new BooleanParameter("1st Line Is Header?", true);
            this.inputFormatParamList = new ParameterList();
            this.inputFormatParamList.addParameter(this.numColumnsParam);
            this.inputFormatParamList.addParameter(this.latColumnParam);
            this.inputFormatParamList.addParameter(this.lonColumnParam);
            this.inputFormatParamList.addParameter(this.txtHeaderLinesParam);
            this.inputFormatParamList.addParameter(this.csvHasHeaderParam);
            this.inputFormatEditor = new ParameterListEditor(this.inputFormatParamList);
        }
        boolean csv = file.getName().toLowerCase().endsWith(".csv");
        this.inputFormatEditor.setParameterVisible(this.txtHeaderLinesParam.getName(), !csv);
        this.inputFormatEditor.setParameterVisible(this.csvHasHeaderParam.getName(), csv);
        return this.inputFormatEditor;
    }

    private boolean isInputConfigurationValid() {
        int numColumns = (Integer)this.numColumnsParam.getValue();
        int latColumn = (Integer)this.latColumnParam.getValue();
        int lonColumn = (Integer)this.lonColumnParam.getValue();
        if (latColumn < 1 || lonColumn < 1) {
            return false;
        }
        if (latColumn > numColumns || lonColumn > numColumns) {
            return false;
        }
        return latColumn != lonColumn;
    }

    private static void validateLatLon(List<String> line, int lineNumber, int latColumn, int lonColumn) {
        String latStr = line.get(latColumn - 1);
        String lonStr = line.get(lonColumn - 1);
        try {
            double lat = Double.parseDouble(latStr);
            GeoTools.validateLat(lat);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Incorrectly formatted latitutde value at line " + lineNumber + ": " + latStr);
        }
        try {
            double lon = Double.parseDouble(lonStr);
            GeoTools.validateLon(lon);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Incorrectly formatted longitude value at line " + lineNumber + ": " + lonStr);
        }
    }

    private static ArrayList<String> buildDefaultHeader(int numColumns, int latColumn, int lonColumn) {
        ArrayList<String> header = new ArrayList<String>();
        for (int i = 0; i < numColumns; ++i) {
            header.add("");
        }
        header.set(latColumn - 1, "Latitude");
        header.set(lonColumn - 1, "Longitude");
        return header;
    }

    private static CSVFile<String> loadTxtAsCsv(File file, int numColumns, int latColumn, int lonColumn, int headerLines) throws IOException {
        CSVFile<String> csv = new CSVFile<String>(true);
        ArrayList<String> header = BatchDownloadGUI.buildDefaultHeader(numColumns, latColumn, lonColumn);
        csv.addLine((List<String>)header);
        ArrayList<String> lines = FileUtils.loadFile(file.getAbsolutePath(), false);
        for (int i = 0; i < lines.size(); ++i) {
            String line;
            if (i < headerLines || (line = lines.get(i)) == null || line.length() == 0) continue;
            StringTokenizer tok = new StringTokenizer(line);
            Preconditions.checkState((tok.countTokens() == numColumns ? 1 : 0) != 0, (Object)("Incorrect number of columns found at line " + (i + 1) + ". Expected: " + numColumns + ", Actual: " + tok.countTokens()));
            ArrayList<String> strings = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                strings.add(tok.nextToken());
            }
            BatchDownloadGUI.validateLatLon(strings, i + 1, latColumn, lonColumn);
            csv.addLine((List<String>)strings);
        }
        return csv;
    }

    private void loadFile(File file) throws IOException {
        int i;
        CSVFile<String> csv;
        int numColumns = (Integer)this.numColumnsParam.getValue();
        int latColumn = (Integer)this.latColumnParam.getValue();
        int lonColumn = (Integer)this.lonColumnParam.getValue();
        if (file.getName().toLowerCase().endsWith(".csv")) {
            csv = CSVFile.readFile(file, true, numColumns);
            if (!((Boolean)this.csvHasHeaderParam.getValue()).booleanValue()) {
                ArrayList<String> header = BatchDownloadGUI.buildDefaultHeader(numColumns, latColumn, lonColumn);
                CSVFile<String> newCSV = new CSVFile<String>(true);
                newCSV.addLine((List<String>)header);
                for (List<String> list : csv) {
                    newCSV.addLine(list);
                }
                csv = newCSV;
            }
            for (i = 1; i < csv.getNumRows(); ++i) {
                BatchDownloadGUI.validateLatLon(csv.getLine(i), i + 1, latColumn, lonColumn);
            }
        } else {
            csv = BatchDownloadGUI.loadTxtAsCsv(file, numColumns, latColumn, lonColumn, (Integer)this.txtHeaderLinesParam.getValue());
        }
        if (csv.getNumRows() <= 1) {
            throw new RuntimeException("No valid locations loaded!");
        }
        this.fetchPreferredButton.setEnabled(true);
        this.fetchAllButton.setEnabled(true);
        this.saveButton.setEnabled(false);
        this.valLists = null;
        this.dataCSV = null;
        this.table.setEditingEnabled(false);
        this.inputCSV = csv;
        this.table.setCSV(csv, true);
        this.locations = new LocationList();
        for (i = 1; i < csv.getNumRows(); ++i) {
            List<String> line = csv.getLine(i);
            double lat = Double.parseDouble(line.get(latColumn - 1));
            double lon = Double.parseDouble(line.get(lonColumn - 1));
            this.locations.add(new Location(lat, lon));
        }
    }

    private void saveFile(File file) throws IOException {
        CSVFile<String> csv = this.table.buildCSVFromTable(true);
        if (file.getName().toLowerCase().endsWith(".csv")) {
            csv.writeToFile(file);
            return;
        }
        csv.writeToTabSeparatedFile(file, 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block10: {
            block12: {
                int ret;
                block11: {
                    int selection;
                    int ret2;
                    if (e.getSource() != this.loadButton) break block11;
                    if (this.loadChooser == null) {
                        this.loadChooser = new JFileChooser();
                        this.loadChooser.addChoosableFileFilter(this.csvFilter);
                        this.loadChooser.addChoosableFileFilter(this.txtFilter);
                    }
                    if ((ret2 = this.loadChooser.showOpenDialog(this)) != 0) break block10;
                    File file = this.loadChooser.getSelectedFile();
                    ParameterListEditor editor = this.getInputFormatParamEditor(file);
                    while ((selection = JOptionPane.showConfirmDialog(this, editor, "Input File Format", 2)) == 0) {
                        if (!this.isInputConfigurationValid()) {
                            JOptionPane.showMessageDialog(this, "Latitude & Longitude columns can't be equal!", "Error with Input Format", 0);
                            continue;
                        }
                        try {
                            this.loadFile(file);
                            break block10;
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            JOptionPane.showMessageDialog(this, "Error Loading File:\n" + e1.getMessage(), "Error Loading File", 0);
                        }
                    }
                    break block10;
                }
                if (e.getSource() != this.saveButton) break block12;
                if (this.saveChooser == null) {
                    this.saveChooser = new JFileChooser(this.loadChooser.getCurrentDirectory());
                    this.saveChooser.addChoosableFileFilter(this.csvFilter);
                    this.saveChooser.addChoosableFileFilter(this.txtFilter);
                }
                if ((ret = this.saveChooser.showSaveDialog(this)) != 0) break block10;
                File file = this.saveChooser.getSelectedFile();
                try {
                    this.saveFile(file);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    this.showBugReportDialog(e1, "Error fetching saving data:\n" + e1.getMessage(), "Error Saving Site Data");
                }
                break block10;
            }
            if (e.getSource() != this.fetchAllButton && e.getSource() != this.fetchPreferredButton) break block10;
            try {
                this.fetch(e.getSource() == this.fetchPreferredButton);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                this.showBugReportDialog(e1, "Error fetching site data:\n" + e1.getMessage(), "Error Fetching Site Data");
            }
        }
    }

    private void showBugReportDialog(Throwable t, String message, String title) {
        BugReport bug = new BugReport(t, "Loading site data", "SiteData", SiteDataCombinedApp.getAppVersion(), this);
        SimpleBugMessagePanel panel = new SimpleBugMessagePanel(bug, message);
        JOptionPane.showMessageDialog(this, panel, title, 0);
    }

    private void fetch(boolean preferred) throws IOException {
        if (this.valLists == null) {
            this.valLists = this.list.getAllAvailableData(this.locations);
        }
        CSVFile<String> csv = preferred ? this.fetchPreferred() : this.fetchAll();
        this.dataCSV = csv;
        this.table.setEditingEnabled(true);
        this.saveButton.setEnabled(true);
        this.table.setCSV(this.dataCSV, true);
    }

    private static ArrayList<String> copyOf(List<String> line) {
        ArrayList<String> copy = new ArrayList<String>();
        for (String val : line) {
            copy.add(val);
        }
        return copy;
    }

    private CSVFile<String> fetchAll() throws IOException {
        ArrayList<SiteData<?>> providers = this.list.getEnabledProviders();
        Preconditions.checkState((this.valLists.size() == providers.size() ? 1 : 0) != 0);
        CSVFile<String> dataCSV = new CSVFile<String>(true);
        ArrayList<String> header = BatchDownloadGUI.copyOf(this.inputCSV.getLine(0));
        for (SiteData<?> provider : providers) {
            header.add(provider.getDataType() + " (" + provider.getShortName() + ")");
        }
        dataCSV.addLine((List<String>)header);
        for (int i = 0; i < this.locations.size(); ++i) {
            int csvI = i + 1;
            ArrayList<String> line = BatchDownloadGUI.copyOf(this.inputCSV.getLine(csvI));
            for (SiteDataValueList<?> valList : this.valLists) {
                Object val = valList.getValue(i).getValue();
                if (val == null) {
                    line.add(null);
                    continue;
                }
                line.add(val.toString());
            }
            dataCSV.addLine((List<String>)line);
        }
        return dataCSV;
    }

    private CSVFile<String> fetchPreferred() throws IOException {
        ArrayList<SiteData<?>> providers = this.list.getEnabledProviders();
        Preconditions.checkState((this.valLists.size() == providers.size() ? 1 : 0) != 0);
        CSVFile<String> dataCSV = new CSVFile<String>(true);
        ArrayList<String> header = BatchDownloadGUI.copyOf(this.inputCSV.getLine(0));
        ArrayList<String> dataTypes = new ArrayList<String>();
        for (SiteDataValueList<?> valList : this.valLists) {
            String type = valList.getType();
            if (dataTypes.contains(type)) continue;
            dataTypes.add(type);
        }
        header.addAll(dataTypes);
        dataCSV.addLine((List<String>)header);
        for (int i = 0; i < this.locations.size(); ++i) {
            int csvI = i + 1;
            ArrayList<String> line = BatchDownloadGUI.copyOf(this.inputCSV.getLine(csvI));
            for (String type : dataTypes) {
                Object val = null;
                Object rejectVal = null;
                for (int j = 0; j < this.valLists.size(); ++j) {
                    SiteDataValueList<?> valList = this.valLists.get(j);
                    if (!valList.getType().equals(type)) continue;
                    SiteData<?> provider = providers.get(j);
                    Object testVal = valList.getValue(i).getValue();
                    if (testVal == null) continue;
                    if (provider.isValueValid(testVal)) {
                        val = testVal;
                        break;
                    }
                    rejectVal = testVal;
                }
                if (val == null) {
                    val = rejectVal;
                }
                if (val == null) {
                    line.add(null);
                    continue;
                }
                line.add(val.toString());
            }
            dataCSV.addLine((List<String>)line);
        }
        return dataCSV;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.numColumnsParam) {
            int cols = (Integer)this.numColumnsParam.getValue();
            IntegerDiscreteConstraint colConst = new IntegerDiscreteConstraint(BatchDownloadGUI.getDiscrete(cols));
            if ((Integer)this.latColumnParam.getValue() > cols) {
                this.latColumnParam.setValue(1);
            }
            this.latColumnParam.setConstraint(colConst);
            this.latColumnParam.getEditor().refreshParamEditor();
            if ((Integer)this.lonColumnParam.getValue() > cols) {
                this.lonColumnParam.setValue(1);
            }
            this.lonColumnParam.setConstraint(colConst);
            this.lonColumnParam.getEditor().refreshParamEditor();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.list) {
            this.valLists = null;
        }
    }
}

