/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.SiteData;
import org.opensha.commons.data.siteData.SiteDataValueList;
import org.opensha.commons.data.siteData.gui.beans.OrderedSiteDataGUIBean;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.mapping.gmt.gui.GMT_MapGuiBean;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;

public class SiteDataMapApplet
extends JPanel
implements ActionListener,
ListSelectionListener {
    private OrderedSiteDataGUIBean dataBean;
    private GMT_MapGuiBean mapBean;
    private JButton mapButton = new JButton("Create Map");
    private String mapButtonInfo = "<html>This creates a map for each of the currently<br>selected data sources.</html>";
    private JButton mapMultiButton = new JButton("Create Mosaic Map");
    private String mapMultiButtonInfo = "<html>This creates single map from all of the currently selected data<br>sources. At each point, the first valid value (in order of priority)<br>is used.<br><br><b>Note that all data sources must be of the same data<br>type to enable mosaic maps.</b></html>";
    private JButton regionButton = new JButton("Set Region from Data");
    private String regionButtonInfo = "<html>This sets the region in the map attribes settings to equal<br>the applicable region for the current data source(s).</html>";

    public SiteDataMapApplet() {
        this.dataBean = new OrderedSiteDataGUIBean(OrderedSiteDataProviderList.createSiteDataMapProviders());
        this.dataBean.addListSelectionListener(this);
        this.mapBean = new GMT_MapGuiBean();
        this.mapBean.getParameterList().getParameter("Plot Log").setValue(false);
        this.mapBean.getParameterList().getParameter("Apply GMT Smoothing?").setValue(false);
        this.mapBean.getParameterList().getParameter("Topo Resolution").setValue("No Topo");
        this.mapBean.getParameterList().getParameter("Coast").setValue("Draw Boundary");
        this.mapBean.refreshParamEditor();
        this.setLayout(new BorderLayout());
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        this.mapButton.setToolTipText(this.mapButtonInfo);
        bottomPanel.add(this.mapButton);
        this.mapMultiButton.setToolTipText(this.mapMultiButtonInfo);
        bottomPanel.add(this.mapMultiButton);
        this.regionButton.setToolTipText(this.regionButtonInfo);
        bottomPanel.add(this.regionButton);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 0));
        centerPanel.add(this.dataBean);
        centerPanel.add(this.mapBean);
        this.add((Component)centerPanel, "Center");
        this.add((Component)bottomPanel, "South");
        this.mapButton.addActionListener(this);
        this.mapMultiButton.addActionListener(this);
        this.regionButton.addActionListener(this);
        this.setPreferredSize(new Dimension(900, 600));
        this.valueChanged(null);
    }

    private void makeMap(ArrayList<Double> zVals, LocationList locs, String label, String meta) {
        Parameter customParam = this.mapBean.getParameterList().getParameter("Custom Scale Label");
        boolean custom = (Boolean)customParam.getValue();
        if (!custom && label != null && ((String)label).length() > 0) {
            customParam.setValue(true);
            System.out.println("Label: " + (String)label);
            label = "'" + (String)label + "'";
            this.mapBean.getParameterList().getParameter("Scale Label").setValue(label);
        }
        ArbDiscrGeoDataSet xyz = new ArbDiscrGeoDataSet(true);
        for (int i = 0; i < locs.size(); ++i) {
            xyz.set((Location)locs.get(i), (double)zVals.get(i));
        }
        this.mapBean.makeMap(xyz, meta);
        customParam.setValue(custom);
    }

    private void makeCombinedMap() throws IOException {
        ArrayList<SiteData<?>> providers = this.dataBean.getSelectedProviders();
        ArrayList valListList = new ArrayList();
        GriddedRegion region = this.mapBean.getEvenlyGriddedGeographicRegion();
        LocationList locs = region.getNodeList();
        Object meta = "Combined map from the following providers (sorted by priority):\n\n";
        for (int i = 0; i < providers.size(); ++i) {
            SiteData<?> doubProvider = providers.get(i);
            meta = (String)meta + i + ". " + doubProvider.getName();
            ArrayList<?> doubVals = doubProvider.getValues(locs);
            valListList.add(new SiteDataValueList(doubVals, doubProvider));
        }
        ArrayList<Double> zVals = new ArrayList<Double>();
        for (int i = 0; i < locs.size(); ++i) {
            Double val = Double.NaN;
            for (SiteDataValueList siteDataValueList : valListList) {
                Double newVal = (Double)siteDataValueList.getValue(i).getValue();
                if (newVal.isNaN()) continue;
                val = newVal;
                break;
            }
            zVals.add(val);
        }
        this.makeMap(zVals, locs, providers.get(0).getDataType(), (String)meta);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mapButton) {
            System.out.println("Making a map...");
            ArrayList<SiteData<?>> providers = this.dataBean.getSelectedProviders();
            if (providers.size() == 0) {
                System.out.println("No data provider selected!");
                return;
            }
            Iterator<SiteData<?>> iterator = providers.iterator();
            while (iterator.hasNext()) {
                SiteData<?> provider;
                SiteData<?> doubProvider = provider = iterator.next();
                try {
                    Object label = doubProvider.getName() + " -  " + doubProvider.getDataType();
                    if (((String)label).length() > 20) {
                        label = doubProvider.getShortName() + " - " + doubProvider.getDataType();
                    }
                    if (((String)label).length() > 20) {
                        label = doubProvider.getDataType();
                    }
                    GriddedRegion region = this.mapBean.getEvenlyGriddedGeographicRegion();
                    LocationList locs = region.getNodeList();
                    ArrayList<Double> zVals = doubProvider.getValues(locs);
                    String meta = doubProvider.getName();
                    this.makeMap(zVals, locs, (String)label, meta);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        } else if (e.getSource() == this.mapMultiButton) {
            try {
                this.makeCombinedMap();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource() == this.regionButton) {
            SiteData<?> provider = this.dataBean.getSelectedProvider();
            if (provider == null) {
                System.out.println("No data provider selected!");
                return;
            }
            Region region = provider.getApplicableRegion();
            ParameterList paramList = this.mapBean.getParameterList();
            paramList.getParameter("Min Latitude").setValue(region.getMinLat());
            paramList.getParameter("Max Latitude").setValue(region.getMaxLat());
            paramList.getParameter("Min Longitude").setValue(region.getMinLon());
            paramList.getParameter("Max Longitude").setValue(region.getMaxLon());
            this.mapBean.refreshParamEditor();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        SiteDataMapApplet applet = new SiteDataMapApplet();
        frame.setContentPane(applet);
        frame.setDefaultCloseOperation(3);
        frame.setSize(applet.getPreferredSize());
        frame.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean selected = this.dataBean.isSelected();
        this.mapButton.setEnabled(selected);
        this.regionButton.setEnabled(selected);
        ArrayList<SiteData<?>> providers = this.dataBean.getSelectedProviders();
        if (selected && providers.size() > 1) {
            String type = providers.get(0).getDataType();
            boolean enable = true;
            for (SiteData<?> provider : providers) {
                if (provider.getDataType().equals(type)) continue;
                enable = false;
                break;
            }
            this.mapMultiButton.setEnabled(enable);
        } else {
            this.mapMultiButton.setEnabled(false);
        }
    }
}

