/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.SiteData;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.data.siteData.gui.beans.SiteDataCellRenderer;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.util.SiteDataTypeParameterNameMap;
import org.opensha.sha.util.SiteTranslator;

public class OrderedSiteDataGUIBean
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private OrderedSiteDataProviderList list;
    private Collection<? extends ScalarIMR> imrs;
    private SiteDataTypeParameterNameMap map = SiteTranslator.DATA_TYPE_PARAM_NAME_MAP;
    private JButton upButton = new JButton("Up");
    private JButton downButton = new JButton("Down");
    private JButton enableButton = new JButton("Enable");
    private JButton disableButton = new JButton("Disable");
    private JButton helpButton = new JButton("Help");
    private SiteData<?> currentData;
    private JTextArea metadataArea = new JTextArea(8, 50);
    private JPanel dataPanel = new JPanel(new BorderLayout());
    private JList dataList;
    public static int width = 400;
    private ParameterListEditor paramEdit = null;
    private SiteDataCellRenderer cellRenderer = null;

    public OrderedSiteDataGUIBean(OrderedSiteDataProviderList list) {
        this(list, null);
    }

    public OrderedSiteDataGUIBean(OrderedSiteDataProviderList list, Collection<ScalarIMR> imrs) {
        super(new BorderLayout());
        this.imrs = imrs;
        this.cellRenderer = new SiteDataCellRenderer(list.size());
        this.dataList = new JList();
        this.dataList.setLayoutOrientation(0);
        this.dataList.addListSelectionListener(this);
        this.dataList.setCellRenderer(this.cellRenderer);
        this.dataList.setSelectedIndex(-1);
        this.setProviderList(list);
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 1));
        Font titleFont = new Font("Title", 1, 20);
        Font subtitleFont = new Font("Title", 2, 14);
        JLabel title = new JLabel("Available Data Sources");
        title.setFont(titleFont);
        JLabel subtitle = new JLabel("Sorted by priority, colored by data type.");
        subtitle.setFont(subtitleFont);
        northPanel.add(title);
        northPanel.add(subtitle);
        JPanel selectorPanel = new JPanel(new BorderLayout());
        selectorPanel.add((Component)northPanel, "North");
        selectorPanel.add((Component)this.dataList, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel leftButtonPanel = new JPanel();
        leftButtonPanel.setLayout(new BoxLayout(leftButtonPanel, 0));
        JPanel rightButtonPanel = new JPanel();
        rightButtonPanel.setLayout(new BoxLayout(rightButtonPanel, 0));
        leftButtonPanel.add(this.enableButton);
        leftButtonPanel.add(this.disableButton);
        rightButtonPanel.add(this.upButton);
        rightButtonPanel.add(this.downButton);
        rightButtonPanel.add(new JSeparator(1));
        rightButtonPanel.add(this.helpButton);
        buttonPanel.add((Component)leftButtonPanel, "West");
        buttonPanel.add((Component)rightButtonPanel, "East");
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.enableButton.addActionListener(this);
        this.disableButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.enableButton.setEnabled(false);
        this.disableButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        selectorPanel.add((Component)buttonPanel, "South");
        this.metadataArea.setLineWrap(true);
        this.metadataArea.setWrapStyleWord(true);
        JScrollPane scroll = new JScrollPane(this.metadataArea);
        scroll.setSize(width, 300);
        scroll.setMaximumSize(new Dimension(width, 300));
        this.dataPanel.add((Component)scroll, "North");
        this.add((Component)selectorPanel, "North");
        this.add((Component)this.dataPanel, "Center");
    }

    public void setProviderList(OrderedSiteDataProviderList list) {
        this.list = list;
        this.currentData = list.getProvider(0);
        this.updateList();
        this.updateDataGUI();
    }

    public void refreshAll() {
        int[] selected = this.dataList.getSelectedIndices();
        this.updateList();
        this.dataList.setSelectedIndices(selected);
        this.dataPanel.validate();
        this.validate();
        this.repaint();
    }

    private void updateList() {
        ArrayList<CallSite> names = new ArrayList<CallSite>();
        int num = 1;
        for (int i = 0; i < this.list.size(); ++i) {
            SiteData<?> provider = this.list.getProvider(i);
            this.cellRenderer.setType(i, provider.getDataType());
            if (this.imrs == null || this.map.isTypeApplicable(provider.getDataType(), this.imrs)) {
                if (this.list.isEnabled(i)) {
                    names.add((CallSite)((Object)(num + ". " + provider.getName() + " (" + provider.getDataType() + ")")));
                    ++num;
                    this.cellRenderer.setEnabled(i, true);
                    this.cellRenderer.setApplicable(i, true);
                    continue;
                }
                names.add((CallSite)((Object)("<disabled> " + provider.getName() + " (" + provider.getDataType() + ")")));
                this.cellRenderer.setEnabled(i, false);
                this.cellRenderer.setApplicable(i, true);
                continue;
            }
            this.list.setEnabled(i, false);
            this.cellRenderer.setEnabled(i, false);
            this.cellRenderer.setApplicable(i, false);
            names.add((CallSite)((Object)("<not applicable> " + provider.getName() + " (" + provider.getDataType() + ")")));
        }
        this.dataList.setListData(names.toArray());
        this.dataList.validate();
    }

    public void setIMR(ScalarIMR imr) {
        ArrayList<ScalarIMR> imrs = new ArrayList<ScalarIMR>();
        imrs.add(imr);
        this.setIMR(imrs);
    }

    public void setIMR(Collection<? extends ScalarIMR> imrs) {
        if (imrs != null && imrs.contains(null)) {
            imrs.remove(null);
        }
        if (imrs != null && imrs.isEmpty()) {
            imrs = null;
        }
        this.imrs = imrs;
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.setEnabled(i, true);
        }
        this.updateList();
        this.dataList.setSelectedIndex(-1);
        this.currentData = this.list.getProvider(0);
        this.updateDataGUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.upButton || e.getSource() == this.downButton) {
            int i;
            boolean up = e.getSource() == this.upButton;
            int[] indexes = this.dataList.getSelectedIndices();
            int[] selected = new int[indexes.length];
            int maxIndex = this.list.size() - 1;
            ArrayList toMove = new ArrayList();
            for (int index : indexes) {
                toMove.add(this.list.getProvider(index));
            }
            for (i = 0; i < toMove.size(); ++i) {
                boolean enabled;
                int index;
                int j = up ? i : toMove.size() - 1 - i;
                SiteData data = (SiteData)toMove.get(j);
                index = this.list.getIndexOf(data);
                if (up) {
                    if (index == 0) {
                        enabled = this.list.isEnabled(0);
                        this.list.remove(0);
                        this.list.add(data);
                        this.list.setEnabled(maxIndex, enabled);
                        continue;
                    }
                    this.list.promote(index);
                    continue;
                }
                if (index == maxIndex) {
                    enabled = this.list.isEnabled(maxIndex);
                    this.list.remove(maxIndex);
                    this.list.add(0, data);
                    this.list.setEnabled(0, enabled);
                    continue;
                }
                this.list.demote(index);
            }
            for (i = 0; i < toMove.size(); ++i) {
                selected[i] = this.list.getIndexOf((SiteData)toMove.get(i));
            }
            this.updateList();
            this.dataList.setSelectedIndices(selected);
        } else if (e.getSource() == this.enableButton || e.getSource() == this.disableButton) {
            boolean enabled = e.getSource() == this.enableButton;
            int[] indexes = this.dataList.getSelectedIndices();
            for (int i = 0; i < indexes.length; ++i) {
                int index = indexes[i];
                this.list.setEnabled(index, enabled);
            }
            this.updateList();
            this.dataList.setSelectedIndices(indexes);
        } else if (e.getSource() == this.helpButton) {
            this.showHelp();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean somethingSelected;
        int index = this.dataList.getSelectedIndex();
        boolean bl = somethingSelected = index >= 0;
        if (!somethingSelected) {
            index = 0;
        }
        this.enableButton.setEnabled(somethingSelected);
        this.disableButton.setEnabled(somethingSelected);
        this.upButton.setEnabled(somethingSelected);
        this.downButton.setEnabled(somethingSelected);
        SiteData<?> newData = this.list.getProvider(index);
        if (newData != this.currentData) {
            this.currentData = newData;
            this.updateDataGUI();
        }
    }

    private void showHelp() {
        String help = "This is used to set site type information for a site or gridded region.The list shows all of the available sources of site data, in order of priority. When setting site parameters for the given Attenuation Relationship, the highest priority applicable data source with valid data for the given location will be used. \n\nFor example, if a Vs30 value and a Wills Site classification are available, and the Attenuation Relationship uses Vs30, then the Vs30 parameter will be set by whichever has higher priority. If the Vs30 data source is higher priority, and is a valid value (>0 and not NaN), that will be used. If the Wills Site Classification data source has higher priority, it will be translated  to a Vs30 value and used.\n\nYou can adjust priority for data sources by selecting the source in the list, and pressing the Up/Down button. Additionally, data sourcescan be enabled or disabled with the Enable/Disable buttons.";
        JTextArea area = new JTextArea(15, 40);
        area.setText(help);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setEditable(false);
        JScrollPane scroll = new JScrollPane(area);
        area.setCaretPosition(0);
        JOptionPane.showMessageDialog(this, scroll, "Site Data Selection Help", 1);
    }

    private void updateDataGUI() {
        String meta = "Name: " + this.currentData.getName() + "\n";
        meta = meta + "Type: " + this.currentData.getDataType() + "\n";
        meta = meta + "Type Flag: " + this.currentData.getDataMeasurementType() + "\n";
        meta = meta + "Resolution: " + this.currentData.getResolution() + " degrees\n\n";
        meta = meta + this.currentData.getMetadata() + "\n\n";
        meta = meta + "Region: " + this.currentData.getApplicableRegion().toString();
        this.metadataArea.setText(meta);
        this.metadataArea.setCaretPosition(0);
        if (this.paramEdit != null) {
            this.dataPanel.remove(this.paramEdit);
        }
        this.paramEdit = this.currentData.getParameterListEditor();
        this.dataPanel.add((Component)this.paramEdit, "Center");
        this.dataPanel.validate();
        this.dataPanel.repaint();
        this.validate();
    }

    public OrderedSiteDataProviderList getProviderList() {
        return this.list;
    }

    public static Component getDataDisplayComponent(ArrayList<SiteDataValue<?>> datas) {
        return OrderedSiteDataGUIBean.getDataDisplayComponent(datas, null);
    }

    public static Component getDataDisplayComponent(ArrayList<SiteDataValue<?>> datas, Location loc) {
        Object text = loc == null ? "" : "Site data for Location: " + loc.getLatitude() + ", " + loc.getLongitude();
        if (datas == null || datas.size() == 0) {
            if (((String)text).length() > 0) {
                text = (String)text + "\n\n";
            }
            text = (String)text + "No data available";
        } else {
            text = (String)text;
            for (SiteDataValue<?> data : datas) {
                if (((String)text).length() > 0) {
                    text = (String)text + "\n\n";
                }
                text = (String)text + "Source: " + data.getSourceName() + "\n";
                text = (String)text + "\tType: " + data.getDataType() + "\n";
                text = (String)text + "\tType Flag: " + data.getDataMeasurementType() + "\n";
                text = (String)text + "\tValue: " + String.valueOf(data.getValue());
            }
        }
        JTextArea area = new JTextArea(15, 40);
        area.setText((String)text);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setEditable(false);
        JScrollPane scroll = new JScrollPane(area);
        area.setCaretPosition(0);
        return scroll;
    }

    public static void showDataDisplayDialog(ArrayList<SiteDataValue<?>> datas, Component parent) {
        OrderedSiteDataGUIBean.showDataDisplayDialog(datas, parent, null);
    }

    public static void showDataDisplayDialog(ArrayList<SiteDataValue<?>> datas, Component parent, Location loc) {
        Component comp = OrderedSiteDataGUIBean.getDataDisplayComponent(datas, loc);
        JOptionPane.showMessageDialog(parent, comp, "Site Data Values", 1);
    }

    public SiteData<?> getSelectedProvider() {
        int index = this.dataList.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return this.list.getProvider(index);
    }

    public ArrayList<SiteData<?>> getSelectedProviders() {
        ArrayList providers = new ArrayList();
        int[] indexes = this.dataList.getSelectedIndices();
        Arrays.sort(indexes);
        for (int index : indexes) {
            providers.add(this.list.getProvider(index));
        }
        return providers;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.dataList.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.dataList.removeListSelectionListener(listener);
    }

    public boolean isSelected() {
        return this.dataList.getSelectedIndex() >= 0;
    }

    public static void main(String[] args) {
        JFrame window = new JFrame();
        OrderedSiteDataProviderList list = OrderedSiteDataProviderList.createDebugSiteDataProviders();
        OrderedSiteDataGUIBean bean = new OrderedSiteDataGUIBean(list, null);
        window.setContentPane(bean);
        window.setSize(width, 600);
        window.setDefaultCloseOperation(3);
        window.setVisible(true);
    }
}

