/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.gui.beans;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class SiteDataCellRenderer
extends DefaultListCellRenderer {
    private ArrayList<String> types;
    private ArrayList<Boolean> enabled;
    private ArrayList<Boolean> applicable;
    private static final Color NOT_APPLICABLE_COLOR = Color.GRAY;
    private static final Color DEFAULT_ENABLED_COLOR = Color.WHITE;
    private static final Color DEFAULT_DISABLED_COLOR = Color.LIGHT_GRAY;
    private static final Color SELECTED_COLOR = new Color(100, 100, 255);
    public static HashMap<String, Color> TYPE_COLOR_MAP = new HashMap();

    public SiteDataCellRenderer(ArrayList<String> types, ArrayList<Boolean> enabled, ArrayList<Boolean> applicable) {
        this.types = types;
        this.enabled = enabled;
        this.applicable = applicable;
    }

    public SiteDataCellRenderer(int num) {
        this.types = new ArrayList();
        this.enabled = new ArrayList();
        this.applicable = new ArrayList();
        for (int i = 0; i < num; ++i) {
            this.types.add(null);
            this.enabled.add(null);
            this.applicable.add(null);
        }
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (index < this.types.size()) {
            String type = this.types.get(index);
            boolean enabled = this.enabled.get(index);
            boolean applicable = this.applicable.get(index);
            if (isSelected) {
                this.setBackground(SELECTED_COLOR);
            } else if (applicable) {
                Color color = TYPE_COLOR_MAP.get(type);
                if (enabled) {
                    if (color != null) {
                        this.setBackground(color);
                    } else {
                        this.setBackground(DEFAULT_ENABLED_COLOR);
                    }
                } else if (color != null) {
                    Color bkg = color.darker();
                    this.setBackground(bkg);
                } else {
                    this.setBackground(DEFAULT_DISABLED_COLOR);
                }
            } else {
                this.setBackground(NOT_APPLICABLE_COLOR);
            }
        }
        return this;
    }

    public void setType(int index, String type) {
        this.types.set(index, type);
    }

    public void setEnabled(int index, boolean enabled) {
        this.enabled.set(index, enabled);
    }

    public void setApplicable(int index, boolean applicable) {
        this.applicable.set(index, applicable);
    }

    public void setTypes(ArrayList<String> types) {
        this.types = types;
    }

    public void setEnabled(ArrayList<Boolean> enabled) {
        this.enabled = enabled;
    }

    public void setApplicable(ArrayList<Boolean> applicable) {
        this.applicable = applicable;
    }

    static {
        TYPE_COLOR_MAP.put("Vs30", new Color(255, 200, 200));
        TYPE_COLOR_MAP.put("Wills Class", new Color(200, 255, 200));
        TYPE_COLOR_MAP.put("Depth to Vs = 2.5 km/sec", new Color(200, 200, 255));
        TYPE_COLOR_MAP.put("Depth to Vs = 1.0 km/sec", new Color(255, 195, 150));
        TYPE_COLOR_MAP.put("Elevation (m)", new Color(255, 255, 115));
        TYPE_COLOR_MAP.put("Topographic Slope (m/m)", new Color(150, 255, 255));
    }
}

