/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import org.opensha.commons.data.siteData.AbstractBinarySiteDataLoader;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.ServerPrefUtils;

public class CVMHBasinDepth
extends AbstractBinarySiteDataLoader
implements ParameterChangeListener {
    public static final String NAME = "SCEC/Harvard Community Velocity Model Version 11.9.x Basin Depth";
    public static final String SHORT_NAME = "CVMH";
    public static final double minLat = 31.0;
    public static final double minLon = -121.0;
    private static final int nx = 1701;
    private static final int ny = 1101;
    private static final double grid_spacing = 0.005;
    public static final String DEFAULT_DATA_DIR = "src" + s + "main" + s + "resources" + s + "data" + s + "site" + s + "CVMH" + s;
    public static final String DEPTH_2_5_FILE_PREFIX = "depth_2.5";
    public static final String DEPTH_1_0_FILE_PREFIX = "depth_1.0";
    public static final String SERVLET_2_5_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/CVMH_2_5";
    public static final String SERVLET_1_0_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/CVMH_1_0";
    private File dataDir;
    public static final String VERSION_PARAM_NAME = "Version";
    private EnumParameter<Version> versionParam;
    public static final Version VERSION_DEFAULT = Version.VER_11_9_1;
    public static final String GTL_PARAM_NAME = "Include Geotechnical Layer (GTL)";
    private BooleanParameter gtlParam;
    public static final Boolean GTL_PARAM_DEFAULT = true;

    public CVMHBasinDepth(String type) throws IOException {
        this(type, null, true);
    }

    public CVMHBasinDepth(String type, File dataDir, boolean useServlet) throws IOException {
        super(1701, 1101, 31.0, -121.0, 0.005, true, true, type, CVMHBasinDepth.getDataFile(type, dataDir, VERSION_DEFAULT, GTL_PARAM_DEFAULT), useServlet);
        this.dataDir = dataDir;
        this.versionParam = new EnumParameter<Version>(VERSION_PARAM_NAME, EnumSet.allOf(Version.class), VERSION_DEFAULT, null);
        this.versionParam.addParameterChangeListener(this);
        this.paramList.addParameter(this.versionParam);
        this.serverParamsList.addParameter(this.versionParam);
        this.gtlParam = new BooleanParameter(GTL_PARAM_NAME, GTL_PARAM_DEFAULT);
        this.gtlParam.addParameterChangeListener(this);
        this.paramList.addParameter(this.gtlParam);
        this.serverParamsList.addParameter(this.gtlParam);
        this.updateFile();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public String getMetadata() {
        return this.getDataType() + ", CVMH 11.9.0 extracted with UCVM 12.2.0 on May 21 2012 by Patrick Small";
    }

    @Override
    protected File getDefaultFile(String type) {
        return CVMHBasinDepth.getDataFile(type, this.dataDir, VERSION_DEFAULT, GTL_PARAM_DEFAULT);
    }

    private void updateFile() {
        if (this.useServlet) {
            return;
        }
        String type = this.getDataType();
        File dataFile = CVMHBasinDepth.getDataFile(type, this.dataDir, (Version)((Object)this.versionParam.getValue()), (Boolean)this.gtlParam.getValue());
        try {
            this.setDataFile(dataFile);
        }
        catch (FileNotFoundException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
    }

    private static File getDataFile(String type, File dataDir, Version version, boolean includeGTL) {
        String prefix;
        if (dataDir == null) {
            return null;
        }
        Preconditions.checkState((boolean)dataDir.exists(), (Object)("CVMH Data Dir Not Found: " + dataDir.getAbsolutePath()));
        File subDir = new File(dataDir, version.dirName);
        Preconditions.checkState((boolean)subDir.exists(), (Object)("CVMH Sub Dir Not Found: " + subDir.getAbsolutePath()));
        if (type.equals("Depth to Vs = 1.0 km/sec")) {
            prefix = DEPTH_1_0_FILE_PREFIX;
        } else if (type.equals("Depth to Vs = 2.5 km/sec")) {
            prefix = DEPTH_2_5_FILE_PREFIX;
        } else {
            throw new IllegalStateException("Unsupported type: " + type);
        }
        File dataFile = includeGTL ? new File(subDir, prefix + "_with_gtl.bin") : new File(subDir, prefix + "_no_gtl.bin");
        Preconditions.checkState((boolean)dataFile.exists(), (Object)("CVMH Data File Not Found: " + dataFile.getAbsolutePath()));
        return dataFile;
    }

    @Override
    protected String getServletURL(String type) {
        if (type.equals("Depth to Vs = 1.0 km/sec")) {
            return SERVLET_1_0_URL;
        }
        return SERVLET_2_5_URL;
    }

    public static void main(String[] args) throws IOException {
        CVMHBasinDepth cvmh = new CVMHBasinDepth("Depth to Vs = 2.5 km/sec");
        System.out.println(cvmh.getApplicableRegion());
        System.out.print(cvmh.getValue(new Location(34.0, -118.0)));
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.versionParam) {
            boolean gtlVal;
            Version newVersion = (Version)((Object)this.versionParam.getValue());
            if (!newVersion.isGTLModeSupported(gtlVal = ((Boolean)this.gtlParam.getValue()).booleanValue())) {
                this.gtlParam.removeParameterChangeListener(this);
                this.gtlParam.setValue(!gtlVal);
                try {
                    this.gtlParam.getEditor().setEnabled(false);
                    this.gtlParam.getEditor().refreshParamEditor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.gtlParam.addParameterChangeListener(this);
            } else {
                try {
                    this.gtlParam.getEditor().setEnabled(newVersion.isGTLModeSupported(!gtlVal));
                    this.gtlParam.getEditor().refreshParamEditor();
                }
                catch (Exception exception) {}
            }
        } else if (event.getParameter() == this.gtlParam) {
            this.updateFile();
        }
        this.updateFile();
    }

    public static enum Version {
        VER_11_9_1("11.9.1 accessed 1/17/14 with UCVM 13.9.0", "11.9.1", new boolean[]{true, false}),
        VER_11_9_0("11.9.0 accessed 5/29/12 with UCVM 12.2.0", "11.9.0", new boolean[]{true});

        private String name;
        private String dirName;
        private boolean[] gtls;

        private Version(String name, String dirName, boolean[] gtls) {
            this.name = name;
            this.dirName = dirName;
            this.gtls = gtls;
        }

        public String toString() {
            return this.name;
        }

        boolean isGTLModeSupported(boolean includeGTL) {
            return Booleans.contains((boolean[])this.gtls, (boolean)includeGTL);
        }
    }
}

