/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opensha.commons.data.siteData.AbstractBinarySiteDataLoader;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.CachedSiteDataWrapper;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.XMLUtils;

public class CVM_CCAi6BasinDepth
extends AbstractBinarySiteDataLoader {
    public static final String NAME = "SCEC CCA, Iteration 6, Basin Depth";
    public static final String SHORT_NAME = "CCAi6";
    public static final double minLat = 33.35;
    public static final double minLon = -123.0;
    private static final int nx = 1551;
    private static final int ny = 1201;
    private static final long MAX_FILE_POS = 7451004L;
    public static final double gridSpacing = 0.005;
    public static final String DEPTH_2_5_FILE = "src/main/resources/data/site/CCAi6/depth_2.5.bin";
    public static final String DEPTH_1_0_FILE = "src/main/resources/data/site/CCAi6/depth_1.0.bin";
    public static final String SERVLET_2_5_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/CVM_CCAi6_2_5";
    public static final String SERVLET_1_0_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/CVM_CCAi6_1_0";

    public CVM_CCAi6BasinDepth(String type) throws IOException {
        this(type, null, true);
    }

    public CVM_CCAi6BasinDepth(String type, boolean useServlet) throws IOException {
        this(type, null, useServlet);
    }

    public CVM_CCAi6BasinDepth(String type, File dataFile) throws IOException {
        this(type, dataFile, false);
    }

    public CVM_CCAi6BasinDepth(String type, File dataFile, boolean useServlet) throws IOException {
        super(1551, 1201, 33.35, -123.0, 0.005, true, true, type, dataFile, useServlet);
    }

    @Override
    protected File getDefaultFile(String type) {
        if (type.equals("Depth to Vs = 1.0 km/sec")) {
            return new File(DEPTH_1_0_FILE);
        }
        return new File(DEPTH_2_5_FILE);
    }

    @Override
    protected String getServletURL(String type) {
        if (type.equals("Depth to Vs = 1.0 km/sec")) {
            return SERVLET_1_0_URL;
        }
        return SERVLET_2_5_URL;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getMetadata() {
        return this.getDataType() + ", extracted from version 4 of the SCEC Community Velocity Model iteration 26 (inversions by Po Chen and others). Extracted with UCVM 13.9.0 on November 26 2012 by David Gill";
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    protected Element addXMLParameters(Element paramsEl) {
        paramsEl.addAttribute("useServlet", "" + this.useServlet);
        if (this.dataFile != null) {
            paramsEl.addAttribute("fileName", this.dataFile.getPath());
        }
        paramsEl.addAttribute("type", this.getDataType());
        return super.addXMLParameters(paramsEl);
    }

    public static CVM_CCAi6BasinDepth fromXMLParams(Element paramsElem) throws IOException {
        boolean useServlet = Boolean.parseBoolean(paramsElem.attributeValue("useServlet"));
        Attribute fileAtt = paramsElem.attribute("fileName");
        File file = null;
        if (fileAtt != null) {
            file = new File(fileAtt.getStringValue());
        }
        String type = paramsElem.attributeValue("type");
        return new CVM_CCAi6BasinDepth(type, file, useServlet);
    }

    public static void main(String[] args) throws IOException {
        double d;
        CVM_CCAi6BasinDepth z1 = new CVM_CCAi6BasinDepth("Depth to Vs = 1.0 km/sec", false);
        CVM_CCAi6BasinDepth z25 = new CVM_CCAi6BasinDepth("Depth to Vs = 2.5 km/sec", false);
        ArrayList<Location> testLocs = new ArrayList<Location>();
        testLocs.add(new Location(35.8, -121.25));
        testLocs.add(new Location(35.8, -120.4));
        testLocs.add(new Location(35.8, -119.5));
        testLocs.add(new Location(35.8, -118.6));
        testLocs.add(new Location(35.5, -120.0));
        testLocs.add(new Location(35.0, -119.5));
        testLocs.add(new Location(36.0, -121.0));
        for (Location loc : testLocs) {
            System.out.println((float)loc.getLongitude() + "\t" + (float)loc.getLatitude() + "\t" + z1.getValue(loc) * 1000.0 + "\t" + z25.getValue(loc) * 1000.0);
        }
        System.exit(0);
        CVM_CCAi6BasinDepth local = new CVM_CCAi6BasinDepth("Depth to Vs = 1.0 km/sec", false);
        Location outside = new Location(35.0, -122.5);
        double outsideVal = local.getValue(outside);
        System.out.println("Val: " + outsideVal + ", valid? " + local.isValueValid(outsideVal));
        System.exit(0);
        FileWriter fw = new FileWriter(new File("/tmp/cvm_grid_locs.txt"));
        System.out.println("Expected Lat Bounds: " + local.calc.getMinLat() + "=>" + local.calc.getMaxLat());
        System.out.println("Expected Lon Bounds: " + local.calc.getMinLon() + "=>" + local.calc.getMaxLon());
        int cnt = 0;
        for (long pos = 0L; pos <= 7451004L; pos += 4L) {
            Double val = local.getValue(pos);
            ++cnt;
            long x = local.calc.calcFileX(pos);
            long y = local.calc.calcFileY(pos);
            Location loc = local.calc.getLocationForPoint(x, y);
            fw.write((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\n");
        }
        fw.close();
        System.out.println("Num above: " + cnt);
        System.exit(0);
        CVM_CCAi6BasinDepth map = new CVM_CCAi6BasinDepth("Depth to Vs = 1.0 km/sec");
        Document doc = XMLUtils.createDocumentWithRoot();
        Element root = doc.getRootElement();
        map.getAdjustableParameterList().getParameter("Minimum Basin Depth").setValue(1.0);
        Element mapEl = map.toXMLMetadata(root).element("SiteDataAPI");
        XMLUtils.writeDocumentToFile(new File("/tmp/cvm4.xml"), doc);
        map = (CVM_CCAi6BasinDepth)AbstractSiteData.fromXMLMetadata(mapEl);
        System.out.println("Min: " + String.valueOf(map.getAdjustableParameterList().getParameter("Minimum Basin Depth").getValue()));
        CachedSiteDataWrapper<Double> cache = new CachedSiteDataWrapper<Double>(map);
        LocationList locs = new LocationList();
        locs.add(new Location(34.0192, -118.288));
        locs.add(new Location(34.9192, -118.32));
        locs.add(new Location(34.78192, -118.886));
        locs.add(new Location(34.2192, -118.386));
        locs.add(new Location(34.78192, -118.886));
        locs.add(new Location(34.2192, -118.386));
        locs.add(new Location(34.78192, -118.886));
        locs.add(new Location(34.2192, -118.386));
        locs.add(new Location(34.792, -118.8));
        locs.add(new Location(34.292, -118.386));
        locs.add(new Location(34.6192, -118.186));
        locs.add(new Location(34.792, -118.8));
        locs.add(new Location(34.292, -118.386));
        locs.add(new Location(34.792, -118.8));
        locs.add(new Location(34.292, -118.386));
        locs.add(new Location(34.792, -118.8));
        locs.add(new Location(34.292, -118.386));
        map.getValues(locs);
        long time = System.currentTimeMillis();
        for (Location loc : locs) {
            double d2 = map.getValue(loc);
        }
        double secs = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.println("Raw time: " + secs + "s");
        time = System.currentTimeMillis();
        for (Location loc : locs) {
            d = cache.getValue(loc);
        }
        secs = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.println("Cache time: " + secs + "s");
        time = System.currentTimeMillis();
        for (Location loc : locs) {
            d = map.getValue(loc);
        }
        secs = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.println("Raw time: " + secs + "s");
        time = System.currentTimeMillis();
        for (Location loc : locs) {
            d = cache.getValue(loc);
        }
        secs = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.println("Cache time: " + secs + "s");
    }
}

