/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EnumSet;
import org.opensha.commons.data.siteData.AbstractBinarySiteDataLoader;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.ServerPrefUtils;

public class CVM_Vs30
extends AbstractBinarySiteDataLoader
implements ParameterChangeListener {
    public static final String NAME = "Vs30 from various Community Velocity Models";
    public static final String SHORT_NAME = "CVMVs30";
    public static final double minLat = 31.0;
    public static final double minLon = -121.0;
    private static final int nx = 1701;
    private static final int ny = 1101;
    private static final double grid_spacing = 0.005;
    public static final String DEFAULT_RESOURCE_DIR = "src" + s + "main" + s + "resources" + s + "data" + s + "site" + s;
    public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/CVM_Vs30";
    private File dataDir;
    public static final String CVM_PARAM_NAME = "CVM";
    private EnumParameter<CVM> cvmParam;
    public static final CVM CVM_DEFAULT = CVM.CVMS4i26;

    public CVM_Vs30(CVM cvm) throws IOException {
        this(null, cvm, true);
    }

    public CVM_Vs30(CVM cvm, boolean useServlet) throws IOException {
        this(new File(DEFAULT_RESOURCE_DIR), cvm, useServlet);
    }

    public CVM_Vs30(File dataDir, CVM cvm, boolean useServlet) throws IOException {
        super(1701, 1101, 31.0, -121.0, 0.005, true, true, "Vs30", CVM_Vs30.getDataFile(dataDir, cvm), useServlet);
        this.dataDir = dataDir;
        this.cvmParam = new EnumParameter<CVM>(CVM_PARAM_NAME, EnumSet.allOf(CVM.class), cvm, null);
        this.cvmParam.addParameterChangeListener(this);
        this.paramList.addParameter(this.cvmParam);
        this.serverParamsList.addParameter(this.cvmParam);
        this.updateFile();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public String getMetadata() {
        return this.getDataType() + ", Vs30 from various CVM models extracted with UCVM by David Gill";
    }

    @Override
    protected File getDefaultFile(String type) {
        return CVM_Vs30.getDataFile(this.dataDir, CVM_DEFAULT);
    }

    private void updateFile() {
        if (this.useServlet) {
            return;
        }
        String type = this.getDataType();
        File dataFile = CVM_Vs30.getDataFile(this.dataDir, (CVM)((Object)this.cvmParam.getValue()));
        try {
            this.setDataFile(dataFile);
        }
        catch (FileNotFoundException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
    }

    private static File getDataFile(File dataDir, CVM version) {
        if (dataDir == null) {
            return null;
        }
        Preconditions.checkState((boolean)dataDir.exists(), (Object)("CVM Data Dir Not Found: " + dataDir.getAbsolutePath()));
        Preconditions.checkState((version.resourcePath.length > 0 ? 1 : 0) != 0);
        File dataFile = dataDir;
        for (String pathElement : version.resourcePath) {
            dataFile = new File(dataFile, pathElement);
        }
        Preconditions.checkState((boolean)dataFile.exists(), (Object)("CVM Data File Not Found: " + dataFile.getAbsolutePath()));
        return dataFile;
    }

    @Override
    protected String getServletURL(String type) {
        return SERVLET_URL;
    }

    public static void main(String[] args) throws IOException {
        CVM_Vs30 cvmh = new CVM_Vs30(CVM.CVMS4i26, false);
        System.out.println(cvmh.getApplicableRegion());
        FileWriter fw = new FileWriter(new File("/tmp/cvmh_grid_locs.txt"));
        for (long pos = 0L; pos <= cvmh.maxFilePos; pos += 4L) {
            Double val = cvmh.getValue(pos);
            long x = cvmh.calc.calcFileX(pos);
            long y = cvmh.calc.calcFileY(pos);
            Location loc = cvmh.calc.getLocationForPoint(x, y);
            fw.write((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + val.floatValue() + "\n");
        }
        fw.close();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.cvmParam) {
            this.updateFile();
        }
    }

    public static enum CVM {
        CVMS4i26("SCEC Community Velocity Model Version 4, Iteration 26, Vs30", "CVM4i26", "vs30.bin");

        private String name;
        private String[] resourcePath;

        private CVM(String name, String ... resourcePath) {
            this.name = name;
            this.resourcePath = resourcePath;
        }

        public String toString() {
            return this.name;
        }
    }
}

