/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.IOException;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;

public class ConstantValueDataProvider<Element>
extends AbstractSiteData<Element> {
    private String dataType;
    private String dataMeasurmentType;
    private Element value;
    private String name;
    private String shortName;

    public ConstantValueDataProvider(String dataType, String dataMeasurmentType, Element value) {
        this(dataType, dataMeasurmentType, value, "Constant Value Provider", "ConstVal");
    }

    public ConstantValueDataProvider(String dataType, String dataMeasurmentType, Element value, String name, String shortName) {
        this.dataType = dataType;
        this.dataMeasurmentType = dataMeasurmentType;
        this.value = value;
        this.name = name;
        this.shortName = shortName;
    }

    @Override
    public Region getApplicableRegion() {
        return Region.getGlobalRegion();
    }

    @Override
    public double getResolution() {
        return 0.0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public String getDataMeasurementType() {
        return this.dataMeasurmentType;
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        return loc;
    }

    @Override
    public Element getValue(Location loc) throws IOException {
        return this.value;
    }

    @Override
    public boolean isValueValid(Element el) {
        return this.value.equals(el);
    }

    @Override
    public String getMetadata() {
        return "Constant valued provider. Value: " + String.valueOf(this.value);
    }
}

