/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.FileUtils;

public class ShakeMapStableTectonicPolygons
extends AbstractSiteData<Boolean> {
    public static final String NAME = "ShakeMap Stable Continent Regions";
    public static final String SHORT_NAME = "ShakeMapContinentRegions";
    public static final String CRATON_FILENAME = "src/main/resources/data/site/ShakeMapTectonicPolygons/craton.txt";
    ArrayList<Region> polys;
    Region region = Region.getGlobalRegion();

    public ShakeMapStableTectonicPolygons() throws IOException {
        this.polys = ShakeMapStableTectonicPolygons.loadPolygons(CRATON_FILENAME);
    }

    public static ArrayList<Region> loadPolygons(String fileName) throws FileNotFoundException, IOException {
        ArrayList<Region> polys = new ArrayList<Region>();
        ArrayList<String> lines = FileUtils.loadFile(fileName);
        boolean inside = false;
        LocationList locs = null;
        for (String line : lines) {
            if (line.length() == 0 || line.startsWith("#")) continue;
            if (inside) {
                StringTokenizer tok = new StringTokenizer(line);
                int tokens = tok.countTokens();
                if (tokens < 2 || tokens > 3) {
                    throw new RuntimeException("Invalid line found: " + line);
                }
                double lat = Double.parseDouble(tok.nextToken());
                double lon = Double.parseDouble(tok.nextToken());
                Location loc = new Location(lat, lon);
                locs.add(loc);
                if (tokens != 2) continue;
                polys.add(new Region(locs, BorderType.MERCATOR_LINEAR));
                inside = false;
                continue;
            }
            if (!line.startsWith("box")) continue;
            locs = new LocationList();
            inside = true;
        }
        return polys;
    }

    @Override
    public Region getApplicableRegion() {
        return this.region;
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        return loc;
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public String getDataType() {
        return "Tectonic Region Type";
    }

    @Override
    public String getMetadata() {
        return "Metadata";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double getResolution() {
        return 0.0;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public Boolean getValue(Location loc) throws IOException {
        for (Region region : this.polys) {
            if (!region.contains(loc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValueValid(Boolean el) {
        return true;
    }

    public static void main(String[] args) throws IOException {
        ShakeMapStableTectonicPolygons stable = new ShakeMapStableTectonicPolygons();
        System.out.println(stable.getValue(new Location(34.0, -118.0)));
        System.out.println(stable.getValue(new Location(34.0, -80.0)));
    }
}

