/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.dom4j.Element;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.binFile.BinaryMesh2DCalculator;
import org.opensha.commons.util.binFile.GeolocatedRectangularBinaryMesh2DCalculator;

public class WillsMap2015
extends AbstractSiteData<Double> {
    public static final int nx = 41104;
    public static final int ny = 37900;
    public static final double spacing = 2.5E-4;
    public static final double startLon = -124.406528862058;
    public static final double startLat = 42.0090923024621;
    public static final boolean startBottom = false;
    public static final boolean startLeft = true;
    public static final String NAME = "CGS/Wills VS30 Map (2015)";
    public static final String SHORT_NAME = "Wills2015";
    public static final String SERVER_BIN_FILE = ServerPrefUtils.SERVER_PREFS.getDataDir().getAbsolutePath() + File.separator + "siteData" + File.separator + "wills_2015" + File.separator + "raster_0.00025.flt";
    public static final String DEBUG_BIN_FILE = "/home/kevin/OpenSHA/siteClass/out.bin";
    public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/Wills2015";
    private Region applicableRegion;
    private RandomAccessFile file = null;
    private String fileName = null;
    private byte[] recordBuffer = null;
    private FloatBuffer floatBuff = null;
    private GeolocatedRectangularBinaryMesh2DCalculator calc = null;
    private boolean useServlet;
    private SiteDataServletAccessor<Double> servlet = null;

    public WillsMap2015() throws IOException {
        this(true, null);
    }

    public WillsMap2015(String dataFile) throws IOException {
        this(false, dataFile);
    }

    private WillsMap2015(boolean useServlet, String dataFile) throws IOException {
        this(useServlet, dataFile, new GeolocatedRectangularBinaryMesh2DCalculator(BinaryMesh2DCalculator.DataType.FLOAT, 41104, 37900, 42.0090923024621, -124.406528862058, false, true, 2.5E-4));
    }

    public WillsMap2015(String dataFile, GeolocatedRectangularBinaryMesh2DCalculator calc) throws IOException {
        this(false, dataFile, calc);
    }

    private WillsMap2015(boolean useServlet, String dataFile, GeolocatedRectangularBinaryMesh2DCalculator calc) throws IOException {
        this.useServlet = useServlet;
        this.fileName = dataFile;
        this.calc = calc;
        this.applicableRegion = calc.getApplicableRegion();
        if (useServlet) {
            this.servlet = new SiteDataServletAccessor<Double>(this, SERVLET_URL);
        } else {
            this.file = new RandomAccessFile(new File(dataFile), "r");
            this.recordBuffer = new byte[4];
            Preconditions.checkState((calc.getMaxFilePos() + (long)this.recordBuffer.length == this.file.length() ? 1 : 0) != 0, (String)"Mesh calculator and file inconsistent: calc.getMaxFilePos()=%s, file.length()=%s", (long)calc.getMaxFilePos(), (long)this.file.length());
            ByteBuffer record = ByteBuffer.wrap(this.recordBuffer);
            record.order(ByteOrder.LITTLE_ENDIAN);
            this.floatBuff = record.asFloatBuffer();
        }
        this.initDefaultVS30Params();
        this.paramList.addParameter(this.minVs30Param);
        this.paramList.addParameter(this.maxVs30Param);
    }

    @Override
    public Region getApplicableRegion() {
        return this.applicableRegion;
    }

    @Override
    public Location getClosestDataLocation(Location loc) {
        return this.calc.calcClosestLocation(loc);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getMetadata() {
        return "Vs30 values as described in:\n\nA Next Generation VS30 Map for California Based on Geology and Topography\nby C. J. Wills, C. I. Gutierrez, F. G. Perez, and D. M. Branum\nBulletin of the Seismological Society of America; December 2015; v. 105; no. 6; p. 3083-3091\n\nThe dataset contains Vs obtained from the electronic supplements, specifically 'VsMapV3_20150714_shapefile.zip', fetched 2/23/17.\n\nData reprojected from EPSG:3310 to EPSG:4326 with QGIS, then rasterized with the 'gdal_rasterize' linux command, GDAL 1.10.0. It has a grid spacing of 2.5E-4 degrees";
    }

    @Override
    public double getResolution() {
        return 2.5E-4;
    }

    @Override
    public String getDataType() {
        return "Vs30";
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        if (this.useServlet) {
            return this.certifyMinMaxVs30(this.servlet.getValue(loc));
        }
        long pos = this.calc.calcClosestLocationFileIndex(loc);
        if (pos < 0L || pos > this.calc.getMaxFilePos()) {
            return Double.NaN;
        }
        this.file.seek(pos);
        this.file.read(this.recordBuffer);
        double val = this.floatBuff.get(0);
        if ((float)val <= 0.0f || Double.isNaN(val)) {
            return Double.NaN;
        }
        Preconditions.checkState((Double.isNaN(val) || val > 0.0 ? 1 : 0) != 0, (String)"Bad value! %s", (Object)val);
        double roundVal = (double)Math.round(val * 100.0) / 100.0;
        Preconditions.checkState((Double.isNaN(roundVal) || roundVal > 0.0 ? 1 : 0) != 0, (String)"Bad rounded value: %s (orig: %s)", (Object)roundVal, (Object)val);
        double boundsVal = this.certifyMinMaxVs30(roundVal);
        Preconditions.checkState((Double.isNaN(boundsVal) || boundsVal > 0.0 ? 1 : 0) != 0, (String)"Bad bounds val! %s (rounded: %s, orig %s)", (Object)boundsVal, (Object)roundVal, (Object)val);
        return roundVal;
    }

    @Override
    public ArrayList<Double> getValues(LocationList locs) throws IOException {
        if (this.useServlet) {
            ArrayList<Double> vals = this.servlet.getValues(locs);
            for (int i = 0; i < vals.size(); ++i) {
                vals.set(i, this.certifyMinMaxVs30(vals.get(i)));
            }
            return vals;
        }
        return super.getValues(locs);
    }

    @Override
    public boolean isValueValid(Double val) {
        return val != null && !Double.isNaN(val);
    }

    @Override
    protected Element addXMLParameters(Element paramsEl) {
        paramsEl.addAttribute("useServlet", "" + this.useServlet);
        paramsEl.addAttribute("fileName", this.fileName);
        return super.addXMLParameters(paramsEl);
    }

    public static WillsMap2015 fromXMLParams(Element paramsElem) throws IOException {
        boolean useServlet = Boolean.parseBoolean(paramsElem.attributeValue("useServlet"));
        String fileName = paramsElem.attributeValue("fileName");
        return new WillsMap2015(useServlet, fileName);
    }

    public static void main(String[] args) throws IOException {
        WillsMap2015 map = new WillsMap2015();
        GriddedRegion region = new GriddedRegion(new Location(37.0, -122.75), new Location(38.5, -121.5), 0.01, new Location(0.0, 0.0));
        LocationList locs = new LocationList();
        locs.add(new Location(34.0192, -118.288));
        locs.add(new Location(34.9192, -118.32));
        locs.add(new Location(34.78192, -118.886));
        locs.add(new Location(34.2192, -118.386));
        locs.add(new Location(34.6192, -118.186));
        ArrayList<Double> vals = map.getValues(locs);
        for (double val : vals) {
            System.out.println(val);
        }
    }
}

