/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.uncertainty;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.UnmodifiableDiscrFunc;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.UncertainBoundedDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;

@JsonAdapter(value=Adapter.class)
public class UncertainArbDiscFunc
extends UnmodifiableDiscrFunc
implements UncertainBoundedDiscretizedFunc {
    private static final long serialVersionUID = 1L;
    private UnmodifiableDiscrFunc lowerFunc;
    private UnmodifiableDiscrFunc upperFunc;
    private UncertaintyBoundType boundType;
    private UnmodifiableDiscrFunc stdDevs;
    private String boundName;

    public static UncertainArbDiscFunc forStdDev(DiscretizedFunc meanFunc, double stdDev, UncertaintyBoundType boundType, boolean allowNegative) {
        Preconditions.checkState((stdDev >= 0.0 ? 1 : 0) != 0);
        ArbitrarilyDiscretizedFunc upperFunc = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc lowerFunc = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc stdDevsFunc = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < meanFunc.size(); ++i) {
            double x = meanFunc.getX(i);
            double y = meanFunc.getY(i);
            BoundedUncertainty bounds = boundType.estimate(y, stdDev);
            if (!allowNegative && bounds.lowerBound < 0.0) {
                bounds = new BoundedUncertainty(boundType, 0.0, bounds.upperBound, stdDev);
            }
            upperFunc.set(x, bounds.upperBound);
            lowerFunc.set(x, bounds.lowerBound);
            stdDevsFunc.set(x, stdDev);
        }
        return new UncertainArbDiscFunc(meanFunc, lowerFunc, upperFunc, boundType, stdDevsFunc);
    }

    private UncertainArbDiscFunc() {
        super(new ArbitrarilyDiscretizedFunc());
    }

    public UncertainArbDiscFunc(DiscretizedFunc meanFunc, DiscretizedFunc lowerFunc, DiscretizedFunc upperFunc) {
        this(meanFunc, lowerFunc, upperFunc, null);
    }

    public UncertainArbDiscFunc(DiscretizedFunc meanFunc, DiscretizedFunc lowerFunc, DiscretizedFunc upperFunc, UncertaintyBoundType boundType) {
        this(meanFunc, lowerFunc, upperFunc, boundType, null);
    }

    public UncertainArbDiscFunc(DiscretizedFunc meanFunc, DiscretizedFunc lowerFunc, DiscretizedFunc upperFunc, UncertaintyBoundType boundType, DiscretizedFunc stdDevs) {
        super(meanFunc);
        this.lowerFunc = new UnmodifiableDiscrFunc(lowerFunc);
        this.upperFunc = new UnmodifiableDiscrFunc(upperFunc);
        this.boundType = boundType;
        this.stdDevs = stdDevs == null ? null : new UnmodifiableDiscrFunc(stdDevs);
        Preconditions.checkArgument((meanFunc.size() == lowerFunc.size() ? 1 : 0) != 0, (Object)"Lower func not same length as mean");
        Preconditions.checkArgument((meanFunc.size() == upperFunc.size() ? 1 : 0) != 0, (Object)"Upper func not same length as mean");
        for (int i = 0; i < this.size(); ++i) {
            double x = meanFunc.getX(i);
            double y = meanFunc.getY(i);
            double lowerY = lowerFunc.getY(i);
            double upperY = upperFunc.getY(i);
            Preconditions.checkArgument(((float)x == (float)lowerFunc.getX(i) ? 1 : 0) != 0, (Object)"X inconsistent in lower func");
            Preconditions.checkArgument(((float)x == (float)upperFunc.getX(i) ? 1 : 0) != 0, (Object)"X inconsistent in lower func");
            if (Double.isNaN(y) || Double.isNaN(lowerY) || Double.isNaN(upperY)) continue;
            Preconditions.checkArgument(((float)y >= (float)lowerY ? 1 : 0) != 0, (String)"Lower func must be <= mean func: %s ! <= %s, x=%s", (Object)lowerY, (Object)y, (Object)x);
            Preconditions.checkArgument(((float)y <= (float)upperY ? 1 : 0) != 0, (String)"Upper func must be >= mean func: %s ! >= %s, x=%s", (Object)upperY, (Object)y, (Object)x);
        }
    }

    @Override
    public DiscretizedFunc getLower() {
        return this.lowerFunc;
    }

    @Override
    public DiscretizedFunc getUpper() {
        return this.upperFunc;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Name: " + this.getName() + "\n");
        b.append("Num Points: " + this.size() + "\n");
        b.append("Info: " + this.getInfo() + "\n\n");
        b.append("X, Y Data:\n");
        b.append(this.getMetadataString() + "\n");
        return b.toString();
    }

    @Override
    public String getMetadataString() {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            double x = this.getX(i);
            double mean = this.getY(i);
            double lower = this.getLowerY(i);
            double upper = this.getUpperY(i);
            b.append((float)x + "\t" + (float)mean + "\t[" + (float)lower + "\t" + (float)upper + "]\n");
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnmodifiableDiscrFunc getStdDevs() {
        if (this.stdDevs == null) {
            if (this.boundType == null) {
                return null;
            }
            UncertainArbDiscFunc uncertainArbDiscFunc = this;
            synchronized (uncertainArbDiscFunc) {
                if (this.stdDevs == null) {
                    ArbitrarilyDiscretizedFunc stdDevs = new ArbitrarilyDiscretizedFunc();
                    for (int i = 0; i < this.size(); ++i) {
                        stdDevs.set(this.getX(i), this.boundType.estimateStdDev(this.getLowerY(i), this.getUpperY(i)));
                    }
                    this.stdDevs = new UnmodifiableDiscrFunc(stdDevs);
                }
            }
        }
        return this.stdDevs;
    }

    @Override
    public UncertainBoundedDiscretizedFunc estimateBounds(UncertaintyBoundType boundType) {
        ArbitrarilyDiscretizedFunc lowerFunc = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc upperFunc = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < this.size(); ++i) {
            double stdDev = this.getStdDev(i);
            double mean = this.getY(i);
            BoundedUncertainty bounds = boundType.estimate(mean, stdDev);
            double x = this.getX(i);
            lowerFunc.set(x, bounds.lowerBound);
            upperFunc.set(x, bounds.upperBound);
        }
        return new UncertainArbDiscFunc(this, lowerFunc, upperFunc, boundType, this.stdDevs);
    }

    @Override
    public UncertaintyBoundType getBoundType() {
        return this.boundType;
    }

    @Override
    public String getBoundName() {
        if (this.boundName == null) {
            return this.getDefaultBoundName();
        }
        return this.boundName;
    }

    @Override
    public void setBoundName(String boundName) {
        this.boundName = boundName;
    }

    @Override
    public UncertainArbDiscFunc deepClone() {
        UncertainArbDiscFunc ret = this.stdDevs == null ? new UncertainArbDiscFunc(this.func, this.lowerFunc.deepClone(), this.upperFunc.deepClone(), this.boundType) : new UncertainArbDiscFunc(this.func, this.lowerFunc.deepClone(), this.upperFunc.deepClone(), this.boundType, this.stdDevs.deepClone());
        ret.boundName = this.boundName;
        return ret;
    }

    public static void main(String[] args) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ArbitrarilyDiscretizedFunc meanFunc = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc upperFunc = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc lowerFunc = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < 10; ++i) {
            double x = Math.random();
            double lowY = Math.random();
            double highY = lowY + Math.random();
            double mean = 0.5 * (lowY + highY);
            meanFunc.set(x, mean);
            upperFunc.set(x, highY);
            lowerFunc.set(x, lowY);
        }
        UncertainArbDiscFunc uncertain = new UncertainArbDiscFunc(meanFunc, lowerFunc, upperFunc);
        System.out.println("Original function:\n" + String.valueOf(uncertain));
        File outFile = new File("/tmp/json_func_test.json");
        FileWriter fw = new FileWriter(outFile);
        gson.toJson((Object)uncertain, (Appendable)fw);
        fw.close();
        FileReader fr = new FileReader(outFile);
        uncertain = (UncertainArbDiscFunc)gson.fromJson((Reader)fr, UncertainArbDiscFunc.class);
        System.out.println("Deserialized function:\n" + String.valueOf(uncertain));
    }

    public static class Adapter
    extends DiscretizedFunc.AbstractAdapter<UncertainArbDiscFunc> {
        DiscretizedFunc.Adapter funcAdapter = new DiscretizedFunc.Adapter();

        @Override
        protected UncertainArbDiscFunc instance(Double minX, Double maxX, Integer size) {
            return new UncertainArbDiscFunc(){

                @Override
                public void set(double x, double y) {
                    this.func.set(x, y);
                }
            };
        }

        @Override
        protected void serializeExtras(JsonWriter out, UncertainArbDiscFunc xy) throws IOException {
            super.serializeExtras(out, xy);
            out.name("lowerBounds");
            Adapter.writeDoubleArray(out, xy.lowerFunc);
            out.name("upperBounds");
            Adapter.writeDoubleArray(out, xy.upperFunc);
            if (xy.boundType != null) {
                out.name("boundType").value(xy.boundType.name());
            }
            if (xy.boundName != null) {
                out.name("boundName").value(xy.boundName);
            }
            if (xy.stdDevs != null) {
                out.name("stdDevs");
                Adapter.writeDoubleArray(out, xy.stdDevs);
            }
        }

        private static void writeDoubleArray(JsonWriter out, DiscretizedFunc func) throws IOException {
            out.beginArray();
            for (Point2D pt : func) {
                out.value(pt.getY());
            }
            out.endArray();
        }

        private static List<Double> readDoubleArray(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<Double> ret = new ArrayList<Double>();
            while (in.hasNext()) {
                ret.add(in.nextDouble());
            }
            in.endArray();
            return ret;
        }

        private static DiscretizedFunc buildFunc(DiscretizedFunc xVals, List<Double> yVals) {
            Preconditions.checkState((xVals.size() == yVals.size() ? 1 : 0) != 0);
            ArbitrarilyDiscretizedFunc ret = new ArbitrarilyDiscretizedFunc();
            for (int i = 0; i < yVals.size(); ++i) {
                ret.set(xVals.getX(i), (double)yVals.get(i));
            }
            return ret;
        }

        @Override
        protected Consumer<UncertainArbDiscFunc> deserializeExtra(JsonReader in, String name) throws IOException {
            if (name.equals("stdDevs")) {
                if (in.peek() == JsonToken.NULL) {
                    return null;
                }
                if (in.peek() == JsonToken.BEGIN_OBJECT) {
                    final DiscretizedFunc stdDevs = (DiscretizedFunc)this.funcAdapter.read(in);
                    return new Consumer<UncertainArbDiscFunc>(){
                        final /* synthetic */ Adapter this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void accept(UncertainArbDiscFunc t) {
                            t.stdDevs = new UnmodifiableDiscrFunc(stdDevs);
                        }
                    };
                }
                final List<Double> stdDevs = Adapter.readDoubleArray(in);
                return new Consumer<UncertainArbDiscFunc>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainArbDiscFunc t) {
                        t.stdDevs = new UnmodifiableDiscrFunc(Adapter.buildFunc(t, stdDevs));
                    }
                };
            }
            if (name.equals("lowerFunc")) {
                final DiscretizedFunc lowerFunc = (DiscretizedFunc)this.funcAdapter.read(in);
                return new Consumer<UncertainArbDiscFunc>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainArbDiscFunc t) {
                        t.lowerFunc = new UnmodifiableDiscrFunc(lowerFunc);
                    }
                };
            }
            if (name.equals("upperFunc")) {
                final DiscretizedFunc upperFunc = (DiscretizedFunc)this.funcAdapter.read(in);
                return new Consumer<UncertainArbDiscFunc>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainArbDiscFunc t) {
                        t.upperFunc = new UnmodifiableDiscrFunc(upperFunc);
                    }
                };
            }
            if (name.equals("lowerBounds")) {
                final List<Double> lowers = Adapter.readDoubleArray(in);
                return new Consumer<UncertainArbDiscFunc>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainArbDiscFunc t) {
                        t.lowerFunc = new UnmodifiableDiscrFunc(Adapter.buildFunc(t, lowers));
                    }
                };
            }
            if (name.equals("upperBounds")) {
                final List<Double> uppers = Adapter.readDoubleArray(in);
                return new Consumer<UncertainArbDiscFunc>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainArbDiscFunc t) {
                        t.upperFunc = new UnmodifiableDiscrFunc(Adapter.buildFunc(t, uppers));
                    }
                };
            }
            if (name.equals("boundType")) {
                if (in.peek() == JsonToken.NULL) {
                    return null;
                }
                final UncertaintyBoundType boundType = UncertaintyBoundType.valueOf(in.nextString());
                return new Consumer<UncertainArbDiscFunc>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainArbDiscFunc t) {
                        t.boundType = boundType;
                    }
                };
            }
            if (name.equals("boundName")) {
                if (in.peek() == JsonToken.NULL) {
                    return null;
                }
                final String boundName = in.nextString();
                return new Consumer<UncertainArbDiscFunc>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainArbDiscFunc t) {
                        t.boundName = boundName;
                    }
                };
            }
            return super.deserializeExtra(in, name);
        }

        @Override
        protected Class<UncertainArbDiscFunc> getType() {
            return UncertainArbDiscFunc.class;
        }
    }
}

