/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.uncertainty;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

@JsonAdapter(value=Adapter.class)
public class UncertainBoundedIncrMagFreqDist
extends UncertainIncrMagFreqDist
implements UncertainBoundedDiscretizedFunc {
    private IncrementalMagFreqDist lowerBound;
    private IncrementalMagFreqDist upperBound;
    private UncertaintyBoundType boundType;
    private String boundName;

    private UncertainBoundedIncrMagFreqDist(double minX, double maxX, int size) {
        super(new IncrementalMagFreqDist(minX, maxX, size), null);
    }

    public UncertainBoundedIncrMagFreqDist(IncrementalMagFreqDist mfd, IncrementalMagFreqDist lowerBound, IncrementalMagFreqDist upperBound, UncertaintyBoundType boundType) throws InvalidRangeException {
        this(mfd, lowerBound, upperBound, boundType, null);
    }

    public UncertainBoundedIncrMagFreqDist(IncrementalMagFreqDist mfd, IncrementalMagFreqDist lowerBound, IncrementalMagFreqDist upperBound, UncertaintyBoundType boundType, EvenlyDiscretizedFunc stdDevs) throws InvalidRangeException {
        super(mfd, stdDevs);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.boundType = boundType;
        Preconditions.checkArgument((mfd.size() == lowerBound.size() ? 1 : 0) != 0, (Object)"Lower func not same length as mean");
        Preconditions.checkArgument((mfd.size() == upperBound.size() ? 1 : 0) != 0, (Object)"Upper func not same length as mean");
        for (int i = 0; i < this.size(); ++i) {
            double x = mfd.getX(i);
            double y = mfd.getY(i);
            double lowerY = lowerBound.getY(i);
            double upperY = upperBound.getY(i);
            Preconditions.checkArgument(((float)x == (float)lowerBound.getX(i) ? 1 : 0) != 0, (Object)"X inconsistent in lower func");
            Preconditions.checkArgument(((float)x == (float)upperBound.getX(i) ? 1 : 0) != 0, (Object)"X inconsistent in lower func");
            if (Double.isNaN(y) || Double.isNaN(lowerY) || Double.isNaN(upperY)) continue;
            Preconditions.checkArgument(((float)y >= (float)lowerY ? 1 : 0) != 0, (String)"Lower func must be <= mean func: %s ! <= %s, x=%s", (Object)lowerY, (Object)y, (Object)x);
            Preconditions.checkArgument(((float)y <= (float)upperY ? 1 : 0) != 0, (String)"Upper func must be >= mean func: %s ! >= %s, x=%s", (Object)upperY, (Object)y, (Object)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvenlyDiscretizedFunc getStdDevs() {
        if (this.stdDevs == null) {
            if (this.boundType == null) {
                return null;
            }
            Preconditions.checkState((this.boundType != null ? 1 : 0) != 0, (Object)"Standard deviations not supplied and can't estimate as bound type not specified");
            UncertainBoundedIncrMagFreqDist uncertainBoundedIncrMagFreqDist = this;
            synchronized (uncertainBoundedIncrMagFreqDist) {
                if (this.stdDevs == null) {
                    EvenlyDiscretizedFunc stdDevs = new EvenlyDiscretizedFunc(this.getMinX(), this.getMaxX(), this.size());
                    for (int i = 0; i < this.size(); ++i) {
                        stdDevs.set(i, this.boundType.estimateStdDev(this.getLowerY(i), this.getUpperY(i)));
                    }
                    this.stdDevs = stdDevs;
                }
            }
        }
        return this.stdDevs;
    }

    @Override
    public UncertaintyBoundType getBoundType() {
        return this.boundType;
    }

    @Override
    public String getBoundName() {
        if (this.boundName == null) {
            return this.getDefaultBoundName();
        }
        return this.boundName;
    }

    @Override
    public void setBoundName(String boundsName) {
        this.boundName = boundsName;
    }

    @Override
    public IncrementalMagFreqDist getLower() {
        return this.lowerBound;
    }

    @Override
    public IncrementalMagFreqDist getUpper() {
        return this.upperBound;
    }

    @Override
    public UncertainBoundedIncrMagFreqDist deepClone() {
        UncertainBoundedIncrMagFreqDist ret = this.stdDevs == null ? new UncertainBoundedIncrMagFreqDist(this, this.lowerBound.deepClone(), this.upperBound.deepClone(), this.boundType) : new UncertainBoundedIncrMagFreqDist(this, this.lowerBound.deepClone(), this.upperBound.deepClone(), this.boundType, this.stdDevs.deepClone());
        ret.boundName = this.boundName;
        return ret;
    }

    @Override
    public void scale(double val) {
        super.scale(val);
        this.lowerBound.scale(val);
        this.upperBound.scale(val);
    }

    public static class Adapter
    extends IncrementalMagFreqDist.GenericAdapter<UncertainBoundedIncrMagFreqDist> {
        EvenlyDiscretizedFunc.Adapter funcAdapter = new EvenlyDiscretizedFunc.Adapter();
        IncrementalMagFreqDist.Adapter mfdAdapter = new IncrementalMagFreqDist.Adapter();

        @Override
        protected UncertainBoundedIncrMagFreqDist instance(Double minX, Double maxX, Integer size) {
            Preconditions.checkNotNull((Object)minX, (Object)"minX must be supplied before values to deserialize EvenlyDiscretizedFunc");
            Preconditions.checkNotNull((Object)maxX, (Object)"maxX must be supplied before values to deserialize EvenlyDiscretizedFunc");
            Preconditions.checkNotNull((Object)size, (Object)"size must be supplied before values to deserialize EvenlyDiscretizedFunc");
            return new UncertainBoundedIncrMagFreqDist((double)minX, maxX, size);
        }

        @Override
        protected void serializeExtras(JsonWriter out, UncertainBoundedIncrMagFreqDist xy) throws IOException {
            super.serializeExtras(out, xy);
            if (xy.stdDevs != null) {
                out.name("stdDevs");
                Adapter.writeDoubleArray(out, xy.stdDevs);
            }
            out.name("lowerBounds");
            Adapter.writeDoubleArray(out, xy.lowerBound);
            out.name("upperBounds");
            Adapter.writeDoubleArray(out, xy.upperBound);
            if (xy.boundType != null) {
                out.name("boundType").value(xy.boundType.name());
            }
            if (xy.boundName != null) {
                out.name("boundName").value(xy.boundName);
            }
        }

        static void writeDoubleArray(JsonWriter out, DiscretizedFunc func) throws IOException {
            out.beginArray();
            for (Point2D pt : func) {
                out.value(pt.getY());
            }
            out.endArray();
        }

        static List<Double> readDoubleArray(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<Double> ret = new ArrayList<Double>();
            while (in.hasNext()) {
                ret.add(in.nextDouble());
            }
            in.endArray();
            return ret;
        }

        private static IncrementalMagFreqDist buildIncrFunc(IncrementalMagFreqDist xVals, List<Double> yVals) {
            Preconditions.checkState((xVals.size() == yVals.size() ? 1 : 0) != 0);
            IncrementalMagFreqDist ret = new IncrementalMagFreqDist(xVals.getMinX(), xVals.size(), xVals.getDelta());
            for (int i = 0; i < yVals.size(); ++i) {
                ret.set(i, (double)yVals.get(i));
            }
            return ret;
        }

        private static EvenlyDiscretizedFunc buildFunc(EvenlyDiscretizedFunc xVals, List<Double> yVals) {
            Preconditions.checkState((xVals.size() == yVals.size() ? 1 : 0) != 0);
            EvenlyDiscretizedFunc ret = new EvenlyDiscretizedFunc(xVals.getMinX(), xVals.size(), xVals.getDelta());
            for (int i = 0; i < yVals.size(); ++i) {
                ret.set(i, (double)yVals.get(i));
            }
            return ret;
        }

        @Override
        protected Consumer<UncertainBoundedIncrMagFreqDist> deserializeExtra(JsonReader in, String name) throws IOException {
            if (name.equals("stdDevs")) {
                if (in.peek() == JsonToken.NULL) {
                    return null;
                }
                if (in.peek() == JsonToken.BEGIN_OBJECT) {
                    final EvenlyDiscretizedFunc stdDevs = (EvenlyDiscretizedFunc)this.funcAdapter.read(in);
                    return new Consumer<UncertainBoundedIncrMagFreqDist>(){
                        final /* synthetic */ Adapter this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void accept(UncertainBoundedIncrMagFreqDist t) {
                            Preconditions.checkState((t.size() == stdDevs.size() ? 1 : 0) != 0);
                            t.stdDevs = stdDevs;
                        }
                    };
                }
                final List<Double> stdDevs = Adapter.readDoubleArray(in);
                return new Consumer<UncertainBoundedIncrMagFreqDist>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainBoundedIncrMagFreqDist t) {
                        t.stdDevs = Adapter.buildFunc(t, stdDevs);
                    }
                };
            }
            if (name.equals("lowerFunc")) {
                final IncrementalMagFreqDist lowerFunc = (IncrementalMagFreqDist)this.mfdAdapter.read(in);
                return new Consumer<UncertainBoundedIncrMagFreqDist>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainBoundedIncrMagFreqDist t) {
                        Preconditions.checkState((t.size() == lowerFunc.size() ? 1 : 0) != 0);
                        t.lowerBound = lowerFunc;
                    }
                };
            }
            if (name.equals("upperFunc")) {
                final IncrementalMagFreqDist upperFunc = (IncrementalMagFreqDist)this.mfdAdapter.read(in);
                return new Consumer<UncertainBoundedIncrMagFreqDist>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainBoundedIncrMagFreqDist t) {
                        Preconditions.checkState((t.size() == upperFunc.size() ? 1 : 0) != 0);
                        t.upperBound = upperFunc;
                    }
                };
            }
            if (name.equals("lowerBounds")) {
                final List<Double> lowers = Adapter.readDoubleArray(in);
                return new Consumer<UncertainBoundedIncrMagFreqDist>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainBoundedIncrMagFreqDist t) {
                        t.lowerBound = Adapter.buildIncrFunc(t, lowers);
                    }
                };
            }
            if (name.equals("upperBounds")) {
                final List<Double> uppers = Adapter.readDoubleArray(in);
                return new Consumer<UncertainBoundedIncrMagFreqDist>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainBoundedIncrMagFreqDist t) {
                        t.upperBound = Adapter.buildIncrFunc(t, uppers);
                    }
                };
            }
            if (name.equals("boundType")) {
                if (in.peek() == JsonToken.NULL) {
                    return null;
                }
                final UncertaintyBoundType boundType = UncertaintyBoundType.valueOf(in.nextString());
                return new Consumer<UncertainBoundedIncrMagFreqDist>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainBoundedIncrMagFreqDist t) {
                        t.boundType = boundType;
                    }
                };
            }
            if (name.equals("boundName")) {
                if (in.peek() == JsonToken.NULL) {
                    return null;
                }
                final String boundName = in.nextString();
                return new Consumer<UncertainBoundedIncrMagFreqDist>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainBoundedIncrMagFreqDist t) {
                        t.boundName = boundName;
                    }
                };
            }
            return super.deserializeExtra(in, name);
        }

        @Override
        protected Class<UncertainBoundedIncrMagFreqDist> getType() {
            return UncertainBoundedIncrMagFreqDist.class;
        }
    }
}

