/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.xyz;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.xyz.AbstractXYZ_DataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.DataUtils;

public abstract class AbstractGeoDataSet
extends AbstractXYZ_DataSet
implements GeoDataSet {
    private static final long serialVersionUID = 1L;
    private boolean latitudeX;

    protected AbstractGeoDataSet(boolean latitudeX) {
        this.latitudeX = latitudeX;
    }

    private DataUtils.MinMaxAveTracker getLatTracker() {
        DataUtils.MinMaxAveTracker tracker = new DataUtils.MinMaxAveTracker();
        for (Location loc : this.getLocationList()) {
            tracker.addValue(loc.getLatitude());
        }
        return tracker;
    }

    private DataUtils.MinMaxAveTracker getLonTracker() {
        DataUtils.MinMaxAveTracker tracker = new DataUtils.MinMaxAveTracker();
        for (Location loc : this.getLocationList()) {
            tracker.addValue(loc.getLongitude());
        }
        return tracker;
    }

    @Override
    public double getMinLat() {
        return this.getLatTracker().getMin();
    }

    @Override
    public double getMaxLat() {
        return this.getLatTracker().getMax();
    }

    @Override
    public double getMinLon() {
        return this.getLonTracker().getMin();
    }

    @Override
    public double getMaxLon() {
        return this.getLonTracker().getMax();
    }

    @Override
    public double getMinX() {
        if (this.latitudeX) {
            return this.getMinLat();
        }
        return this.getMinLon();
    }

    @Override
    public double getMaxX() {
        if (this.latitudeX) {
            return this.getMaxLat();
        }
        return this.getMaxLon();
    }

    @Override
    public double getMinY() {
        if (this.latitudeX) {
            return this.getMinLon();
        }
        return this.getMinLat();
    }

    @Override
    public double getMaxY() {
        if (this.latitudeX) {
            return this.getMaxLon();
        }
        return this.getMaxLat();
    }

    @Override
    public double getMinZ() {
        return this.getZTracker().getMin();
    }

    @Override
    public double getMaxZ() {
        return this.getZTracker().getMax();
    }

    protected DataUtils.MinMaxAveTracker getZTracker() {
        DataUtils.MinMaxAveTracker tracker = new DataUtils.MinMaxAveTracker();
        for (double val : this.getValueList()) {
            tracker.addValue(val);
        }
        return tracker;
    }

    protected Location ptToLoc(Point2D point) {
        if (this.latitudeX) {
            return new Location(point.getX(), point.getY());
        }
        return new Location(point.getY(), point.getX());
    }

    protected Point2D locToPoint(Location loc) {
        if (this.latitudeX) {
            return new Point2D.Double(loc.getLatitude(), loc.getLongitude());
        }
        return new Point2D.Double(loc.getLongitude(), loc.getLatitude());
    }

    @Override
    public void set(Point2D point, double z) {
        this.set(this.ptToLoc(point), z);
    }

    @Override
    public void set(double x, double y, double z) {
        this.set(new Point2D.Double(x, y), z);
    }

    @Override
    public void set(int index, double z) {
        this.set(this.getLocation(index), z);
    }

    @Override
    public void add(Point2D point, double z) {
        this.add(this.ptToLoc(point), z);
    }

    @Override
    public void add(double x, double y, double z) {
        this.add(new Point2D.Double(x, y), z);
    }

    @Override
    public void add(int index, double z) {
        this.add(this.getLocation(index), z);
    }

    @Override
    public void add(Location loc, double z) {
        this.set(loc, z + this.get(loc));
    }

    @Override
    public double get(Point2D point) {
        return this.get(this.ptToLoc(point));
    }

    @Override
    public double get(double x, double y) {
        return this.get(new Point2D.Double(x, y));
    }

    @Override
    public double get(int index) {
        return this.get(this.getLocation(index));
    }

    @Override
    public Point2D getPoint(int index) {
        return this.locToPoint(this.getLocation(index));
    }

    @Override
    public int indexOf(Point2D point) {
        if (point == null) {
            return -1;
        }
        return this.indexOf(this.ptToLoc(point));
    }

    @Override
    public int indexOf(double x, double y) {
        return this.indexOf(new Point2D.Double(x, y));
    }

    @Override
    public boolean contains(Point2D point) {
        if (point == null) {
            return false;
        }
        return this.contains(this.ptToLoc(point));
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public void setAll(XYZ_DataSet dataset) {
        if (dataset instanceof GeoDataSet) {
            GeoDataSet geo = (GeoDataSet)dataset;
            for (int i = 0; i < dataset.size(); ++i) {
                this.set(geo.getLocation(i), geo.get(i));
            }
        } else {
            for (int i = 0; i < dataset.size(); ++i) {
                this.set(dataset.getPoint(i), dataset.get(i));
            }
        }
    }

    @Override
    public void setLatitudeX(boolean latitudeX) {
        this.latitudeX = latitudeX;
    }

    @Override
    public boolean isLatitudeX() {
        return this.latitudeX;
    }

    @Override
    public List<Point2D> getPointList() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (Location loc : this.getLocationList()) {
            points.add(this.locToPoint(loc));
        }
        return points;
    }

    @Override
    public List<Double> getValueList() {
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int i = 0; i < this.size(); ++i) {
            vals.add(this.get(i));
        }
        return vals;
    }
}

