/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.xyz;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.opensha.commons.data.xyz.AbstractGeoDataSet;
import org.opensha.commons.data.xyz.ArbDiscrXYZ_DataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.util.FileUtils;

public class ArbDiscrGeoDataSet
extends AbstractGeoDataSet {
    private static final long serialVersionUID = 1L;
    private LocationList points = new LocationList();
    private HashMap<Location, Double> map = new HashMap();

    public ArbDiscrGeoDataSet(boolean latitudeX) {
        super(latitudeX);
    }

    @Override
    public void set(Location loc, double value) {
        if (loc == null) {
            throw new NullPointerException("Location cannot be null");
        }
        if (!this.contains(loc)) {
            this.points.add(loc);
        }
        this.map.put(loc, value);
    }

    @Override
    public double get(Location loc) {
        return this.map.get(loc);
    }

    @Override
    public int indexOf(Location loc) {
        return this.points.indexOf(loc);
    }

    @Override
    public Location getLocation(int index) {
        return (Location)this.points.get(index);
    }

    @Override
    public boolean contains(Location loc) {
        return this.map.containsKey(loc);
    }

    public static ArbDiscrGeoDataSet loadXYZFile(String fileName, boolean latitudeX) throws FileNotFoundException, IOException {
        ArrayList<String> lines = FileUtils.loadFile(fileName);
        ArbDiscrGeoDataSet xyz = new ArbDiscrGeoDataSet(latitudeX);
        for (String line : lines) {
            double lon;
            double lat;
            StringTokenizer tok;
            if (line.startsWith("#") || line.length() < 2 || (tok = new StringTokenizer(line)).countTokens() < 3) continue;
            if (latitudeX) {
                lat = Double.parseDouble(tok.nextToken());
                lon = Double.parseDouble(tok.nextToken());
            } else {
                lon = Double.parseDouble(tok.nextToken());
                lat = Double.parseDouble(tok.nextToken());
            }
            double val = Double.parseDouble(tok.nextToken());
            xyz.set(new Location(lat, lon), val);
        }
        return xyz;
    }

    public static void writeXYZFile(XYZ_DataSet xyz, String fileName) throws IOException {
        ArbDiscrXYZ_DataSet.writeXYZFile(xyz, fileName);
    }

    public Object clone() {
        return this.copy();
    }

    @Override
    public ArbDiscrGeoDataSet copy() {
        ArbDiscrGeoDataSet data = new ArbDiscrGeoDataSet(this.isLatitudeX());
        for (int i = 0; i < this.size(); ++i) {
            data.set(this.getPoint(i), this.get(i));
        }
        return data;
    }

    @Override
    public LocationList getLocationList() {
        return this.points;
    }

    @Override
    public int size() {
        return this.points.size();
    }
}

