/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.xyz;

import com.google.common.base.Preconditions;
import java.awt.geom.Point2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.xyz.AbstractXYZ_DataSet;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.util.FileUtils;

public class EvenlyDiscrXYZ_DataSet
extends AbstractXYZ_DataSet {
    private static final long serialVersionUID = 1L;
    private double[][] data;
    private int ny;
    private int nx;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double gridSpacingX;
    private double gridSpacingY;

    public EvenlyDiscrXYZ_DataSet(int nx, int ny, double minX, double minY, double gridSpacing) {
        this(nx, ny, minX, minY, gridSpacing, gridSpacing);
    }

    public EvenlyDiscrXYZ_DataSet(int nx, int ny, double minX, double minY, double gridSpacingX, double gridSpacingY) {
        this(new double[ny][nx], minX, minY, gridSpacingX, gridSpacingY);
    }

    public EvenlyDiscrXYZ_DataSet(double[][] data, double minX, double minY, double gridSpacing) {
        this(data, minX, minY, gridSpacing, gridSpacing);
    }

    public EvenlyDiscrXYZ_DataSet(double[][] data, double minX, double minY, double gridSpacingX, double gridSpacingY) {
        this.data = data;
        this.minX = minX;
        this.minY = minY;
        this.gridSpacingX = gridSpacingX;
        this.gridSpacingY = gridSpacingY;
        this.ny = data.length;
        this.nx = data[0].length;
        this.maxX = minX + gridSpacingX * (double)(this.nx - 1);
        this.maxY = minY + gridSpacingY * (double)(this.ny - 1);
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    public double getGridSpacingX() {
        return this.gridSpacingX;
    }

    public double getGridSpacingY() {
        return this.gridSpacingY;
    }

    public int getNumX() {
        return this.nx;
    }

    public int getNumY() {
        return this.ny;
    }

    public void writeXYZBinFile(String fileNamePrefix) throws IOException {
        FileWriter header = new FileWriter(fileNamePrefix + ".hdr");
        header.write("ncols\t" + this.nx + "\n");
        header.write("nrows\t" + this.ny + "\n");
        header.write("xllcorner\t" + this.minX + "\n");
        header.write("yllcorner\t" + this.minY + "\n");
        if (this.gridSpacingX != this.gridSpacingY) {
            header.write("cellsizeX\t" + this.gridSpacingX + "\n");
            header.write("cellsizeY\t" + this.gridSpacingY + "\n");
        } else {
            header.write("cellsize\t" + this.gridSpacingX + "\n");
        }
        header.write("NODATA_value\t-9999\n");
        header.write("byteorder\tLSBFIRST\n");
        header.close();
        DataOutputStream out = new DataOutputStream(new FileOutputStream(fileNamePrefix + ".flt"));
        for (int row = 0; row < this.ny; ++row) {
            for (int col = 0; col < this.nx; ++col) {
                double val = this.get(col, row);
                out.writeFloat((float)val);
            }
        }
        out.close();
    }

    private static String getHeaderValue(ArrayList<String> lines, String key) {
        for (String line : lines) {
            if (!line.startsWith(key)) continue;
            StringTokenizer tok = new StringTokenizer(line);
            tok.nextToken();
            return tok.nextToken();
        }
        return null;
    }

    public static EvenlyDiscrXYZ_DataSet readXYZBinFile(String fileNamePrefix) throws IOException {
        ArrayList<String> lines = FileUtils.loadFile(fileNamePrefix + ".hdr");
        int ncols = Integer.parseInt(EvenlyDiscrXYZ_DataSet.getHeaderValue(lines, "ncols"));
        int nrows = Integer.parseInt(EvenlyDiscrXYZ_DataSet.getHeaderValue(lines, "nrows"));
        double minX = Double.parseDouble(EvenlyDiscrXYZ_DataSet.getHeaderValue(lines, "xllcorner"));
        double minY = Double.parseDouble(EvenlyDiscrXYZ_DataSet.getHeaderValue(lines, "yllcorner"));
        double gridSpacing = Double.parseDouble(EvenlyDiscrXYZ_DataSet.getHeaderValue(lines, "cellsize"));
        DataInputStream reader = new DataInputStream(new FileInputStream(fileNamePrefix + ".flt"));
        EvenlyDiscrXYZ_DataSet data = new EvenlyDiscrXYZ_DataSet(ncols, nrows, minX, minY, gridSpacing);
        for (int row = 0; row < nrows; ++row) {
            for (int col = 0; col < ncols; ++col) {
                double val = reader.readFloat();
                data.set(col, row, val);
            }
        }
        return data;
    }

    public double getX(int xIndex) {
        return this.minX + (double)xIndex * this.gridSpacingX;
    }

    public double getY(int yIndex) {
        return this.minY + (double)yIndex * this.gridSpacingY;
    }

    private int getIndex(double x, double y) {
        int yInd = this.getYIndex(y);
        Preconditions.checkState((yInd >= 0 && yInd < this.getNumY() ? 1 : 0) != 0, (String)"Bad y index. y=%s, yInd=%s, numY=%s, minY=%s, maxY=%s", (Object[])new Object[]{y, yInd, this.getNumY(), this.minY, this.maxY});
        int xInd = this.getXIndex(x);
        Preconditions.checkState((xInd >= 0 && xInd < this.getNumX() ? 1 : 0) != 0, (String)"Bad x index. x=%s, xInd=%s, numX=%s, minX=%s, maxX=%s", (Object[])new Object[]{x, xInd, this.getNumX(), this.minX, this.maxX});
        return xInd + this.nx * yInd;
    }

    private int getXIndex(int index) {
        return index % this.nx;
    }

    private int getYIndex(int index) {
        return index / this.nx;
    }

    public int getYIndex(double y) {
        return this.calcAxisIndex(y, this.minY, this.maxY, this.gridSpacingY, this.ny);
    }

    public int getXIndex(double x) {
        return this.calcAxisIndex(x, this.minX, this.maxX, this.gridSpacingX, this.nx);
    }

    private int calcAxisIndex(double val, double minVal, double maxVal, double spacing, int num) {
        int index = (int)((val - minVal) / spacing + 0.5);
        if (index == -1 && (float)val == (float)(minVal - 0.5 * spacing)) {
            return 0;
        }
        if (index == num && (float)val == (float)(maxVal + 0.5 * spacing)) {
            return num - 1;
        }
        return index;
    }

    @Override
    public void set(Point2D point, double z) {
        this.set(point.getX(), point.getY(), z);
    }

    @Override
    public void set(double x, double y, double z) {
        if (!this.contains(x, y)) {
            throw new InvalidRangeException("point (" + x + ", " + y + ") is out of range: (" + this.minX + "=>" + this.maxX + ", " + this.minY + "=>" + this.maxY + ")");
        }
        this.set(this.getXIndex(x), this.getYIndex(y), z);
    }

    @Override
    public void set(int index, double z) {
        this.set(this.getXIndex(index), this.getYIndex(index), z);
    }

    @Override
    public void add(Point2D point, double z) {
        this.add(point.getX(), point.getY(), z);
    }

    @Override
    public void add(double x, double y, double z) {
        if (!this.contains(x, y)) {
            throw new InvalidRangeException("point (" + x + ", " + y + ") is out of range: (" + this.minX + "=>" + this.maxX + ", " + this.minY + "=>" + this.maxY + ")");
        }
        this.add(this.getXIndex(x), this.getYIndex(y), z);
    }

    @Override
    public void add(int index, double z) {
        this.add(this.getXIndex(index), this.getYIndex(index), z);
    }

    @Override
    public double get(double x, double y) {
        return this.get(this.getXIndex(x), this.getYIndex(y));
    }

    public double bilinearInterpolation(double x, double y) {
        int y0;
        int y1;
        Preconditions.checkArgument((x >= this.minX && x <= this.maxX ? 1 : 0) != 0, (String)"x value of %s outside valid range of [%s %s]", (Object)x, (Object)this.minX, (Object)this.maxX);
        Preconditions.checkArgument((y >= this.minY && y <= this.maxY ? 1 : 0) != 0, (String)"y value of %s outside valid range of [%s %s]", (Object)x, (Object)this.minY, (Object)this.maxY);
        int x0 = this.getIndexBefore(x, this.minX, this.gridSpacingX);
        int x1 = x0 + 1;
        if (x1 >= this.getNumX()) {
            x1 = x0;
        }
        if ((y1 = (y0 = this.getIndexBefore(y, this.minY, this.gridSpacingY)) + 1) >= this.getNumY()) {
            y1 = y0;
        }
        double s00 = this.get(x0, y0);
        double s01 = this.get(x1, y0);
        double s10 = this.get(x0, y1);
        double s11 = this.get(x1, y1);
        double xfrac = (x - this.getX(x0)) / this.gridSpacingX;
        double yfrac = (y - this.getY(y0)) / this.gridSpacingY;
        return (1.0 - yfrac) * ((1.0 - xfrac) * s00 + xfrac * s01) + yfrac * ((1.0 - xfrac) * s10 + xfrac * s11);
    }

    private int getIndexBefore(double val, double min, double gridSpacing) {
        return (int)Math.floor((val - min) / gridSpacing);
    }

    @Override
    public double get(int index) {
        return this.get(this.getXIndex(index), this.getYIndex(index));
    }

    @Override
    public int size() {
        return this.nx * this.ny;
    }

    public void set(int xInd, int yInd, double z) {
        this.data[yInd][xInd] = z;
    }

    public void add(int xInd, int yInd, double z) {
        double[] dArray = this.data[yInd];
        int n = xInd;
        dArray[n] = dArray[n] + z;
    }

    public double get(int xInd, int yInd) {
        return this.data[yInd][xInd];
    }

    @Override
    public double get(Point2D point) {
        return this.get(point.getX(), point.getY());
    }

    @Override
    public Point2D getPoint(int index) {
        return new Point2D.Double(this.getX(this.getXIndex(index)), this.getY(this.getYIndex(index)));
    }

    @Override
    public int indexOf(Point2D point) {
        return this.indexOf(point.getX(), point.getY());
    }

    @Override
    public boolean contains(Point2D point) {
        return this.contains(point.getX(), point.getY());
    }

    @Override
    public boolean contains(double x, double y) {
        return (float)x >= (float)this.minX && (float)x <= (float)this.maxX && (float)y >= (float)this.minY && (float)y <= (float)this.maxY;
    }

    public Object clone() {
        return this.copy();
    }

    @Override
    public EvenlyDiscrXYZ_DataSet copy() {
        EvenlyDiscrXYZ_DataSet xyz = new EvenlyDiscrXYZ_DataSet(this.nx, this.ny, this.minX, this.minY, this.gridSpacingX, this.gridSpacingY);
        for (int x = 0; x < this.nx; ++x) {
            for (int y = 0; y < this.ny; ++y) {
                xyz.set(x, y, this.get(x, y));
            }
        }
        return xyz;
    }

    @Override
    public int indexOf(double x, double y) {
        return this.getIndex(x, y);
    }

    public EvenlyDiscretizedFunc calcMarginalXDist() {
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(this.minX, this.nx, this.gridSpacingX);
        for (int xInd = 0; xInd < this.nx; ++xInd) {
            double sum = 0.0;
            for (int yInd = 0; yInd < this.ny; ++yInd) {
                double val = this.get(xInd, yInd);
                if (Double.isNaN(val)) continue;
                sum += val;
            }
            func.set(xInd, sum);
        }
        return func;
    }

    public EvenlyDiscretizedFunc calcMarginalYDist() {
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(this.minY, this.ny, this.gridSpacingY);
        for (int yInd = 0; yInd < this.ny; ++yInd) {
            double sum = 0.0;
            for (int xInd = 0; xInd < this.nx; ++xInd) {
                double val = this.get(xInd, yInd);
                if (Double.isNaN(val)) continue;
                sum += val;
            }
            func.set(yInd, sum);
        }
        return func;
    }

    public EvenlyDiscretizedFunc getRow(int yInd) {
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(this.minX, this.nx, this.gridSpacingX);
        for (int xInd = 0; xInd < this.nx; ++xInd) {
            func.set(xInd, this.get(xInd, yInd));
        }
        return func;
    }

    public EvenlyDiscretizedFunc getCol(int xInd) {
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(this.minY, this.ny, this.gridSpacingY);
        for (int yInd = 0; yInd < this.ny; ++yInd) {
            func.set(yInd, this.get(xInd, yInd));
        }
        return func;
    }

    public EvenlyDiscretizedFunc getDiag(int xInd, int yInd) {
        int numY;
        int numX = this.getNumX() - xInd;
        int num = numX < (numY = this.getNumY() - yInd) ? numX : numY;
        double dist = Math.sqrt(this.gridSpacingX * this.gridSpacingX + this.gridSpacingY * this.gridSpacingY);
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(0.0, this.ny, dist);
        for (int index = 0; index < num; ++index) {
            func.set(index, this.get(xInd, yInd));
            ++xInd;
            ++yInd;
        }
        return func;
    }
}

