/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.filters;

import org.opensha.commons.eq.cat.MutableCatalog;
import org.opensha.commons.eq.cat.filters.CatalogFilter;
import org.opensha.commons.eq.cat.filters.ExtentsFilter;
import org.opensha.commons.eq.cat.util.DataType;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;

public class RadialFilter
implements CatalogFilter {
    public static final double MAX_SEARCH_RADIUS = 2000.0;
    private Location center;
    private double radius;
    private Long timeStart;
    private Long timeEnd;
    private ExtentsFilter extents = new ExtentsFilter();

    public RadialFilter() {
        this.reset();
    }

    public RadialFilter(Location center, double radius) {
        this(center, radius, null, null);
    }

    public RadialFilter(Location center, double radius, Long start, Long end) {
        this.setCircle(center, radius);
        this.setTimeWindow(start, end);
    }

    public void setTimeWindow(Long start, Long end) {
        this.timeStart = start;
        this.timeEnd = end;
    }

    public void setCircle(Location center, double radius) {
        this.validateRadius(radius);
        this.center = center;
        this.radius = radius;
    }

    public double getRadius() {
        return this.radius;
    }

    public Location getCenter() {
        return this.center;
    }

    public long getTimeWindowStart() {
        return this.timeStart;
    }

    public long getTimeWindowEnd() {
        return this.timeEnd;
    }

    public final void reset() {
        this.center = null;
        this.radius = -1.0;
        this.timeStart = null;
        this.timeEnd = null;
    }

    private void validateRadius(double radius) {
        if (radius <= 0.0 || radius > 2000.0) {
            throw new IllegalArgumentException("RadialFilter: Radius must be a positive value and less than2000.0(km).");
        }
    }

    @Override
    public int[] process(MutableCatalog catalog) {
        int[] indicesOut;
        if (this.center == null) {
            return null;
        }
        double latDegrees = GeoTools.degreesLatPerKm(this.center) * this.radius;
        double lonDegrees = GeoTools.degreesLonPerKm(this.center) * this.radius;
        double latMin = this.center.getLatitude() - latDegrees;
        double latMax = this.center.getLatitude() + latDegrees;
        double lonMin = this.center.getLongitude() - lonDegrees;
        double lonMax = this.center.getLongitude() + lonDegrees;
        this.extents.setLatitudes(latMin, latMax).setLongitudes(lonMin, lonMax).setDates(this.timeStart, this.timeEnd);
        int count = 0;
        int[] indices = this.extents.process(catalog);
        if (indices == null) {
            return null;
        }
        double[] eq_latitude = (double[])catalog.getData(DataType.LATITUDE);
        double[] eq_longitude = (double[])catalog.getData(DataType.LONGITUDE);
        for (int i = 0; i < indices.length; ++i) {
            Location p = new Location(eq_latitude[indices[i]], eq_longitude[indices[i]]);
            if (!(LocationUtils.horzDistanceFast(this.center, p) <= this.radius)) continue;
            indices[count] = indices[i];
            ++count;
        }
        if (count != 0) {
            indicesOut = new int[count];
            System.arraycopy(indices, 0, indicesOut, 0, count);
        } else {
            indicesOut = null;
        }
        return indicesOut;
    }
}

