/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.io;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.opensha.commons.eq.cat.Catalog;
import org.opensha.commons.eq.cat.io.CatalogReader;

public abstract class AbstractReader
implements CatalogReader {
    private String name = "Unnamed reader";
    private String desc = "No description for reader";
    protected List<Integer> dat_eventIDs;
    protected List<Long> dat_dates;
    protected List<Double> dat_longitudes;
    protected List<Double> dat_latitudes;
    protected List<Double> dat_depths;
    protected List<Double> dat_magnitudes;
    protected List<Integer> dat_magnitudeTypes;
    protected List<Integer> dat_eventTypes;
    protected List<Integer> dat_eventQuality;
    protected List<Double> dat_xyErrors;
    protected List<Double> dat_zErrors;
    protected List<Integer> dat_fpStrikes;
    protected List<Integer> dat_fpDips;
    protected List<Integer> dat_fpRakes;
    protected final GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    protected Catalog catalog;
    protected int size;

    public AbstractReader(String name, String desc, int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Supplied size must be positive");
        Preconditions.checkArgument((size <= 800000 ? 1 : 0) != 0, (Object)"Supplied size is too large");
        this.size = size;
        this.name = name != null ? name : this.name;
        this.desc = desc != null ? desc : this.desc;
    }

    public abstract void initReader();

    public abstract void parseLine(String var1);

    public abstract void loadData();

    @Override
    public void process(File file, Catalog catalog) throws IOException {
        String line;
        Preconditions.checkNotNull((Object)file, (Object)"Supplied file is null");
        Preconditions.checkNotNull((Object)catalog, (Object)"Supplied catalog is null");
        this.catalog = catalog;
        BufferedReader br = null;
        this.initReader();
        br = new BufferedReader(new FileReader(file));
        while ((line = br.readLine()) != null) {
            this.parseLine(line);
        }
        this.loadData();
        this.clearArrays();
        IOUtils.closeQuietly((Reader)br);
    }

    private void clearArrays() {
        this.dat_eventIDs = null;
        this.dat_eventTypes = null;
        this.dat_dates = null;
        this.dat_longitudes = null;
        this.dat_latitudes = null;
        this.dat_depths = null;
        this.dat_magnitudes = null;
        this.dat_magnitudeTypes = null;
        this.dat_eventQuality = null;
        this.dat_xyErrors = null;
        this.dat_zErrors = null;
        this.dat_fpStrikes = null;
        this.dat_fpDips = null;
        this.dat_fpRakes = null;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String description() {
        return this.desc;
    }
}

