/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.io;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import org.opensha.commons.eq.cat.io.AbstractReader;
import org.opensha.commons.eq.cat.util.DataType;

public class Reader_Basic
extends AbstractReader {
    private static final String NAME = "Basic Format Reader";
    private static final String DESC = "Parses a simply formatted catalog. Reader will gather: event ID, time, longitude, latitude, depth, and magnitude.";
    private int count;

    public Reader_Basic(int size) {
        super(NAME, DESC, size);
    }

    @Override
    public void initReader() {
        this.count = 0;
        this.dat_eventIDs = new ArrayList(this.size);
        this.dat_dates = new ArrayList(this.size);
        this.dat_longitudes = new ArrayList(this.size);
        this.dat_latitudes = new ArrayList(this.size);
        this.dat_depths = new ArrayList(this.size);
        this.dat_magnitudes = new ArrayList(this.size);
    }

    @Override
    public void loadData() {
        this.catalog.addData(DataType.EVENT_ID, Ints.toArray((Collection)this.dat_eventIDs));
        this.catalog.addData(DataType.TIME, Longs.toArray((Collection)this.dat_dates));
        this.catalog.addData(DataType.LONGITUDE, Doubles.toArray((Collection)this.dat_longitudes));
        this.catalog.addData(DataType.LATITUDE, Doubles.toArray((Collection)this.dat_latitudes));
        this.catalog.addData(DataType.DEPTH, Doubles.toArray((Collection)this.dat_depths));
        this.catalog.addData(DataType.MAGNITUDE, Doubles.toArray((Collection)this.dat_magnitudes));
    }

    @Override
    public void parseLine(String line) {
        try {
            ++this.count;
            this.cal.set(1, Integer.parseInt(line.substring(42, 46)));
            this.cal.set(2, Integer.parseInt(line.substring(47, 49)) - 1);
            this.cal.set(5, Integer.parseInt(line.substring(50, 52)));
            this.cal.set(11, Integer.parseInt(line.substring(53, 55)));
            this.cal.set(12, Integer.parseInt(line.substring(56, 58)));
            this.cal.set(13, Integer.parseInt(line.substring(59, 61)));
            this.cal.set(14, 0);
            this.dat_dates.add(this.cal.getTimeInMillis());
            this.dat_magnitudes.add(Double.parseDouble(line.substring(37, 41).trim()));
            this.dat_latitudes.add(Double.parseDouble(line.substring(20, 28).trim()));
            this.dat_longitudes.add(Double.parseDouble(line.substring(10, 19).trim()));
            this.dat_depths.add(Double.parseDouble(line.substring(29, 36).trim()));
            this.dat_eventIDs.add(Integer.parseInt(line.substring(0, 9).trim()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error reading catalog file format at line: " + this.count);
        }
    }
}

