/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.io;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import org.opensha.commons.eq.cat.io.AbstractReader;
import org.opensha.commons.eq.cat.util.DataType;

public class Reader_NC_PARK
extends AbstractReader {
    private static final String NAME = "";
    private static final String DESC = "";
    private int count;

    public Reader_NC_PARK(int size) {
        super("", "", size);
    }

    @Override
    public void initReader() {
        this.count = 0;
        this.dat_eventIDs = new ArrayList(this.size);
        this.dat_dates = new ArrayList(this.size);
        this.dat_longitudes = new ArrayList(this.size);
        this.dat_latitudes = new ArrayList(this.size);
        this.dat_depths = new ArrayList(this.size);
        this.dat_magnitudes = new ArrayList(this.size);
    }

    @Override
    public void loadData() {
        this.catalog.addData(DataType.EVENT_ID, Ints.toArray((Collection)this.dat_eventIDs));
        this.catalog.addData(DataType.TIME, Longs.toArray((Collection)this.dat_dates));
        this.catalog.addData(DataType.LONGITUDE, Doubles.toArray((Collection)this.dat_longitudes));
        this.catalog.addData(DataType.LATITUDE, Doubles.toArray((Collection)this.dat_latitudes));
        this.catalog.addData(DataType.DEPTH, Doubles.toArray((Collection)this.dat_depths));
        this.catalog.addData(DataType.MAGNITUDE, Doubles.toArray((Collection)this.dat_magnitudes));
    }

    @Override
    public void parseLine(String line) {
        try {
            ++this.count;
            this.cal.set(1, Integer.parseInt(line.substring(2, 6).trim()));
            this.cal.set(2, Integer.parseInt(line.substring(7, 9).trim()) - 1);
            this.cal.set(5, Integer.parseInt(line.substring(10, 12).trim()));
            this.cal.set(11, Integer.parseInt(line.substring(13, 15).trim()));
            this.cal.set(12, Integer.parseInt(line.substring(16, 18).trim()));
            this.cal.set(13, Integer.parseInt(line.substring(19, 21).trim()));
            this.cal.set(14, Integer.parseInt(line.substring(22, 24).trim()) * 10);
            this.dat_dates.add(this.cal.getTimeInMillis());
            this.dat_magnitudes.add(Double.parseDouble(line.substring(54, 57).trim()));
            this.dat_latitudes.add(Double.parseDouble(line.substring(24, 34).trim()));
            this.dat_longitudes.add(Double.parseDouble(line.substring(35, 46).trim()));
            this.dat_depths.add(Double.parseDouble(line.substring(47, 53).trim()));
            this.dat_eventIDs.add(Integer.parseInt(line.substring(59, 68).trim()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error reading catalog file format at line: " + this.count);
        }
    }
}

