/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.io;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import org.opensha.commons.eq.cat.io.AbstractReader;
import org.opensha.commons.eq.cat.util.DataType;
import org.opensha.commons.eq.cat.util.EventQuality;
import org.opensha.commons.geo.GeoTools;

public class Reader_SCSN
extends AbstractReader {
    private static final String NAME = "Southern California Seismic Network (SCSN)";
    private static final String DESC = "Parses a Southern California Seismic Network (SCSN a.k.a CATREAD or CALTECH) format catalog. Reader will gather: event ID, time, longitude, latitude, depth, location quality, and magnitude.";
    private int count;

    public Reader_SCSN(int size) {
        super(NAME, DESC, size);
    }

    @Override
    public void initReader() {
        this.count = 0;
        this.dat_eventIDs = new ArrayList(this.size);
        this.dat_dates = new ArrayList(this.size);
        this.dat_longitudes = new ArrayList(this.size);
        this.dat_latitudes = new ArrayList(this.size);
        this.dat_depths = new ArrayList(this.size);
        this.dat_magnitudes = new ArrayList(this.size);
        this.dat_eventQuality = new ArrayList(this.size);
    }

    @Override
    public void loadData() {
        this.catalog.addData(DataType.EVENT_ID, Ints.toArray((Collection)this.dat_eventIDs));
        this.catalog.addData(DataType.TIME, Longs.toArray((Collection)this.dat_dates));
        this.catalog.addData(DataType.LONGITUDE, Doubles.toArray((Collection)this.dat_longitudes));
        this.catalog.addData(DataType.LATITUDE, Doubles.toArray((Collection)this.dat_latitudes));
        this.catalog.addData(DataType.DEPTH, Doubles.toArray((Collection)this.dat_depths));
        this.catalog.addData(DataType.MAGNITUDE, Doubles.toArray((Collection)this.dat_magnitudes));
        this.catalog.addData(DataType.QUALITY, Ints.toArray((Collection)this.dat_eventQuality));
    }

    @Override
    public void parseLine(String line) {
        try {
            ++this.count;
            if (line.startsWith("#") || line.length() < 60) {
                return;
            }
            this.cal.set(1, Integer.parseInt(line.substring(0, 4)));
            this.cal.set(2, Integer.parseInt(line.substring(5, 7)) - 1);
            this.cal.set(5, Integer.parseInt(line.substring(8, 10)));
            this.cal.set(11, Integer.parseInt(line.substring(12, 14)));
            this.cal.set(12, Integer.parseInt(line.substring(15, 17)));
            this.cal.set(13, Integer.parseInt(line.substring(18, 20)));
            this.cal.set(14, Integer.parseInt(line.substring(21, 23)) * 10);
            this.dat_dates.add(this.cal.getTimeInMillis());
            this.dat_magnitudes.add(Double.parseDouble(line.substring(46, 49).trim()));
            this.dat_latitudes.add(GeoTools.toDecimalDegrees(Double.parseDouble(line.substring(24, 27).trim()), Double.parseDouble(line.substring(28, 33).trim())));
            this.dat_longitudes.add(GeoTools.toDecimalDegrees(Double.parseDouble(line.substring(33, 37).trim()), Double.parseDouble(line.substring(38, 43).trim())));
            this.dat_depths.add(Double.parseDouble(line.substring(53, 59).trim()));
            this.dat_eventQuality.add(EventQuality.parse(line.substring(44, 45)).id());
            this.dat_eventIDs.add(Integer.parseInt(line.substring(72, 80).trim()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error reading catalog file format at line: " + this.count);
        }
    }
}

