/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.opensha.commons.eq.cat.io.AbstractWriter;
import org.opensha.commons.eq.cat.util.DataType;

public class Writer_Basic
extends AbstractWriter {
    private static final String NAME = "Basic Output Format";
    private static final String DESC = "Writes a catalog to file with EventID, lon, lat, depth, mag, and date.";
    private PrintWriter writer;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy MM dd HH mm ss");
    private String eventFormat = "%09d %9.4f %8.4f %7.3f %4.2f %s\n";

    public Writer_Basic() {
        super(NAME, DESC);
    }

    @Override
    public void initWriter(PrintWriter writer) {
        Preconditions.checkNotNull((Object)writer, (Object)"Supplied PrintWriter is null");
        this.writer = writer;
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dat_eventIDs = (int[])this.catalog.getData(DataType.EVENT_ID);
        this.dat_dates = (long[])this.catalog.getData(DataType.TIME);
        this.dat_longitudes = (double[])this.catalog.getData(DataType.LONGITUDE);
        this.dat_latitudes = (double[])this.catalog.getData(DataType.LATITUDE);
        this.dat_depths = (double[])this.catalog.getData(DataType.DEPTH);
        this.dat_magnitudes = (double[])this.catalog.getData(DataType.MAGNITUDE);
    }

    @Override
    public void writeLine(int index) throws IOException {
        Preconditions.checkArgument((index < this.catalog.size() ? 1 : 0) != 0, (Object)("Index [" + index + "] is out of range for catalog"));
        try {
            this.cal.setTimeInMillis(this.dat_dates[index]);
            Object[] dataOut = new Object[]{this.dat_eventIDs[index], this.dat_longitudes[index], this.dat_latitudes[index], this.dat_depths[index], this.dat_magnitudes[index], this.dateFormat.format(this.cal.getTime())};
            this.writer.printf(this.eventFormat, dataOut);
        }
        catch (Exception e) {
            throw new IOException("Error writing catalog at line (" + index + ")");
        }
    }
}

