/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.stat;

import org.opensha.commons.util.DataUtils;

public class Omori {
    private double K;
    private double c;
    private double p;
    private double p_one;
    private double one_p;

    public Omori(double p, double c, double K) {
        this.setProductivity(K);
        this.setOffset(c);
        this.setP(p);
    }

    public Omori(double p, double c) {
        this(p, c, 1.0);
    }

    public double eventProbability(double t) {
        return Math.pow(1.0 + t / this.c, this.one_p);
    }

    public double eventTime(double probability) {
        return (Math.pow(probability, 1.0 / this.one_p) - 1.0) * this.c;
    }

    public int meanEvents() {
        return (int)Math.round(this.K * Math.pow(this.c, this.one_p) / this.p_one);
    }

    public int meanEvents(double t) {
        return (int)Math.round(this.K / this.one_p * (Math.pow(t + this.c, this.one_p) - Math.pow(this.c, this.one_p)));
    }

    public int meanEvents(double tMin, double tMax) {
        return (int)Math.round(this.K / this.one_p * (Math.pow(tMax + this.c, this.one_p) - Math.pow(tMin + this.c, this.one_p)));
    }

    public double intensityValue(double t) {
        return this.p_one * Math.pow(this.c, this.p_one) / Math.pow(t + this.c, this.p);
    }

    public double intensityInverse(double i) {
        return Math.pow(this.p_one * Math.pow(this.c, this.p_one) / i, 1.0 / this.p) - this.c;
    }

    public double intensityAtZero() {
        return this.p_one / this.c;
    }

    private double ccdfValue(double t) {
        return Math.pow((t + this.c) / this.c, this.one_p);
    }

    public double[] generateTimes(double length) {
        double ccdfMax = 1.0;
        double ccdfMin = this.ccdfValue(length);
        double ccdfDelta = ccdfMax - ccdfMin;
        int sequenceSize = this.meanEvents(length);
        double[] values = DataUtils.randomValues(sequenceSize);
        for (int i = 0; i < sequenceSize; ++i) {
            double ccdfValue = values[i] * ccdfDelta + ccdfMin;
            values[i] = this.eventTime(ccdfValue);
        }
        return values;
    }

    public double getOffset() {
        return this.c;
    }

    public void setOffset(double c) {
        this.c = c;
    }

    public double getProductivity() {
        return this.K;
    }

    public void setProductivity(double K) {
        this.K = K;
    }

    public double getP() {
        return this.p;
    }

    public void setP(double p) {
        this.p = p == 1.0 ? 1.0000001 : p;
        this.p_one = p - 1.0;
        this.one_p = 1.0 - p;
    }

    public String toString() {
        String s = "Modified Omori Law:\n   p=" + this.p + "\n   c=" + this.c + "\n   K=" + this.K + "\n";
        return s;
    }

    public static void main(String[] args) {
        Omori mol = new Omori(0.9999999, 0.01, 100.0);
        System.out.println(mol.intensityValue(3.0));
    }
}

